package com.bingougame.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.util.Log;

import com.bingougame.sdk.plugins.JsonParser;
import com.bingougame.tgsw.ChannelConst;
import com.bingougame.tgsw.UnityPlayerActivity;
import com.loopj.android.http.AsyncHttpClient;
import com.quicksdk.BaseCallBack;
import com.quicksdk.Extend;
import com.quicksdk.FuncType;
import com.quicksdk.QuickSDK;
import com.quicksdk.Sdk;
import com.quicksdk.User;
import com.quicksdk.entity.GameRoleInfo;
import com.quicksdk.entity.OrderInfo;
import com.quicksdk.entity.UserInfo;
import com.quicksdk.notifier.ExitNotifier;
import com.quicksdk.notifier.InitNotifier;
import com.quicksdk.notifier.LoginNotifier;
import com.quicksdk.notifier.LogoutNotifier;
import com.quicksdk.notifier.PayNotifier;
import com.quicksdk.notifier.SwitchAccountNotifier;
import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

import static com.unity3d.player.UnityPlayer.UnitySendMessage;

//import com.chujian.sdk.PayParams;
//import com.qk.game.MainActivity;


public class ChannelCW extends ChannelInstance {
    private AsyncHttpClient mHttpClient;
    public static final String LOG_TAG = "tgsw";
    public static final String LOCAL_ACTION = "com.bingougame.tgsw";
    private WaitingDialog mWaitingDialog;

    private Activity mActivity;
    private static ChannelCW mInstance;
    private String mCurrentRoleId = null;
    private String mCurrentServerId = null;

    private String mUserName = null;//用户名
    private String mUserId = null;//用户ID
    private String mOrderId = null;
    private JSONObject mCurrentPayInfo = null;
    private GameRoleInfo mRoleInfo = new GameRoleInfo();
    private String mCurrentProductId = null;   //游戏订单号
    private boolean isAcceptPrva = false;
    private int mUnderAge = 0;
    private boolean IsInitSucc=false;
    private boolean mIsSwitchAccount=false;
    private String mChannelId=null;
    private String mToken=null;
    private String mRoleCreateTime = null;
	//联运自发版本
    public static final String mProductCode = "85925103228334879295963797584312";
    private String mProductKey = "91542675";
    //长尾
    //private String mProductCode = "19519771497281182200350775961483";
    //private String mProductKey = "44431156";

    public static ChannelCW getInstance(){
        return mInstance;
    }

    @Override
    public void init(Context context){
        super.init(context);
        QKDot.Instance().RecordDot("SDKInit");

        mActivity = (Activity)context;
        mInstance = this;

        // 设置横竖屏，游戏横屏为true，游戏竖屏为false(必接)
        // QuickSDK.getInstance().setIsLandScape(isLandscape);
        BGGLog.getInstance().d("CWChannel init #1");

        QuickSDK.getInstance().setIsLandScape(true);
       // requestPermission();
        initQkNotifiers();

        Sdk.getInstance().init(mActivity,mProductCode,mProductKey);
        BGGLog.getInstance().d("CWChannel init #2");
        Sdk.getInstance().onCreate(mActivity);
    }

    @Override
    public void onWindowFocusChanged() {
        super.onWindowFocusChanged();
    }


//    @Override
//    public void onCreate(Bundle savedInstanceState)
//    {
//        super.onCreate(savedInstanceState);   //todo
//    }

    @Override
    public void onStart() {
        super.onStart();
        Sdk.getInstance().onStart(mActivity);
    }
    @Override
    public void onRestart() {
        super.onRestart();
        Sdk.getInstance().onRestart(mActivity);
    }
    @Override
    public void onPause() {
        super.onPause();
        Sdk.getInstance().onPause(mActivity);
    }
    @Override
    public void onResume() {
        super.onResume();
        Sdk.getInstance().onResume(mActivity);
    }
    @Override
    public void onStop() {
        super.onStop();
        Sdk.getInstance().onStop(mActivity);
    }

    @Override
    public void onDestroyBeforeGame() {
        super.onDestroyBeforeGame();
    }

    @Override
    public void onDestroyAfterGame() {
        Log.d(LOG_TAG, "onDestroy");

        super.onDestroyAfterGame();
        com.quicksdk.Sdk.getInstance().onDestroy(mActivity);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Sdk.getInstance().onNewIntent(intent);
    }
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Sdk.getInstance().onActivityResult(mActivity,requestCode,resultCode,data);
    }
    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void onFinishLoaded(long duration)//加载时长
    {
    }
    //手动登出
    public void logout() {
        BGGLog.getInstance().d("onRoleLogout #2");
        com.quicksdk.User.getInstance().logout(mActivity);
    }
    public void RecordDot(String eventCode)
    {
        QKDot.Instance().RecordDot(eventCode);
    }
    public String login() {
        //Toast.makeText(mActivity, "============login=======" , Toast.LENGTH_LONG).show();
        BGGLog.getInstance().d("login");
        if(!IsInitSucc){
            BGGLog.getInstance().d("初始化失败");
            showToastTips("初始化失败");
            return null;
        }
        //切换账号成功后不需要调用登陆接口   直接返回登录成功
        if(mIsSwitchAccount){
            mIsSwitchAccount=false;
            HashMap<String,String> Map = new HashMap<String,String>();
            Map.put("userId", mUserId);
            Map.put("userName", mUserName);
            Map.put("token", mToken);
            Map.put("channelCode", getCurrChannel());
            BGGLog.getInstance().d("切换账号成功后 登陆成功");
            String SendStr = JsonParser.simpleMapToJsonStr(Map);
            UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);

            return null;
        }

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                com.quicksdk.User.getInstance().login(mActivity);
            }
        });


        return null;
    }

    public void showUserCenter()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                BGGLog.getInstance().d("showUserCenter #1");
                //TODO 个人中心参数配置

            }
        });
    }
    public void onSaved(String uId, String userName, String roleId, String roleName, int level, int gender, int age, String gameServer) {
    }
    /**
     * 设置通知，用于监听初始化，登录，注销，支付及退出功能的返回值
     */
    private void initQkNotifiers() {
        BGGLog.getInstance().d("InitSdk #1");

        QuickSDK.getInstance()
                // 1.设置初始化通知(必接)
                .setInitNotifier(new InitNotifier() {

                    @Override
                    public void onSuccess() {
                        //Toast.makeText(mActivity, "初始化成功" , Toast.LENGTH_LONG).show();
                        // todo KOREA getCurrChannel();
                        IsInitSucc=true;
                        BGGLog.getInstance().d("初始化成功");
                    }

                    @Override
                    public void onFailed(String message, String trace) {
                        //Toast.makeText(mActivity, "初始化失败" , Toast.LENGTH_LONG).show();
                        IsInitSucc=false;
                        BGGLog.getInstance().d("初始化失败");
                    }
                });
                // 2.设置登录通知(必接)
        QuickSDK.getInstance().setLoginNotifier(new LoginNotifier() {

                    @Override
                    public void onSuccess(UserInfo userInfo) {
                        if(userInfo ==null){
                            //Toast.makeText(mActivity, "userInfo ==null" , Toast.LENGTH_LONG).show();
                            BGGLog.getInstance().d("userInfo ==null");
                            return;
                        }
                        BGGLog.getInstance().d("开始登陆");
                        //Toast.makeText(mActivity, "开始登陆" , Toast.LENGTH_LONG).show();
                        mChannelId = Extend.getInstance().getExtrasConfig("channelId");
                        if(mChannelId==null||mChannelId=="")
                        {
                            mChannelId= getCurrChannel();
                        }
                           // mChannelId = ChannelConst.CHAN_ID_CHANGWEI;
                            mUserId = userInfo.getUID();
                            HashMap<String,String> Map = new HashMap<String,String >();
                            Map.put("userId", userInfo.getUID());
                            Map.put("sdkUserId",userInfo.getUID());
                            Map.put("userName",userInfo.getUserName());
                            Map.put("sessionId",userInfo.getToken());
                            Map.put("channelCode", getCurrChannel());
                            // Map.put("Age",userInfo.getAge());
                            BGGLog.getInstance().d("登陆成功");
                            //Toast.makeText(mActivity, "登陆成功" , Toast.LENGTH_LONG).show();

                            String SendStr = JsonParser.simpleMapToJsonStr(Map);

                            UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);

                            Log.d("LOGTAG", SendStr);
                    }

                    @Override
                    public void onCancel() {
                        //登录取消
                        UnitySendMessage("GameManagerObject", "SDKLoginFail", "");
                        //Toast.makeText(mActivity, "取消登陆" , Toast.LENGTH_LONG).show();
                        BGGLog.getInstance().d("取消登陆");
                    }

                    @Override
                    public void onFailed(final String message, String trace) {
                       // Toast.makeText(mActivity, "登陆失败==" + message , Toast.LENGTH_LONG).show();
                        BGGLog.getInstance().d("登陆失败"+ message);
                        UnityPlayer.UnitySendMessage("GameManagerObject", "AndroidBackToLogin", "");
                    }

                });
                // 3.设置注销通知(必接)
        QuickSDK.getInstance().setLogoutNotifier(new LogoutNotifier() {

                    @Override
                    public void onSuccess() {
                        //获取到注销成功的通知后  游戏应返回登陆界面并重新调用登录方法
                       // Toast.makeText(mActivity, "注销成功==" , Toast.LENGTH_LONG).show();
                        //todo 需不需要把各种账号信息都设置为空？
                        BGGLog.getInstance().d("onRoleLogout #1");
                        UnityPlayer.UnitySendMessage("GameManagerObject", "AndroidBackToLogin","");
                    }

                    @Override
                    public void onFailed(String message, String trace) {
                        //Toast.makeText(mActivity, "注销失败==" + message , Toast.LENGTH_LONG).show();
                        BGGLog.getInstance().d("注销失败");
                        //注销失败 不做处理
                    }
                });
                // 4.设置切换账号通知(必接)
        QuickSDK.getInstance().setSwitchAccountNotifier(new SwitchAccountNotifier() {

                    @Override
                    public void onSuccess(UserInfo userInfo) {  //切换成功的回调  返回新账号的userInfo

                        if(userInfo ==null)
                            return;
                        //先返回登录界面
                        UnityPlayer.UnitySendMessage("GameManagerObject", "AndroidBackToLogin", "");
                        mIsSwitchAccount=true;
                        BGGLog.getInstance().d("切换账号成功====");
                        //Toast.makeText(mActivity, "切换账号成功==" , Toast.LENGTH_LONG).show();
                        mChannelId = Extend.getInstance().getExtrasConfig("channelId");
                        if(mChannelId==null||mChannelId=="")
                        {
                            mChannelId= getCurrChannel();
                        }
                        //登录成功，获取到用户信息userInfo
                        //通过userInfo中的UID、token做服务器登录认证
                        mUserId = userInfo.getUID();
                        mUserName=userInfo.getUserName();
                        mToken=userInfo.getToken();
                    }

                    @Override
                    public void onFailed(String message, String trace) {
                        mIsSwitchAccount=false;
                        BGGLog.getInstance().d("切换账号失败====");
                       // Toast.makeText(mActivity, "切换账号失败==" + message , Toast.LENGTH_LONG).show();
                    }

                    @Override
                    public void onCancel() {
                        mIsSwitchAccount=false;
                        BGGLog.getInstance().d("取消切换账号====");
                       // Toast.makeText(mActivity, "取消切换账号=="  , Toast.LENGTH_LONG).show();
                    }
                });
                // 5.设置支付通知(必接)
        QuickSDK.getInstance().setPayNotifier(new PayNotifier() {

                    @Override
                    public void onSuccess(String sdkOrderID, String cpOrderID, String extrasParams) {
                        //sdkOrderID:quick 订单号  cpOrderID：游戏订单号
                        stopWaiting();
                        showToastTips("支付成功");
                        BGGLog.getInstance().d("支付成功===="+mCurrentProductId);
                        //Toast.makeText(mActivity, "支付成功==" +mCurrentProductId , Toast.LENGTH_LONG).show();
                        if( mCurrentPayInfo != null)
                            UnityPlayer.UnitySendMessage("GameManagerObject", "OnPayCallBack", mCurrentProductId);
                    }

                    @Override
                    public void onCancel(String cpOrderID) {
                        BGGLog.getInstance().d("支付取消===="+cpOrderID);
                        // Toast.makeText(mActivity, "支付取消=="  , Toast.LENGTH_LONG).show();
                        showToastTips("支付取消");
                    }

                    @Override
                    public void onFailed(String cpOrderID, String message, String trace) {
                        BGGLog.getInstance().d("支付失败==" +message  +"===cpOrderID====" + cpOrderID);
                        //Toast.makeText(mActivity, "支付失败==" +message  +"===cpOrderID====" + cpOrderID, Toast.LENGTH_LONG).show();
                        showToastTips("支付失败："+message);
                    }
                });
                // 6.设置退出通知(必接)
        QuickSDK.getInstance().setExitNotifier(new ExitNotifier() {

                    @Override
                    public void onSuccess() {
                        BGGLog.getInstance().d("ExitNotifier");
                        // 进行游戏本身的退出操作，下面的finish()只是示例
                       // UnityPlayer.UnitySendMessage("GameManagerObject", "ShowExitGameMsgBox","");
                        mActivity.finish();
                        System.exit(0);
                    }

                    @Override
                    public void onFailed(String message, String trace) {
                        //Toast.makeText(mActivity, "退出失败==" +message , Toast.LENGTH_LONG).show();
                        BGGLog.getInstance().d("退出失败==" +message);
                        //退出失败  不做处理
                    }
                });
        BGGLog.getInstance().d("InitSdk #5");
    }

    public void exitGame(){
        if(QuickSDK.getInstance().isShowExitDialog()){
            BGGLog.getInstance().d("exitGame.exit");
            Sdk.getInstance().exit(mActivity);
        }else{
            BGGLog.getInstance().d("exitGame.ShowExitGameMsgBox");
            // 游戏调用自身的退出对话框，点击确定后，调用quick的exit接口
           UnityPlayer.UnitySendMessage("GameManagerObject", "ShowExitGameMsgBox", "");
        }
    }
    public void vipLevelChange(String vipStr)
    {
        if(null != roleInfo) {
            roleInfo.setVipLevel(vipStr); //VIP等级
        }
    }
    GameRoleInfo roleInfo = new GameRoleInfo();
    /**
     * 支付
     */
    public String pay(String orderData) {
        try {
            //Toast.makeText(mActivity, "=====pay==orderData==="+orderData , Toast.LENGTH_LONG).show();
            JSONObject jsonObject = new JSONObject(orderData);
            mCurrentPayInfo = jsonObject;
            mCurrentProductId = jsonObject.getString("productId");
            requestOrderId();;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    private  void requestPayParams(JSONObject jsonObject){
        if(jsonObject ==null){
            //Toast.makeText(mActivity, "jsonObject ==null" , Toast.LENGTH_LONG).show();
            return;
        }
        try {
           // Toast.makeText(mActivity, "========jrequestPayParams==========="+jsonObject , Toast.LENGTH_LONG).show();
//            BGGLog.getInstance().d("== pay=="+jsonObject);
            mCurrentProductId = jsonObject.getString("productId");
            String productName = jsonObject.getString("productName");
            int productCount = jsonObject.getInt("productCount");
            int price = jsonObject.getInt("price");
            String prodectDes = jsonObject.getString("productDesc");
            int leftCoinCount = jsonObject.getInt("leftCoinCount");
            String roleId = jsonObject.getString("roleId");
            int roleLevel = jsonObject.getInt("roleLevel");
            String roleName = jsonObject.getString("roleName");
            String serverId = jsonObject.getString("serverId");
            String serverName = jsonObject.getString("serverName");
            String vipLevel = jsonObject.getString("vipLevel");
            String platformProductId = jsonObject.getString("platformProductId");
//            String vouchNum = jsonObject.getString("vouchNum");
            //String createRoleTime = jsonObject.getString("createRoleTime");
            //String balance=jsonObject.getString("leftYuanBao");
            //String exteraParams  //透传参数，服务器发送异常异步通知时原样传回
            // serverID/roleId

            if("" != serverId) {
                roleInfo.setServerID(serverId);  //服务器ID（数字字符串）
            }
            if("" != serverName) {
                roleInfo.setServerName(serverName); //服务器名称
            }
            if("" != roleName) {
                roleInfo.setGameRoleName(roleName); //角色名称
            }
            if("" != roleId) {
                roleInfo.setGameRoleID(roleId); //角色ID
            }
            roleInfo.setGameUserLevel(roleLevel+"");// 等级
            if("" != vipLevel) {
                roleInfo.setVipLevel(vipLevel);// VIP等级
            }
           // mRoleInfo.setGameBalance(balance);// 角色现有金额
            roleInfo.setPartyName("");// 公会名字
            roleInfo.setRoleCreateTime("0");

//            BGGLog.getInstance().d("== roleInfo()=="+roleInfo.getGameRoleID()+"============"+roleInfo.getGameRoleName() +"=============" +serverId+"========"+ roleInfo.getServerID() + "==========" + roleInfo.getVipLevel()+"===="+roleInfo.getRoleCreateTime());

            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setCpOrderID(mOrderId);
            orderInfo.setGoodsID(platformProductId);
            orderInfo.setGoodsName(productName);
            orderInfo.setPrice(price * 0.01);
            orderInfo.setAmount(price * 0.01);
            orderInfo.setCount(productCount);
            orderInfo.setGoodsDesc(prodectDes);
            orderInfo.setExtrasParams(serverId+"/"+roleId+"/"+mCurrentProductId);
//            BGGLog.getInstance().d(serverId+"/"+roleId+"/"+mCurrentProductId +"/" +vouchNum);
           // Toast.makeText(mActivity, "========jrequestPayParams=======OrderInfo===="+orderInfo , Toast.LENGTH_LONG).show();

            com.quicksdk.Payment.getInstance().pay(mActivity,orderInfo,roleInfo);
        } catch (Exception e) {
            e.printStackTrace();
            BGGLog.getInstance().d("productPay Excelption:" + e.getStackTrace());
        }
    }

    //请求订单号
    public void requestOrderId(){
        //向unity游戏发送订单号请求
        BGGLog.getInstance().d("requestOrderId");
        HashMap<String,String> Map = new HashMap<String,String >();
        Map.put("productId", mCurrentProductId);

        String SendStr = JsonParser.simpleMapToJsonStr(Map);
        UnitySendMessage("GameManagerObject", "OnRequestOrderId", SendStr);
    }
    //设置订单号
    public void setOrderId(String orderId) {

        try {
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
            BGGLog.getInstance().d("=====setOrderId====="+orderId);
            if(orderId ==null || orderId.trim().length() <= 0){
               // Toast.makeText(mActivity, "=====请求订单号失败，请重试=====" , Toast.LENGTH_LONG).show();
                showToastTips("请求订单号失败，请重试");
                return;
            }

            this.mOrderId = orderId;
            requestPayParams();
        }catch (Exception e){
            e.printStackTrace();
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
        }

//        BGGLog.getInstance().d("### setOrder:" + orderId);
//        this.mCurrentProductId = orderId;
//        requestPayParams(mCurrentPayInfo);  //产品订单编号从服务器GC生成
    }
    private void requestPayParams()
    {
        cjPay(mCurrentPayInfo);
    }
    private void cjPay(final JSONObject jsonObject){
        if( jsonObject == null) return;
        BGGLog.getInstance().d("Pay params1=" + jsonObject.toString());
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                requestPayParams(jsonObject);
            }
        });

    }

    //获取渠道类型
    public int getChannelType(){
        return Extend.getInstance().getChannelType();
    }

    public void stopWaiting() {
        if (mActivity == null) return;
    }

    public void showToastTips(final String tips) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if( mContext != null && tips != null){
                    //Toast.makeText((Activity) mContext, tips, Toast.LENGTH_SHORT).show();
                    BGGLog.getInstance().d("mContext != null && tips != null==== + tips");
                }
                else
                {
                    if( mContext == null )
                        BGGLog.getInstance().d("showToastTips mContext==null");
                    if( tips == null )
                        BGGLog.getInstance().d("showToastTips tips==null");
                }
            }
        });
    }
    public void startWaiting(final String msg, final boolean bIsPay) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.d(LOG_TAG, "startWaiting");

            }
        });
    }

    //获取实名信息
    public void getRealNameInfo() {
        BGGLog.getInstance().d("getRealNameInfo start");
        startWaiting("正在请求实名信息...", false);


        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                // 判断渠道是否支持实名认证功能
                if (Extend.getInstance().isFunctionSupported(FuncType.REAL_NAME_REGISTER)) {
                    Extend.getInstance().callFunctionWithParamsCallBack(mActivity, FuncType.REAL_NAME_REGISTER, new BaseCallBack() {
                        @Override
                        public void onSuccess(Object... arg0) {
                            stopWaiting();

                            mUnderAge=0;
                            Log.d(LOG_TAG, "UnderAge type : " + mUnderAge);
                            UnityPlayer.UnitySendMessage("GameManagerObject", "onRequestRealNameInfo", mUnderAge + "");
                        }

                        @Override
                        public void onFailed(Object... arg0) {
                            stopWaiting();
                        }
                    });
                }else
                {
                    stopWaiting();
                    mUnderAge=0;
                    UnityPlayer.UnitySendMessage("GameManagerObject", "onRequestRealNameInfo", mUnderAge + "");
                }
            }
        });
    }


    //手动登录
    public void ysdkStartLogin(final int platformId) {

    }
    public String getCurrChannel()
    {
//        return Integer.toString(Extend.getInstance().getChannelType());
        return Extend.getInstance().callFunction(mActivity, FuncType.UNDEFIEND);
    }

    public void getEventData(String jsonData)
    {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonData);

            if (!jsonObject.has("dataType")) {
                return;
            }
            String dataType = jsonObject.getString("dataType");
            String severId = "";
            if (jsonObject.has("serverID"))
                severId = jsonObject.getString("serverID");

            String severName = "";
            if (jsonObject.has("serverName"))
                severName = jsonObject.getString("serverName");

            String roleId = "";
            if (jsonObject.has("roleID"))
                roleId = jsonObject.getString("roleID");

            String roleName = "";
            if (jsonObject.has("roleName"))
                roleName = jsonObject.getString("roleName");

            String roleLevel = "";
            if (jsonObject.has("roleLevel"))
                roleLevel = jsonObject.getString("roleLevel");

            String roleCTime = "";
            if (jsonObject.has("roleCreateTime"))
            {
                roleCTime = jsonObject.getString("roleCreateTime");
            }
            String Vip = "";
            if (jsonObject.has("vipLevel"))
                Vip = jsonObject.getString("vipLevel");
            else {
                Vip = "0";
            }
            String balance = "";
            if (jsonObject.has("leftYuanBao"))
                balance = jsonObject.getString("leftYuanBao");
            String partyName = "";
            if (jsonObject.has("partyName")) {
                partyName = jsonObject.getString("partyName");
            }
            String sex = "";
            if (jsonObject.has("sex")) {
                sex = jsonObject.getString("sex");
            }
            String rolePower = "";
            if (jsonObject.has("rolePower")) {
                rolePower = jsonObject.getString("rolePower");
            }
            if("" != severId) {
                roleInfo.setServerID(severId);  //服务器ID（数字字符串）
            }
            if("" != severName) {
                roleInfo.setServerName(severName); //服务器名称
            }
            if("" != roleName) {
                roleInfo.setGameRoleName(roleName); //角色名称
            }
            if("" != roleId) {
                roleInfo.setGameRoleID(roleId); //角色ID
            }
            roleInfo.setGameBalance(balance); //角色用户余额
            roleInfo.setVipLevel(Vip); //VIP等级

            roleInfo.setGameUserLevel(roleLevel); //角色用户等级
            roleInfo.setRoleCreateTime(roleCTime); //角色创建时间 （10位数的unix timestamp时间戳）

            roleInfo.setPartyName(partyName); //公会社团
//            roleInfo.setPartyId("partyId"); //帮派ID
            roleInfo.setGameRoleGender(sex); //角色性别
            roleInfo.setGameRolePower(rolePower); //战力
//            roleInfo.setPartyRoleId("0"); //角色所在帮派中的ID
//            roleInfo.setPartyRoleName("0"); //角色在帮派中的名称
//            roleInfo.setPartyRoleId("0"); //角色职业ID
//            roleInfo.setProfession("0"); //角色职业名称
//            roleInfo.setFriendlist("0"); //好友关系列表

//            BGGLog.getInstance().d(dataType+"==================submitExtraData================" + roleInfo.getGameRoleID()+"=====" + roleInfo.getGameRoleName() + "=========="+severId +"======="+roleInfo.getServerID()+"======"+roleInfo.getVipLevel()+"========"+roleCTime+"===="+roleInfo.getRoleCreateTime());
            this.mActivity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    User.getInstance().setGameRoleInfo(mActivity, roleInfo, "3".equals(dataType));
                    mRoleInfo = roleInfo;
                }
            });
        } catch (JSONException e) {
            e.printStackTrace();
            BGGLog.getInstance().d(jsonData+"   " + e.getMessage());
        }
    }




    /// 访问资源服务器请求
    public void resourceServerVisit(String url, String resourceId)
    {
        BGGLog.getInstance().d("resourceServerVisit");
    }

    /// 版本号检查
    public void appVersionCheck(String version)
    {
        BGGLog.getInstance().d("appVersionCheck");
    }

    /// 资源加载
    public void resourceLoading(String resourceId)
    {
        BGGLog.getInstance().d("resourceLoading");
    }

    /// 资源升级开始
    public void resourceUpdateStart(String resourceId)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 资源升级结果
    public  void resourceUpdate(String resourceId, String result)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 服务列表拉取结果
    public void gameServerListed(String daquId, String qufuId, String result)
    {
        BGGLog.getInstance().d("gameServerListed");
    }

    /// 服务器登录
    public void gameServerLoggedin(String result)
    {
        BGGLog.getInstance().d("gameServerLoggedin");
    }

    /// 角色登录请求
    public void roleLoginRequested(String roleID, String serverID)
    {
        BGGLog.getInstance().d("RoleLoginRequested");
    }

    /// 角色加入公会
    public void joinUnion()
    {
        BGGLog.getInstance().d("joinUnion");
    }

    /// 任务完成节点
    public void gameTaskMoveEvent(String desc)
    {
        BGGLog.getInstance().d("gameTaskMoveEvent:" + desc);
    }

    public void getBindCheck(){
        BGGLog.getInstance().d("getBindCheck");
    }

    public void getPhoneAreaCode(){
        BGGLog.getInstance().d("getPhoneAreaCode");
    }
    public void getBindPhoneAccount( String areaCode, String phone, String smsCode){
        BGGLog.getInstance().d("getBindPhoneAccount");}

    public void getVerifyCodeCheck(String areaCode, String phone){
        BGGLog.getInstance().d("getVerifyCodeCheck");}
    public void ShowQuestion(){
        BGGLog.getInstance().d("ShowQuestion");
    }

    public void InitProduct(){
        BGGLog.getInstance().d("InitProduct");
    }
    public void setFiveStarDialogListener(String roleId, String serverId){
        BGGLog.getInstance().d("SetFiveStarDialogListener");
    }
    public void RequestRealNameInfo(){
        BGGLog.getInstance().d("RequestRealNameInfo");
    }
    public void closeHudTips(){
        BGGLog.getInstance().d("closeHudTips");
    }

    //启动oppo社区中心
    public void launchOppoForum()
    {
    }

    //启动vivo社区中心
    public void launchVivoForum()
    {
    }
    public boolean isFromOppoGameCenter()
    {
        return UnityPlayerActivity.mIsFromGameCenter;
    }
    public void requestOppoVipInfo()
    {
    }
    public void performFeature(final String type)
    {
    }
    public void onFirstPurchase()
    {
        BGGLog.getInstance().d("onFirstPurchase");
    }
    public void onBeginPlay() {
    }

    public void onChargeCallBack(String orderId, String iapId, int currencyAmount, String currencyType, double virtualCurrencyAmout, String paymentType, int state) {
    }

    public void onSelectRole(String roleName) {
    }
}
