/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SimpleMultipartEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class RequestParams {
    protected boolean isRepeatable = false;
    protected ConcurrentHashMap<String, String> urlParams;
    protected ConcurrentHashMap<String, StreamWrapper> streamParams;
    protected ConcurrentHashMap<String, FileWrapper> fileParams;
    protected ConcurrentHashMap<String, Object> urlParamsWithObjects;

    public RequestParams() {
        this(null);
    }

    public RequestParams(Map<String, String> source) {
        this.init();
        if (source != null) {
            for (Map.Entry<String, String> entry : source.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public RequestParams(final String key, final String value) {
        this((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(key, value);
            }
        });
    }

    public RequestParams(Object ... keysAndValues) {
        this.init();
        int len = keysAndValues.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i = 0; i < len; i += 2) {
            String key = String.valueOf(keysAndValues[i]);
            String val = String.valueOf(keysAndValues[i + 1]);
            this.put(key, val);
        }
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.urlParams.put(key, value);
        }
    }

    public void put(String key, File file) throws FileNotFoundException {
        this.put(key, file, null);
    }

    public void put(String key, File file, String contentType) throws FileNotFoundException {
        if (key != null && file != null) {
            this.fileParams.put(key, new FileWrapper(file, contentType));
        }
    }

    public void put(String key, InputStream stream) {
        this.put(key, stream, null);
    }

    public void put(String key, InputStream stream, String name) {
        this.put(key, stream, name, null);
    }

    public void put(String key, InputStream stream, String name, String contentType) {
        if (key != null && stream != null) {
            this.streamParams.put(key, new StreamWrapper(stream, name, contentType));
        }
    }

    public void put(String key, Object value) {
        if (key != null && value != null) {
            this.urlParamsWithObjects.put(key, value);
        }
    }

    public void add(String key, String value) {
        if (key != null && value != null) {
            HashSet params = this.urlParamsWithObjects.get(key);
            if (params == null) {
                params = new HashSet();
                this.put(key, params);
            }
            if (params instanceof List) {
                ((List)((Object)params)).add(value);
            } else if (params instanceof Set) {
                ((Set)params).add(value);
            }
        }
    }

    public void remove(String key) {
        this.urlParams.remove(key);
        this.streamParams.remove(key);
        this.fileParams.remove(key);
        this.urlParamsWithObjects.remove(key);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append("STREAM");
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append("FILE");
        }
        List<BasicNameValuePair> params = this.getParamsList(null, this.urlParamsWithObjects);
        for (BasicNameValuePair kv : params) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(kv.getName());
            result.append("=");
            result.append(kv.getValue());
        }
        return result.toString();
    }

    public void setHttpEntityIsRepeatable(boolean isRepeatable) {
        this.isRepeatable = isRepeatable;
    }

    public HttpEntity getEntity(ResponseHandlerInterface progressHandler) throws IOException {
        if (this.streamParams.isEmpty() && this.fileParams.isEmpty()) {
            return this.createFormEntity();
        }
        return this.createMultipartEntity(progressHandler);
    }

    private HttpEntity createFormEntity() {
        try {
            return new UrlEncodedFormEntity(this.getParamsList(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private HttpEntity createMultipartEntity(ResponseHandlerInterface progressHandler) throws IOException {
        SimpleMultipartEntity entity = new SimpleMultipartEntity(progressHandler);
        entity.setIsRepeatable(this.isRepeatable);
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            entity.addPart(entry.getKey(), entry.getValue());
        }
        List<BasicNameValuePair> params = this.getParamsList(null, this.urlParamsWithObjects);
        for (BasicNameValuePair basicNameValuePair : params) {
            entity.addPart(basicNameValuePair.getName(), basicNameValuePair.getValue());
        }
        for (Map.Entry entry : this.streamParams.entrySet()) {
            StreamWrapper stream = (StreamWrapper)entry.getValue();
            if (stream.inputStream == null) continue;
            entity.addPart((String)entry.getKey(), stream.name, stream.inputStream, stream.contentType);
        }
        for (Map.Entry entry : this.fileParams.entrySet()) {
            FileWrapper fileWrapper = (FileWrapper)entry.getValue();
            entity.addPart((String)entry.getKey(), fileWrapper.file, fileWrapper.contentType);
        }
        return entity;
    }

    private void init() {
        this.urlParams = new ConcurrentHashMap();
        this.streamParams = new ConcurrentHashMap();
        this.fileParams = new ConcurrentHashMap();
        this.urlParamsWithObjects = new ConcurrentHashMap();
    }

    protected List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> lparams = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            lparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        lparams.addAll(this.getParamsList(null, this.urlParamsWithObjects));
        return lparams;
    }

    private List<BasicNameValuePair> getParamsList(String key, Object value) {
        LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList list = new ArrayList(map.keySet());
            Collections.sort(list);
            for (String nestedKey : list) {
                Object nestedValue = map.get(nestedKey);
                if (nestedValue == null) continue;
                params.addAll(this.getParamsList(key == null ? nestedKey : String.format("%s[%s]", key, nestedKey), nestedValue));
            }
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object nestedValue : list) {
                params.addAll(this.getParamsList(String.format("%s[]", key), nestedValue));
            }
        } else if (value instanceof Object[]) {
            Object[] array;
            for (Object nestedValue : array = (Object[])value) {
                params.addAll(this.getParamsList(String.format("%s[]", key), nestedValue));
            }
        } else if (value instanceof Set) {
            Set set = (Set)value;
            for (Object nestedValue : set) {
                params.addAll(this.getParamsList(key, nestedValue));
            }
        } else if (value instanceof String) {
            params.add(new BasicNameValuePair(key, (String)value));
        }
        return params;
    }

    protected String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)"UTF-8");
    }

    private static class StreamWrapper {
        public InputStream inputStream;
        public String name;
        public String contentType;

        public StreamWrapper(InputStream inputStream, String name, String contentType) {
            this.inputStream = inputStream;
            this.name = name;
            this.contentType = contentType;
        }
    }

    private static class FileWrapper {
        public File file;
        public String contentType;

        public FileWrapper(File file, String contentType) {
            this.file = file;
            this.contentType = contentType;
        }
    }
}

