/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.webview.bridge;

import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.bridge.CallbackStatus;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeCallback {
    private static AtomicInteger _callbackCount = new AtomicInteger(0);
    private Method _callback;
    private String _id;

    public NativeCallback(Method method) {
        this._callback = method;
        this._id = this._callback.getName().toUpperCase(Locale.US) + "_" + _callbackCount.getAndIncrement();
    }

    public String getId() {
        return this._id;
    }

    public void invoke(String object, Object ... object2) {
        try {
            object = CallbackStatus.valueOf(object);
        }
        catch (Exception exception) {
            DeviceLog.error("Illegal status");
            WebViewApp.getCurrentApp().removeCallback(this);
            throw exception;
        }
        if (object2 == null) {
            object2 = new Object[]{object};
        } else {
            object2 = new ArrayList<Object>(Arrays.asList(object2));
            ((ArrayList)object2).add(0, (Object)object);
            object2 = ((ArrayList)object2).toArray();
        }
        this._callback.invoke(null, (Object[])object2);
        WebViewApp.getCurrentApp().removeCallback(this);
    }
}

