/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.webview.bridge;

import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.bridge.CallbackStatus;
import com.unity3d.splash.services.core.webview.bridge.WebViewBridge;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Invocation {
    private static AtomicInteger _idCount = new AtomicInteger(0);
    private static Map _invocationSets;
    private ArrayList _invocations;
    private ArrayList _responses;
    private int _invocationId = _idCount.getAndIncrement();

    public Invocation() {
        if (_invocationSets == null) {
            _invocationSets = new HashMap();
        }
        _invocationSets.put(this._invocationId, this);
    }

    public void addInvocation(String string, String string2, Object[] objectArray, WebViewCallback webViewCallback) {
        if (this._invocations == null) {
            this._invocations = new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(objectArray);
        arrayList.add(webViewCallback);
        this._invocations.add(arrayList);
    }

    public boolean nextInvocation() {
        if (this._invocations != null && this._invocations.size() > 0) {
            Object object = (ArrayList)this._invocations.remove(0);
            String string = (String)((ArrayList)object).get(0);
            String string2 = (String)((ArrayList)object).get(1);
            Object[] objectArray = (Object[])((ArrayList)object).get(2);
            object = (WebViewCallback)((ArrayList)object).get(3);
            try {
                WebViewBridge.handleInvocation(string, string2, objectArray, (WebViewCallback)object);
            }
            catch (Exception exception) {
                DeviceLog.exception(String.format("Error handling invocation %s.%s(%s)", string, string2, Arrays.toString(objectArray)), exception);
            }
            return true;
        }
        return false;
    }

    public void setInvocationResponse(CallbackStatus callbackStatus, Enum enum_, Object ... objectArray) {
        if (this._responses == null) {
            this._responses = new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add((Object)callbackStatus);
        arrayList.add(enum_);
        arrayList.add(objectArray);
        this._responses.add(arrayList);
    }

    public void sendInvocationCallback() {
        _invocationSets.remove(this.getId());
        WebViewApp.getCurrentApp().invokeCallback(this);
    }

    public int getId() {
        return this._invocationId;
    }

    public ArrayList getResponses() {
        return this._responses;
    }

    public static synchronized Invocation getInvocationById(int n2) {
        if (_invocationSets != null && _invocationSets.containsKey(n2)) {
            return (Invocation)_invocationSets.get(n2);
        }
        return null;
    }
}

