/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.sensorinfo;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import org.json.JSONException;
import org.json.JSONObject;

public class SensorInfoListener
implements SensorEventListener {
    private static SensorInfoListener _accelerometerListener = null;
    private static Sensor _accelerometerSensor = null;
    private static SensorEvent _latestAccelerometerEvent = null;

    public static boolean startAccelerometerListener(int n2) {
        if (_accelerometerListener == null) {
            _accelerometerListener = new SensorInfoListener();
        }
        SensorManager sensorManager = (SensorManager)ClientProperties.getApplicationContext().getSystemService("sensor");
        _accelerometerSensor = sensorManager.getDefaultSensor(1);
        return sensorManager.registerListener((SensorEventListener)_accelerometerListener, _accelerometerSensor, n2);
    }

    public static void stopAccelerometerListener() {
        if (_accelerometerListener != null) {
            ((SensorManager)ClientProperties.getApplicationContext().getSystemService("sensor")).unregisterListener((SensorEventListener)_accelerometerListener);
            _accelerometerListener = null;
        }
    }

    public static boolean isAccelerometerListenerActive() {
        return _accelerometerListener != null;
    }

    public static JSONObject getAccelerometerData() {
        JSONObject jSONObject = null;
        if (_latestAccelerometerEvent != null) {
            jSONObject = new JSONObject();
            try {
                jSONObject.put("x", (double)SensorInfoListener._latestAccelerometerEvent.values[0]);
                jSONObject.put("y", (double)SensorInfoListener._latestAccelerometerEvent.values[1]);
                jSONObject.put("z", (double)SensorInfoListener._latestAccelerometerEvent.values[2]);
            }
            catch (JSONException jSONException) {
                DeviceLog.exception("JSON error while constructing accelerometer data", (Exception)((Object)jSONException));
            }
        }
        return jSONObject;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 1) {
            _latestAccelerometerEvent = sensorEvent;
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }
}

