/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.request;

import android.os.ConditionVariable;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.request.CancelableThreadPoolExecutor;
import com.unity3d.splash.services.core.request.IResolveHostListener;
import com.unity3d.splash.services.core.request.IWebRequestListener;
import com.unity3d.splash.services.core.request.ResolveHostError;
import com.unity3d.splash.services.core.request.WebRequest;
import com.unity3d.splash.services.core.request.WebRequestRunnable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class WebRequestThread {
    private static boolean _ready = false;
    private static LinkedBlockingQueue _queue;
    private static CancelableThreadPoolExecutor _pool;
    private static int _corePoolSize;
    private static int _maximumPoolSize;
    private static long _keepAliveTime;
    private static final Object _readyLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void init() {
        _queue = new LinkedBlockingQueue();
        _pool = new CancelableThreadPoolExecutor(_corePoolSize, _maximumPoolSize, _keepAliveTime, TimeUnit.MILLISECONDS, _queue);
        _pool.prestartAllCoreThreads();
        _queue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                _ready = true;
                Object object = _readyLock;
                synchronized (object) {
                    _readyLock.notify();
                    return;
                }
            }
        });
        while (!_ready) {
            try {
                Object object = _readyLock;
                synchronized (object) {
                    _readyLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                DeviceLog.debug("Couldn't synchronize thread");
                return;
            }
        }
    }

    public static synchronized void reset() {
        WebRequestThread.cancel();
        if (_pool != null) {
            _pool.shutdown();
            try {
                _pool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {}
            _queue.clear();
            _pool = null;
            _queue = null;
            _ready = false;
        }
    }

    public static synchronized void cancel() {
        if (_pool != null) {
            _pool.cancel();
            for (Runnable runnable : _queue) {
                if (!(runnable instanceof WebRequestRunnable)) continue;
                ((WebRequestRunnable)runnable).setCancelStatus(true);
            }
            _queue.clear();
            _pool.purge();
        }
    }

    public static synchronized void request(String string, WebRequest.RequestType requestType, Map map, Integer n2, Integer n3, IWebRequestListener iWebRequestListener) {
        WebRequestThread.request(string, requestType, map, null, n2, n3, iWebRequestListener);
    }

    public static synchronized void request(String string, WebRequest.RequestType requestType, Map map, String string2, Integer n2, Integer n3, IWebRequestListener iWebRequestListener) {
        if (!_ready) {
            WebRequestThread.init();
        }
        if (string == null || string.length() < 3) {
            iWebRequestListener.onFailed(string, "Request is NULL or too short");
            return;
        }
        _queue.add(new WebRequestRunnable(string, requestType.name(), string2, n2, n3, map, iWebRequestListener));
    }

    public static synchronized void setConcurrentRequestCount(int n2) {
        _maximumPoolSize = _corePoolSize = n2;
        if (_pool != null) {
            _pool.setCorePoolSize(_corePoolSize);
            _pool.setMaximumPoolSize(_maximumPoolSize);
        }
    }

    public static synchronized void setMaximumPoolSize(int n2) {
        _maximumPoolSize = n2;
        if (_pool != null) {
            _pool.setMaximumPoolSize(_maximumPoolSize);
        }
    }

    public static synchronized void setKeepAliveTime(long l2) {
        _keepAliveTime = l2;
        if (_pool != null) {
            _pool.setKeepAliveTime(_keepAliveTime, TimeUnit.MILLISECONDS);
        }
    }

    public static synchronized boolean resolve(final String string, final IResolveHostListener iResolveHostListener) {
        if (string == null || string.length() < 3) {
            iResolveHostListener.onFailed(string, ResolveHostError.INVALID_HOST, "Host is NULL");
            return false;
        }
        new Thread(new Runnable(){

            @Override
            public final void run() {
                final ConditionVariable conditionVariable = new ConditionVariable();
                Thread thread = null;
                try {
                    thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String string = InetAddress.getByName(string).getHostAddress();
                                iResolveHostListener.onResolve(string, string);
                            }
                            catch (UnknownHostException unknownHostException) {
                                DeviceLog.exception("Unknown host", unknownHostException);
                                iResolveHostListener.onFailed(string, ResolveHostError.UNKNOWN_HOST, unknownHostException.getMessage());
                            }
                            conditionVariable.open();
                        }
                    });
                    thread.start();
                }
                catch (Exception exception) {
                    DeviceLog.exception("Exception while resolving host", exception);
                    iResolveHostListener.onFailed(string, ResolveHostError.UNEXPECTED_EXCEPTION, exception.getMessage());
                }
                if (!conditionVariable.block(20000L) && thread != null) {
                    thread.interrupt();
                    iResolveHostListener.onFailed(string, ResolveHostError.TIMEOUT, "Timeout");
                }
            }
        }).start();
        return true;
    }

    static {
        _corePoolSize = 1;
        _maximumPoolSize = 1;
        _keepAliveTime = 1000L;
        _readyLock = new Object();
    }
}

