/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.request;

import android.os.Bundle;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.request.IWebRequestListener;
import com.unity3d.splash.services.core.request.NetworkIOException;
import com.unity3d.splash.services.core.request.WebRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebRequestRunnable
implements Runnable {
    private WebRequest _currentRequest;
    private boolean _canceled = false;
    private final String _url;
    private final String _type;
    private final String _body;
    private final int _connectTimeout;
    private final int _readTimeout;
    private final Map _headers;
    private final IWebRequestListener _listener;

    public WebRequestRunnable(String string, String string2, String string3, int n2, int n3, Map map, IWebRequestListener iWebRequestListener) {
        this._url = string;
        this._type = string2;
        this._body = string3;
        this._connectTimeout = n2;
        this._readTimeout = n3;
        this._headers = map;
        this._listener = iWebRequestListener;
    }

    @Override
    public void run() {
        DeviceLog.debug("Handling request message: " + this._url + " type=" + this._type);
        try {
            this.makeRequest(this._url, this._type, this._headers, this._body, this._connectTimeout, this._readTimeout);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            DeviceLog.exception("Malformed URL", malformedURLException);
            this.onFailed("Malformed URL");
            return;
        }
    }

    public void setCancelStatus(boolean bl) {
        this._canceled = bl;
        if (this._canceled && this._currentRequest != null) {
            this._currentRequest.cancel();
        }
    }

    private void makeRequest(String string, String string2, Map object, String string32, int n2, int n3) {
        if (this._canceled) {
            return;
        }
        this._currentRequest = new WebRequest(string, string2, (Map)object, n2, n3);
        if (string32 != null) {
            this._currentRequest.setBody(string32);
        }
        try {
            string = this._currentRequest.makeRequest();
        }
        catch (NetworkIOException | IOException | IllegalArgumentException | IllegalStateException exception) {
            DeviceLog.exception("Error completing request", exception);
            this.onFailed(exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        if (this._currentRequest.isCanceled()) {
            return;
        }
        string2 = new Bundle();
        for (String string32 : this._currentRequest.getResponseHeaders().keySet()) {
            if (string32 == null || string32.contentEquals("null")) continue;
            String[] stringArray = new String[((List)this._currentRequest.getResponseHeaders().get(string32)).size()];
            for (n3 = 0; n3 < ((List)this._currentRequest.getResponseHeaders().get(string32)).size(); ++n3) {
                stringArray[n3] = (String)((List)this._currentRequest.getResponseHeaders().get(string32)).get(n3);
            }
            string2.putStringArray(string32, stringArray);
        }
        if (this._currentRequest.isCanceled()) {
            return;
        }
        this.onSucceed(string, this._currentRequest.getResponseCode(), this.getResponseHeaders((Bundle)string2));
    }

    private void onSucceed(String string, int n2, Map map) {
        this._listener.onComplete(this._url, string, n2, map);
    }

    private void onFailed(String string) {
        this._listener.onFailed(this._url, string);
    }

    private Map getResponseHeaders(Bundle bundle) {
        HashMap<String, ArrayList<String>> hashMap = null;
        if (bundle.size() > 0) {
            hashMap = new HashMap<String, ArrayList<String>>();
            for (String string : bundle.keySet()) {
                String[] stringArray = bundle.getStringArray(string);
                if (stringArray == null) continue;
                hashMap.put(string, new ArrayList<String>(Arrays.asList(stringArray)));
            }
        }
        return hashMap;
    }
}

