/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.request;

import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.request.IWebRequestProgressListener;
import com.unity3d.splash.services.core.request.NetworkIOException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class WebRequest {
    private URL _url;
    private String _requestType = RequestType.GET.name();
    private String _body;
    private Map _headers;
    private Map _responseHeaders;
    private int _responseCode = -1;
    private long _contentLength = -1L;
    private boolean _canceled = false;
    private int _connectTimeout;
    private int _readTimeout;
    private IWebRequestProgressListener _progressListener;

    public WebRequest(String string, String string2, Map map) {
        this(string, string2, map, 30000, 30000);
    }

    public WebRequest(String string, String string2, Map map, int n2, int n3) {
        this._url = new URL(string);
        this._requestType = string2;
        this._headers = map;
        this._connectTimeout = n2;
        this._readTimeout = n3;
    }

    public void cancel() {
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public URL getUrl() {
        return this._url;
    }

    public String getRequestType() {
        return this._requestType;
    }

    public String getBody() {
        return this._body;
    }

    public void setBody(String string) {
        this._body = string;
    }

    public String getQuery() {
        if (this._url != null) {
            return this._url.getQuery();
        }
        return null;
    }

    public Map getResponseHeaders() {
        return this._responseHeaders;
    }

    public Map getHeaders() {
        return this._headers;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int n2) {
        this._connectTimeout = n2;
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int n2) {
        this._readTimeout = n2;
    }

    public void setProgressListener(IWebRequestProgressListener iWebRequestProgressListener) {
        this._progressListener = iWebRequestProgressListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long makeStreamRequest(OutputStream outputStream) {
        Object object;
        HttpURLConnection httpURLConnection;
        block20: {
            httpURLConnection = this.getHttpUrlConnectionWithHeaders();
            httpURLConnection.setDoInput(true);
            if (this.getRequestType().equals(RequestType.POST.name())) {
                httpURLConnection.setDoOutput(true);
                object = null;
                try {
                    object = new PrintWriter((Writer)new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8"), true);
                    if (this.getBody() == null) {
                        ((PrintWriter)object).print(this.getQuery());
                    } else {
                        ((PrintWriter)object).print(this.getBody());
                    }
                    ((PrintWriter)object).flush();
                }
                catch (IOException iOException) {
                    try {
                        DeviceLog.exception("Error while writing POST params", iOException);
                        throw new NetworkIOException("Error writing POST params: " + iOException.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (object == null) throw throwable;
                            ((PrintWriter)object).close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            DeviceLog.exception("Error closing writer", exception);
                            throw exception;
                        }
                    }
                }
                try {
                    ((PrintWriter)object).close();
                }
                catch (Exception exception) {
                    DeviceLog.exception("Error closing writer", exception);
                    throw exception;
                }
            }
            try {
                this._responseCode = httpURLConnection.getResponseCode();
            }
            catch (IOException | RuntimeException exception) {
                throw new NetworkIOException("Response code: " + exception.getMessage());
            }
            this._contentLength = httpURLConnection.getContentLength();
            if (httpURLConnection.getHeaderFields() != null) {
                this._responseHeaders = httpURLConnection.getHeaderFields();
            }
            try {
                object = httpURLConnection.getInputStream();
            }
            catch (IOException iOException) {
                object = httpURLConnection.getErrorStream();
                if (object != null) break block20;
                throw new NetworkIOException("Can't open error stream: " + iOException.getMessage());
            }
        }
        if (this._progressListener != null) {
            this._progressListener.onRequestStart(this.getUrl().toString(), this._contentLength, this._responseCode, this._responseHeaders);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
        int n2 = 0;
        long l2 = 0L;
        object = new byte[4096];
        while (!this.isCanceled() && n2 != -1) {
            try {
                n2 = bufferedInputStream.read((byte[])object);
            }
            catch (IOException iOException) {
                throw new NetworkIOException("Network exception: " + iOException.getMessage());
            }
            if (n2 <= 0) continue;
            outputStream.write((byte[])object, 0, n2);
            l2 += (long)n2;
            if (this._progressListener == null) continue;
            this._progressListener.onRequestProgress(this.getUrl().toString(), l2, this._contentLength);
        }
        httpURLConnection.disconnect();
        outputStream.flush();
        return l2;
    }

    public String makeRequest() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.makeStreamRequest(byteArrayOutputStream);
        return byteArrayOutputStream.toString("UTF-8");
    }

    private HttpURLConnection getHttpUrlConnectionWithHeaders() {
        HttpURLConnection httpURLConnection;
        if (this.getUrl().toString().startsWith("https://")) {
            try {
                httpURLConnection = (HttpsURLConnection)this.getUrl().openConnection();
            }
            catch (IOException iOException) {
                throw new NetworkIOException("Open HTTPS connection: " + iOException.getMessage());
            }
        } else if (this.getUrl().toString().startsWith("http://")) {
            try {
                httpURLConnection = (HttpURLConnection)this.getUrl().openConnection();
            }
            catch (IOException iOException) {
                throw new NetworkIOException("Open HTTP connection: " + iOException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid url-protocol in url: " + this.getUrl().toString());
        }
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setConnectTimeout(this.getConnectTimeout());
        httpURLConnection.setReadTimeout(this.getReadTimeout());
        try {
            httpURLConnection.setRequestMethod(this.getRequestType());
        }
        catch (ProtocolException protocolException) {
            throw new NetworkIOException("Set Request Method: " + this.getRequestType() + ", " + protocolException.getMessage());
        }
        if (this.getHeaders() != null && this.getHeaders().size() > 0) {
            for (String string : this.getHeaders().keySet()) {
                for (String string2 : (List)this.getHeaders().get(string)) {
                    DeviceLog.debug("Setting header: " + string + "=" + string2);
                    httpURLConnection.setRequestProperty(string, string2);
                }
            }
        }
        return httpURLConnection;
    }

    public static enum RequestType {
        POST,
        GET,
        HEAD;

    }
}

