/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.request;

import com.unity3d.splash.services.core.request.WebRequestRunnable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CancelableThreadPoolExecutor
extends ThreadPoolExecutor {
    private final List _activeRunnable = new LinkedList();

    public CancelableThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, LinkedBlockingQueue linkedBlockingQueue) {
        super(n2, n3, l2, timeUnit, linkedBlockingQueue);
    }

    @Override
    protected synchronized void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this._activeRunnable.add(runnable);
    }

    @Override
    protected synchronized void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        this._activeRunnable.remove(runnable);
    }

    public synchronized void cancel() {
        for (Runnable runnable : this._activeRunnable) {
            if (!(runnable instanceof WebRequestRunnable)) continue;
            ((WebRequestRunnable)runnable).setCancelStatus(true);
        }
    }
}

