/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.properties;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class ClientProperties {
    private static final X500Principal DEBUG_CERT = new X500Principal("CN=Android Debug,O=Android,C=US");
    private static WeakReference _activity;
    private static Context _applicationContext;
    private static Application _application;
    private static String _gameId;

    public static Activity getActivity() {
        return (Activity)_activity.get();
    }

    public static void setActivity(Activity activity) {
        _activity = new WeakReference<Activity>(activity);
    }

    public static Context getApplicationContext() {
        return _applicationContext;
    }

    public static void setApplicationContext(Context context) {
        _applicationContext = context;
    }

    public static Application getApplication() {
        return _application;
    }

    public static void setApplication(Application application) {
        _application = application;
    }

    public static String getGameId() {
        return _gameId;
    }

    public static void setGameId(String string) {
        _gameId = string;
    }

    public static String getAppName() {
        return _applicationContext.getPackageName();
    }

    public static String getAppVersion() {
        String string = ClientProperties.getApplicationContext().getPackageName();
        PackageManager packageManager = ClientProperties.getApplicationContext().getPackageManager();
        try {
            return packageManager.getPackageInfo((String)string, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            DeviceLog.exception("Error getting package info", (Exception)((Object)nameNotFoundException));
            return null;
        }
    }

    public static boolean isAppDebuggable() {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (ClientProperties.getApplicationContext() == null) {
            return false;
        }
        PackageManager packageManager = ClientProperties.getApplicationContext().getPackageManager();
        String string = ClientProperties.getApplicationContext().getPackageName();
        try {
            object = packageManager.getApplicationInfo(string, 0);
            if (0 != (object.flags &= 2)) {
                bl = true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            DeviceLog.exception("Could not find name", (Exception)((Object)nameNotFoundException));
            bl2 = true;
        }
        if (bl2) {
            try {
                Signature[] signatureArray = packageManager.getPackageInfo((String)string, (int)64).signatures;
                int n2 = packageManager.getPackageInfo((String)string, (int)64).signatures.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = signatureArray[i2];
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    bl = ((X509Certificate)certificateFactory.generateCertificate((InputStream)(object = new ByteArrayInputStream(object.toByteArray())))).getSubjectX500Principal().equals(DEBUG_CERT);
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                DeviceLog.exception("Could not find name", (Exception)((Object)nameNotFoundException));
            }
            catch (CertificateException certificateException) {
                DeviceLog.exception("Certificate exception", certificateException);
            }
        }
        return bl;
    }
}

