/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.preferences;

import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;

public class AndroidPreferences {
    public static boolean hasKey(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        return string != null && string.contains(string2);
    }

    public static String getString(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            if (string.contains(string2)) {
                try {
                    return string.getString(string2, "");
                }
                catch (ClassCastException classCastException) {
                    DeviceLog.error("Unity Ads failed to cast " + string2 + ": " + classCastException.getMessage());
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static Integer getInteger(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            if (string.contains(string2)) {
                try {
                    return string.getInt(string2, -1);
                }
                catch (ClassCastException classCastException) {
                    DeviceLog.error("Unity Ads failed to cast " + string2 + ": " + classCastException.getMessage());
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static Long getLong(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            if (string.contains(string2)) {
                try {
                    return string.getLong(string2, -1L);
                }
                catch (ClassCastException classCastException) {
                    DeviceLog.error("Unity Ads failed to cast " + string2 + ": " + classCastException.getMessage());
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static Boolean getBoolean(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            if (string.contains(string2)) {
                try {
                    return string.getBoolean(string2, false);
                }
                catch (ClassCastException classCastException) {
                    DeviceLog.error("Unity Ads failed to cast " + string2 + ": " + classCastException.getMessage());
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static Float getFloat(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            if (string.contains(string2)) {
                try {
                    return Float.valueOf(string.getFloat(string2, Float.NaN));
                }
                catch (ClassCastException classCastException) {
                    DeviceLog.error("Unity Ads failed to cast " + string2 + ": " + classCastException.getMessage());
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static void setString(String string, String string2, String string3) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            string = string.edit();
            string.putString(string2, string3);
            string.commit();
        }
    }

    public static void setInteger(String string, String string2, Integer n2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            string = string.edit();
            string.putInt(string2, n2.intValue());
            string.commit();
        }
    }

    public static void setLong(String string, String string2, Long l2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            string = string.edit();
            string.putLong(string2, l2.longValue());
            string.commit();
        }
    }

    public static void setBoolean(String string, String string2, Boolean bl) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            string = string.edit();
            string.putBoolean(string2, bl.booleanValue());
            string.commit();
        }
    }

    public static void setFloat(String string, String string2, Double d2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            string = string.edit();
            string.putFloat(string2, d2.floatValue());
            string.commit();
        }
    }

    public static void removeKey(String string, String string2) {
        string = ClientProperties.getApplicationContext().getSharedPreferences(string, 0);
        if (string != null) {
            string = string.edit();
            string.remove(string2);
            string.commit();
        }
    }
}

