/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.misc;

import android.os.Handler;
import android.os.Looper;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.json.JSONObject;

public class Utilities {
    public static void runOnUiThread(Runnable runnable) {
        Utilities.runOnUiThread(runnable, 0L);
    }

    public static void runOnUiThread(Runnable runnable, long l2) {
        Handler handler = new Handler(Looper.getMainLooper());
        if (l2 > 0L) {
            handler.postDelayed(runnable, l2);
            return;
        }
        handler.post(runnable);
    }

    public static String Sha256(String string) {
        return Utilities.Sha256(string.getBytes());
    }

    public static String Sha256(byte[] byArray) {
        MessageDigest messageDigest;
        if (byArray == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            DeviceLog.exception("SHA-256 algorithm not found", noSuchAlgorithmException);
            return null;
        }
        messageDigest.update(byArray, 0, byArray.length);
        return Utilities.toHexString(messageDigest.digest());
    }

    public static String Sha256(InputStream inputStream) {
        int n2;
        MessageDigest messageDigest;
        if (inputStream == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            DeviceLog.exception("SHA-256 algorithm not found", noSuchAlgorithmException);
            return null;
        }
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n2);
        }
        return Utilities.toHexString(messageDigest.digest());
    }

    public static String toHexString(byte[] byArray) {
        String string = "";
        for (int n2 : byArray) {
            if ((n2 = 0xFF & n2) <= 15) {
                string = string + "0";
            }
            string = string + Integer.toHexString(n2);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFile(File file, String string) {
        if (file == null) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        boolean bl = true;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                DeviceLog.exception("Error closing FileOutputStream", exception);
            }
        }
        catch (Exception exception) {
            bl = false;
            DeviceLog.exception("Could not write file", exception);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                DeviceLog.exception("Error closing FileOutputStream", exception);
            }
        }
        if (!bl) return bl;
        DeviceLog.debug("Wrote file: " + file.getAbsolutePath());
        return bl;
    }

    public static byte[] readFileBytes(File file) {
        int n2;
        int n3;
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        int n4 = 0;
        int n5 = n3 = file.length() < 4096L ? (int)file.length() : 4096;
        while ((n2 = ((InputStream)fileInputStream).read(byArray, n4, n3)) > 0) {
            if (file.length() - (long)(n4 += n2) >= 4096L) continue;
            n5 = (int)file.length() - n4;
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static JSONObject mergeJsonObjects(JSONObject jSONObject, JSONObject jSONObject2) {
        String string;
        if (jSONObject == null) {
            return jSONObject2;
        }
        if (jSONObject2 == null) {
            return jSONObject;
        }
        JSONObject jSONObject3 = new JSONObject();
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            jSONObject3.put(string, jSONObject2.get(string));
        }
        iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (jSONObject3.has(string) && jSONObject3.get(string) instanceof JSONObject && jSONObject.get(string) instanceof JSONObject) {
                jSONObject3.put(string, (Object)Utilities.mergeJsonObjects(jSONObject.getJSONObject(string), jSONObject3.getJSONObject(string)));
                continue;
            }
            jSONObject3.put(string, jSONObject.get(string));
        }
        return jSONObject3;
    }
}

