/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.device;

import android.content.Context;
import com.unity3d.splash.services.core.device.Storage;
import com.unity3d.splash.services.core.properties.SdkProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageManager {
    protected static final Map _storageFileMap = new HashMap();
    protected static final List _storages = new ArrayList();

    public static boolean init(Context object) {
        if (object == null) {
            return false;
        }
        if ((object = object.getFilesDir()) == null) {
            return false;
        }
        StorageManager.addStorageLocation(StorageType.PUBLIC, object + "/" + SdkProperties.getLocalStorageFilePrefix() + "public-data.json");
        if (!StorageManager.setupStorage(StorageType.PUBLIC)) {
            return false;
        }
        StorageManager.addStorageLocation(StorageType.PRIVATE, object + "/" + SdkProperties.getLocalStorageFilePrefix() + "private-data.json");
        return StorageManager.setupStorage(StorageType.PRIVATE);
    }

    public static void initStorage(StorageType object) {
        if (StorageManager.hasStorage((StorageType)((Object)object))) {
            if ((object = StorageManager.getStorage((StorageType)((Object)object))) != null) {
                ((Storage)object).initStorage();
            }
            return;
        }
        if (_storageFileMap.containsKey(object)) {
            object = new Storage((String)_storageFileMap.get(object), (StorageType)((Object)object));
            ((Storage)object).initStorage();
            _storages.add(object);
        }
    }

    private static boolean setupStorage(StorageType object) {
        if (!StorageManager.hasStorage((StorageType)((Object)object))) {
            StorageManager.initStorage((StorageType)((Object)object));
            object = StorageManager.getStorage((StorageType)((Object)object));
            if (object != null && !((Storage)object).storageFileExists()) {
                ((Storage)object).writeStorage();
            }
            if (object == null) {
                return false;
            }
        }
        return true;
    }

    public static Storage getStorage(StorageType storageType) {
        if (_storages != null) {
            for (Storage storage : _storages) {
                if (storage == null || !storage.getType().equals((Object)storageType)) continue;
                return storage;
            }
        }
        return null;
    }

    public static boolean hasStorage(StorageType storageType) {
        if (_storages != null) {
            for (Storage storage : _storages) {
                if (storage == null || !storage.getType().equals((Object)storageType)) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized void addStorageLocation(StorageType storageType, String string) {
        if (!_storageFileMap.containsKey((Object)storageType)) {
            _storageFileMap.put(storageType, string);
        }
    }

    public static synchronized void removeStorage(StorageType storageType) {
        if (StorageManager.getStorage(storageType) != null) {
            _storages.remove(StorageManager.getStorage(storageType));
        }
        if (_storageFileMap != null) {
            _storageFileMap.remove((Object)storageType);
        }
    }

    public static enum StorageType {
        PRIVATE,
        PUBLIC;

    }
}

