/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.device;

import com.unity3d.splash.services.core.device.StorageEvent;
import com.unity3d.splash.services.core.device.StorageManager;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.JsonStorage;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import java.io.File;
import org.json.JSONObject;

public class Storage
extends JsonStorage {
    private String _targetFileName;
    private StorageManager.StorageType _type;

    public Storage(String string, StorageManager.StorageType storageType) {
        this._targetFileName = string;
        this._type = storageType;
    }

    public StorageManager.StorageType getType() {
        return this._type;
    }

    public synchronized boolean readStorage() {
        Object object = new File(this._targetFileName);
        try {
            byte[] byArray = Utilities.readFileBytes((File)object);
            object = byArray;
            if (byArray == null) {
                return false;
            }
            object = new String((byte[])object);
            this.setData(new JSONObject((String)object));
            return true;
        }
        catch (Exception exception) {
            DeviceLog.exception("Error creating storage JSON", exception);
            return false;
        }
    }

    public synchronized boolean initStorage() {
        this.readStorage();
        super.initData();
        return true;
    }

    public synchronized boolean writeStorage() {
        File file = new File(this._targetFileName);
        if (this.getData() != null) {
            return Utilities.writeFile(file, this.getData().toString());
        }
        return false;
    }

    public synchronized boolean clearStorage() {
        this.clearData();
        return new File(this._targetFileName).delete();
    }

    public synchronized boolean storageFileExists() {
        return new File(this._targetFileName).exists();
    }

    public synchronized void sendEvent(StorageEvent storageEvent, Object object) {
        boolean bl = false;
        if (WebViewApp.getCurrentApp() != null) {
            bl = WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORAGE, storageEvent, this._type.name(), object);
        }
        if (!bl) {
            DeviceLog.debug("Couldn't send storage event to WebApp");
        }
    }
}

