/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.device;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@TargetApi(value=9)
public class OpenAdvertisingId {
    private static final String HW_OPEN_ADVERTISING_ID_SERVICE_NAME = "com.uodis.opendevice.aidl.OpenDeviceIdentifierService";
    private static final String HW_DEVICE_NAME = "HUAWEI";
    private static OpenAdvertisingId instance = null;
    private String openAdvertisingIdentifier = null;
    private boolean limitedOpenAdTracking = false;

    private static OpenAdvertisingId getInstance() {
        if (instance == null) {
            instance = new OpenAdvertisingId();
        }
        return instance;
    }

    public static void init(Context context) {
        if (Build.MANUFACTURER.toUpperCase().equals(HW_DEVICE_NAME)) {
            OpenAdvertisingId.getInstance().fetchOAId(context);
        }
    }

    public static String getOpenAdvertisingTrackingId() {
        return OpenAdvertisingId.getInstance().openAdvertisingIdentifier;
    }

    public static boolean getLimitedOpenAdTracking() {
        return OpenAdvertisingId.getInstance().limitedOpenAdTracking;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetchOAId(Context context) {
        HWAdvertisingServiceConnection hWAdvertisingServiceConnection = new HWAdvertisingServiceConnection();
        Object object = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        object.setPackage("com.huawei.hwid");
        boolean bl = false;
        try {
            bl = context.bindService((Intent)object, (ServiceConnection)hWAdvertisingServiceConnection, 1);
        }
        catch (Exception exception) {
            DeviceLog.exception("Couldn't bind to identifier service intent", exception);
        }
        try {
            if (bl) {
                object = HWAdvertisingInfo.HWAdvertisingInfoBinder.create(hWAdvertisingServiceConnection.getBinder());
                this.openAdvertisingIdentifier = object.getId();
                this.limitedOpenAdTracking = object.getEnabled(true);
            }
            if (!bl) return;
        }
        catch (Exception exception) {
            DeviceLog.exception("Couldn't get openAdvertising info", exception);
            return;
        }
        finally {
            if (!bl) return;
            context.unbindService((ServiceConnection)hWAdvertisingServiceConnection);
        }
        context.unbindService((ServiceConnection)hWAdvertisingServiceConnection);
        return;
    }

    private class HWAdvertisingServiceConnection
    implements ServiceConnection {
        boolean _consumed = false;
        private final BlockingQueue _binderQueue = new LinkedBlockingQueue();

        private HWAdvertisingServiceConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this._binderQueue.put(iBinder);
                return;
            }
            catch (InterruptedException interruptedException) {
                DeviceLog.debug("Couldn't put service to binder que");
                return;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public IBinder getBinder() {
            if (this._consumed) {
                throw new IllegalStateException();
            }
            this._consumed = true;
            return (IBinder)this._binderQueue.take();
        }
    }

    private static interface HWAdvertisingInfo
    extends IInterface {
        public String getId();

        public boolean getEnabled(boolean var1);

        public static abstract class HWAdvertisingInfoBinder
        extends Binder
        implements HWAdvertisingInfo {
            public static HWAdvertisingInfo create(IBinder iBinder) {
                if (iBinder == null) {
                    return null;
                }
                IInterface iInterface = iBinder.queryLocalInterface(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                if (iInterface != null && iInterface instanceof HWAdvertisingInfo) {
                    return (HWAdvertisingInfo)iInterface;
                }
                return new HWAdvertisingInfoImplementation(iBinder);
            }

            public boolean onTransact(int n2, Parcel parcel, Parcel parcel2, int n3) {
                switch (n2) {
                    case 1: {
                        parcel.enforceInterface(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        String string = this.getId();
                        parcel2.writeNoException();
                        parcel2.writeString(string);
                        return true;
                    }
                    case 2: {
                        parcel.enforceInterface(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        n2 = 0 != parcel.readInt() ? 1 : 0;
                        n2 = this.getEnabled(n2 != 0) ? 1 : 0;
                        parcel2.writeNoException();
                        parcel2.writeInt(n2 != 0 ? 1 : 0);
                        return true;
                    }
                }
                return super.onTransact(n2, parcel, parcel2, n3);
            }

            private static class HWAdvertisingInfoImplementation
            implements HWAdvertisingInfo {
                private final IBinder _binder;

                HWAdvertisingInfoImplementation(IBinder iBinder) {
                    this._binder = iBinder;
                }

                public IBinder asBinder() {
                    return this._binder;
                }

                @Override
                public String getId() {
                    String string;
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    try {
                        parcel.writeInterfaceToken(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        this._binder.transact(1, parcel, parcel2, 0);
                        parcel2.readException();
                        string = parcel2.readString();
                    }
                    finally {
                        parcel2.recycle();
                        parcel.recycle();
                    }
                    return string;
                }

                @Override
                public boolean getEnabled(boolean bl) {
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    try {
                        parcel.writeInterfaceToken(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        parcel.writeInt(bl ? 1 : 0);
                        this._binder.transact(2, parcel, parcel2, 0);
                        parcel2.readException();
                        bl = 0 != parcel2.readInt();
                    }
                    finally {
                        parcel2.recycle();
                        parcel.recycle();
                    }
                    return bl;
                }
            }
        }
    }
}

