/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.device;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.unity3d.splash.services.core.device.AdvertisingId;
import com.unity3d.splash.services.core.device.OpenAdvertisingId;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.properties.ClientProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Device {
    public static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static int getScreenLayout() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getConfiguration().screenLayout;
        }
        return -1;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String getAndroidId() {
        String string = null;
        try {
            string = Settings.Secure.getString((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            DeviceLog.exception("Problems fetching androidId", exception);
        }
        return string;
    }

    public static String getAdvertisingTrackingId() {
        return AdvertisingId.getAdvertisingTrackingId();
    }

    public static boolean isLimitAdTrackingEnabled() {
        return AdvertisingId.getLimitedAdTracking();
    }

    public static String getOpenAdvertisingTrackingId() {
        return OpenAdvertisingId.getOpenAdvertisingTrackingId();
    }

    public static boolean isLimitOpenAdTrackingEnabled() {
        return OpenAdvertisingId.getLimitedOpenAdTracking();
    }

    public static boolean isUsingWifi() {
        if (ClientProperties.getApplicationContext() != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
            if (connectivityManager == null) {
                return false;
            }
            TelephonyManager telephonyManager = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !connectivityManager.getBackgroundDataSetting() || !connectivityManager.getActiveNetworkInfo().isConnected() || telephonyManager == null) {
                return false;
            }
            return networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return false;
    }

    public static int getNetworkType() {
        if (ClientProperties.getApplicationContext() != null) {
            return ((TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone")).getNetworkType();
        }
        return -1;
    }

    public static boolean getNetworkMetered() {
        if (ClientProperties.getApplicationContext() != null && Build.VERSION.SDK_INT >= 16) {
            ConnectivityManager connectivityManager = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
            if (connectivityManager == null) {
                return false;
            }
            return connectivityManager.isActiveNetworkMetered();
        }
        return false;
    }

    public static String getNetworkOperator() {
        if (ClientProperties.getApplicationContext() != null) {
            return ((TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone")).getNetworkOperator();
        }
        return "";
    }

    public static String getNetworkOperatorName() {
        if (ClientProperties.getApplicationContext() != null) {
            return ((TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone")).getNetworkOperatorName();
        }
        return "";
    }

    public static String getNetworkCountryISO() {
        if (ClientProperties.getApplicationContext() != null) {
            return ((TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone")).getNetworkCountryIso();
        }
        return "";
    }

    public static String getSIMMCC(Context object) {
        if ((object = ((TelephonyManager)object.getSystemService("phone")).getSimOperator()) != null & ((String)object).length() >= 3) {
            return ((String)object).substring(0, 3);
        }
        return "";
    }

    public static int getScreenDensity() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().densityDpi;
        }
        return -1;
    }

    public static int getScreenWidth() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().widthPixels;
        }
        return -1;
    }

    public static int getScreenHeight() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().heightPixels;
        }
        return -1;
    }

    public static boolean isActiveNetworkConnected() {
        ConnectivityManager connectivityManager;
        if (ClientProperties.getApplicationContext() != null && (connectivityManager = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity")) != null) {
            return (connectivityManager = connectivityManager.getActiveNetworkInfo()) != null && connectivityManager.isConnected();
        }
        return false;
    }

    public static boolean isAppInstalled(String string) {
        if (ClientProperties.getApplicationContext() != null) {
            PackageManager packageManager = ClientProperties.getApplicationContext().getPackageManager();
            try {
                packageManager = packageManager.getPackageInfo(string, 0);
                if (packageManager != null && packageManager.packageName != null && string.equals(packageManager.packageName)) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
        }
        return false;
    }

    public static List getInstalledPackages(boolean bl) {
        ArrayList arrayList = new ArrayList();
        if (ClientProperties.getApplicationContext() != null) {
            PackageManager packageManager = ClientProperties.getApplicationContext().getPackageManager();
            for (Object object : packageManager.getInstalledPackages(0)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                if (bl) {
                    hashMap.put("name", Utilities.Sha256(((PackageInfo)object).packageName));
                } else {
                    hashMap.put("name", ((PackageInfo)object).packageName);
                }
                if (((PackageInfo)object).firstInstallTime > 0L) {
                    hashMap.put("time", ((PackageInfo)object).firstInstallTime);
                }
                if ((object = packageManager.getInstallerPackageName(((PackageInfo)object).packageName)) != null && !((String)object).isEmpty()) {
                    hashMap.put("installer", object);
                }
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    public static String getUniqueEventId() {
        return UUID.randomUUID().toString();
    }

    public static boolean isWiredHeadsetOn() {
        if (ClientProperties.getApplicationContext() != null) {
            return ((AudioManager)ClientProperties.getApplicationContext().getSystemService("audio")).isWiredHeadsetOn();
        }
        return false;
    }

    public static String getSystemProperty(String string, String string2) {
        if (string2 != null) {
            return System.getProperty(string, string2);
        }
        return System.getProperty(string);
    }

    public static int getRingerMode() {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager audioManager = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            if (audioManager != null) {
                return audioManager.getRingerMode();
            }
            return -2;
        }
        return -1;
    }

    public static int getStreamVolume(int n2) {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager audioManager = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            if (audioManager != null) {
                return audioManager.getStreamVolume(n2);
            }
            return -2;
        }
        return -1;
    }

    public static int getStreamMaxVolume(int n2) {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager audioManager = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            if (audioManager != null) {
                return audioManager.getStreamMaxVolume(n2);
            }
            return -2;
        }
        return -1;
    }

    public static int getScreenBrightness() {
        if (ClientProperties.getApplicationContext() != null) {
            return Settings.System.getInt((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"screen_brightness", (int)-1);
        }
        return -1;
    }

    public static long getFreeSpace(File file) {
        if (file != null && file.exists()) {
            return Math.round(file.getFreeSpace() / 1024L);
        }
        return -1L;
    }

    public static long getTotalSpace(File file) {
        if (file != null && file.exists()) {
            return Math.round(file.getTotalSpace() / 1024L);
        }
        return -1L;
    }

    public static float getBatteryLevel() {
        Intent intent;
        if (ClientProperties.getApplicationContext() != null && (intent = ClientProperties.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            return (float)n2 / (float)n3;
        }
        return -1.0f;
    }

    public static int getBatteryStatus() {
        Intent intent;
        if (ClientProperties.getApplicationContext() != null && (intent = ClientProperties.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            return intent.getIntExtra("status", -1);
        }
        return -1;
    }

    public static long getTotalMemory() {
        return Device.getMemoryInfo(MemoryInfoType.TOTAL_MEMORY);
    }

    public static long getFreeMemory() {
        return Device.getMemoryInfo(MemoryInfoType.FREE_MEMORY);
    }

    private static long getMemoryInfo(MemoryInfoType memoryInfoType) {
        int n2 = -1;
        switch (memoryInfoType) {
            case TOTAL_MEMORY: {
                n2 = 1;
                break;
            }
            case FREE_MEMORY: {
                n2 = 2;
            }
        }
        RandomAccessFile randomAccessFile = null;
        String string = null;
        try {
            randomAccessFile = new RandomAccessFile("/proc/meminfo", "r");
            for (int i2 = 0; i2 < n2; ++i2) {
                string = randomAccessFile.readLine();
            }
            long l2 = Device.getMemoryValueFromString(string);
            return l2;
        }
        catch (IOException iOException) {
            DeviceLog.exception("Error while reading memory info: " + (Object)((Object)memoryInfoType), iOException);
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                DeviceLog.exception("Error closing RandomAccessFile", iOException);
            }
        }
        return -1L;
    }

    private static long getMemoryValueFromString(String object) {
        if (object != null) {
            object = Pattern.compile("(\\d+)").matcher((CharSequence)object);
            String string = "";
            while (((Matcher)object).find()) {
                string = ((Matcher)object).group(1);
            }
            return Long.parseLong(string);
        }
        return -1L;
    }

    public static boolean isRooted() {
        try {
            return Device.searchPathForBinary("su");
        }
        catch (Exception exception) {
            DeviceLog.exception("Rooted check failed", exception);
            return false;
        }
    }

    public static Boolean isAdbEnabled() {
        Boolean bl = Device.getApiLevel() < 17 ? Device.oldAdbStatus() : Device.newAdbStatus();
        return bl;
    }

    private static Boolean oldAdbStatus() {
        Boolean bl = null;
        try {
            bl = 1 == Settings.Secure.getInt((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"adb_enabled", (int)0);
        }
        catch (Exception exception) {
            DeviceLog.exception("Problems fetching adb enabled status", exception);
        }
        return bl;
    }

    @TargetApi(value=17)
    private static Boolean newAdbStatus() {
        Boolean bl = null;
        try {
            bl = 1 == Settings.Global.getInt((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"adb_enabled", (int)0);
        }
        catch (Exception exception) {
            DeviceLog.exception("Problems fetching adb enabled status", exception);
        }
        return bl;
    }

    private static boolean searchPathForBinary(String string) {
        for (String string2 : System.getenv("PATH").split(":")) {
            File[] fileArray;
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!fileArray2[i2].getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getGLVersion() {
        ActivityManager activityManager;
        if (ClientProperties.getApplicationContext() != null && (activityManager = (ActivityManager)ClientProperties.getApplicationContext().getSystemService("activity")) != null && (activityManager = activityManager.getDeviceConfigurationInfo()) != null) {
            return activityManager.getGlEsVersion();
        }
        return null;
    }

    public static String getApkDigest() {
        String string = ClientProperties.getApplicationContext().getPackageCodePath();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(string));
            string = Utilities.Sha256(inputStream);
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static String getCertificateFingerprint() {
        String string = null;
        Object object = ClientProperties.getApplicationContext().getPackageManager();
        Object object2 = ClientProperties.getApplicationContext().getPackageName();
        try {
            object = object.getPackageInfo((String)object2, (int)64).signatures;
            if (object.getPackageInfo((String)object2, (int)64).signatures != null && ((Signature[])object).length > 0) {
                object2 = CertificateFactory.getInstance("X.509");
                object = new ByteArrayInputStream(object[0].toByteArray());
                object = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object);
                string = Utilities.toHexString(MessageDigest.getInstance("SHA-1").digest(((Certificate)object).getEncoded()));
            }
        }
        catch (Exception exception) {
            DeviceLog.exception("Exception when signing certificate fingerprint", exception);
        }
        return string;
    }

    public static String getBoard() {
        return Build.BOARD;
    }

    public static String getBootloader() {
        return Build.BOOTLOADER;
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    public static String getDevice() {
        return Build.DEVICE;
    }

    public static String getHardware() {
        return Build.HARDWARE;
    }

    public static String getHost() {
        return Build.HOST;
    }

    public static String getProduct() {
        return Build.PRODUCT;
    }

    public static String getFingerprint() {
        return Build.FINGERPRINT;
    }

    public static ArrayList getSupportedAbis() {
        if (Device.getApiLevel() < 21) {
            return Device.getOldAbiList();
        }
        return Device.getNewAbiList();
    }

    public static List getSensorList() {
        if (ClientProperties.getApplicationContext() != null) {
            return ((SensorManager)ClientProperties.getApplicationContext().getSystemService("sensor")).getSensorList(-1);
        }
        return null;
    }

    public static boolean isUSBConnected() {
        Intent intent;
        if (ClientProperties.getApplicationContext() != null && (intent = ClientProperties.getApplicationContext().registerReceiver(null, new IntentFilter("android.hardware.usb.action.USB_STATE"))) != null) {
            return intent.getBooleanExtra("connected", false);
        }
        return false;
    }

    public static long getCPUCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getUptime() {
        return SystemClock.uptimeMillis();
    }

    public static long getElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    public static String getBuildId() {
        return Build.ID;
    }

    public static String getBuildVersionIncremental() {
        return Build.VERSION.INCREMENTAL;
    }

    private static ArrayList getOldAbiList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Build.CPU_ABI);
        arrayList.add(Build.CPU_ABI2);
        return arrayList;
    }

    @TargetApi(value=21)
    private static ArrayList getNewAbiList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(Build.SUPPORTED_ABIS));
        return arrayList;
    }

    public static Map getProcessInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile("/proc/self/stat", "r");
            String string = randomAccessFile.readLine();
            hashMap.put("stat", string);
        }
        catch (IOException iOException) {
            DeviceLog.exception("Error while reading processor info: ", iOException);
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                DeviceLog.exception("Error closing RandomAccessFile", iOException);
            }
        }
        return hashMap;
    }

    public static enum MemoryInfoType {
        TOTAL_MEMORY,
        FREE_MEMORY;

    }
}

