/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import com.unity3d.splash.services.core.connectivity.ConnectivityMonitor;
import com.unity3d.splash.services.core.properties.ClientProperties;

public class ConnectivityChangeReceiver
extends BroadcastReceiver {
    private static ConnectivityChangeReceiver _receiver = null;

    public static void register() {
        if (_receiver == null) {
            _receiver = new ConnectivityChangeReceiver();
            ClientProperties.getApplicationContext().registerReceiver((BroadcastReceiver)_receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    public static void unregister() {
        if (_receiver != null) {
            ClientProperties.getApplicationContext().unregisterReceiver((BroadcastReceiver)_receiver);
            _receiver = null;
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getBooleanExtra("noConnectivity", false)) {
            ConnectivityMonitor.disconnected();
            return;
        }
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return;
        }
        if ((context = context.getActiveNetworkInfo()) != null && context.isConnected()) {
            ConnectivityMonitor.connected();
        }
    }
}

