/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.cache;

import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import com.unity3d.splash.services.core.cache.CacheThreadHandler;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.util.HashMap;
import java.util.List;

public class CacheThread
extends Thread {
    private static CacheThreadHandler _handler = null;
    private static boolean _ready = false;
    private static final Object _readyLock = new Object();
    public static final int MSG_DOWNLOAD = 1;
    private static int _connectTimeout = 30000;
    private static int _readTimeout = 30000;
    private static int _progressInterval = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = new CacheThread();
        ((Thread)object).setName("UnityAdsCacheThread");
        ((Thread)object).start();
        while (!_ready) {
            try {
                object = _readyLock;
                synchronized (object) {
                    _readyLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                DeviceLog.debug("Couldn't synchronize thread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        _handler = new CacheThreadHandler();
        _ready = true;
        Object object = _readyLock;
        synchronized (object) {
            _readyLock.notify();
        }
        Looper.loop();
    }

    public static synchronized void download(String object, String string2, HashMap hashMap, boolean bl) {
        if (!_ready) {
            CacheThread.init();
        }
        Bundle bundle = new Bundle();
        bundle.putString("source", (String)object);
        bundle.putString("target", string2);
        bundle.putInt("connectTimeout", _connectTimeout);
        bundle.putInt("readTimeout", _readTimeout);
        bundle.putInt("progressInterval", _progressInterval);
        bundle.putBoolean("append", bl);
        if (hashMap != null) {
            for (String string2 : hashMap.keySet()) {
                String[] stringArray = new String[((List)hashMap.get(string2)).size()];
                bundle.putStringArray(string2, ((List)hashMap.get(string2)).toArray(stringArray));
            }
        }
        object = new Message();
        new Message().what = 1;
        object.setData(bundle);
        _handler.setCancelStatus(false);
        _handler.sendMessage((Message)object);
    }

    public static boolean isActive() {
        if (!_ready) {
            return false;
        }
        return _handler.isActive();
    }

    public static void cancel() {
        if (!_ready) {
            return;
        }
        _handler.removeMessages(1);
        _handler.setCancelStatus(true);
    }

    public static void setProgressInterval(int n2) {
        _progressInterval = n2;
    }

    public static int getProgressInterval() {
        return _progressInterval;
    }

    public static void setConnectTimeout(int n2) {
        _connectTimeout = n2;
    }

    public static void setReadTimeout(int n2) {
        _readTimeout = n2;
    }

    public static int getConnectTimeout() {
        return _connectTimeout;
    }

    public static int getReadTimeout() {
        return _readTimeout;
    }
}

