/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.cache;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.unity3d.splash.services.core.cache.CacheDirectoryType;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class CacheDirectory {
    private static final String TEST_FILE_NAME = "UnityAdsTest.txt";
    private String _cacheDirName;
    private boolean _initialized = false;
    private File _cacheDirectory = null;
    private CacheDirectoryType _type = null;

    public CacheDirectory(String string) {
        this._cacheDirName = string;
    }

    public File getCacheDirectory(Context context) {
        File file;
        if (this._initialized) {
            return this._cacheDirectory;
        }
        this._initialized = true;
        if (Build.VERSION.SDK_INT > 18) {
            if ("mounted".equals(Environment.getExternalStorageState())) {
                file = null;
                try {
                    file = this.createCacheDirectory(context.getExternalCacheDir(), this._cacheDirName);
                }
                catch (Exception exception) {
                    DeviceLog.exception("Creating external cache directory failed", exception);
                }
                if (this.testCacheDirectory(file)) {
                    this.createNoMediaFile(file);
                    this._cacheDirectory = file;
                    this._type = CacheDirectoryType.EXTERNAL;
                    DeviceLog.debug("Unity Ads is using external cache directory: " + file.getAbsolutePath());
                    return this._cacheDirectory;
                }
            } else {
                DeviceLog.debug("External media not mounted");
            }
        }
        if (this.testCacheDirectory(file = context.getFilesDir())) {
            this._cacheDirectory = file;
            this._type = CacheDirectoryType.INTERNAL;
            DeviceLog.debug("Unity Ads is using internal cache directory: " + file.getAbsolutePath());
            return this._cacheDirectory;
        }
        DeviceLog.error("Unity Ads failed to initialize cache directory");
        return null;
    }

    public CacheDirectoryType getType() {
        return this._type;
    }

    public File createCacheDirectory(File file, String string) {
        if (file == null) {
            return null;
        }
        file = new File(file, string);
        file.mkdirs();
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    public boolean testCacheDirectory(File file) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        try {
            Object object = "test".getBytes("UTF-8");
            byte[] byArray = new byte[((byte[])object).length];
            File file2 = new File(file, TEST_FILE_NAME);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write((byte[])object);
            fileOutputStream.flush();
            fileOutputStream.close();
            FileInputStream fileInputStream = new FileInputStream(file2);
            object = fileInputStream;
            int n2 = fileInputStream.read(byArray, 0, byArray.length);
            ((FileInputStream)object).close();
            if (!file2.delete()) {
                DeviceLog.debug("Failed to delete testfile " + file2.getAbsoluteFile());
                return false;
            }
            if (n2 != byArray.length) {
                DeviceLog.debug("Read buffer size mismatch");
                return false;
            }
            if (new String(byArray, "UTF-8").equals("test")) {
                return true;
            }
            DeviceLog.debug("Read buffer content mismatch");
            return false;
        }
        catch (Exception exception) {
            DeviceLog.debug("Unity Ads exception while testing cache directory " + file.getAbsolutePath() + ": " + exception.getMessage());
            return false;
        }
    }

    private void createNoMediaFile(File file) {
        file = new File(file, ".nomedia");
        try {
            if (file.createNewFile()) {
                DeviceLog.debug("Successfully created .nomedia file");
                return;
            }
            DeviceLog.debug("Using existing .nomedia file");
            return;
        }
        catch (Exception exception) {
            DeviceLog.exception("Failed to create .nomedia file", exception);
            return;
        }
    }
}

