/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.api;

import android.annotation.TargetApi;
import android.app.Application;
import com.unity3d.splash.services.core.lifecycle.LifecycleError;
import com.unity3d.splash.services.core.lifecycle.LifecycleListener;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;

@TargetApi(value=14)
public class Lifecycle {
    private static LifecycleListener _listener;

    @WebViewExposed
    public static void register(JSONArray jSONArray, WebViewCallback webViewCallback) {
        if (ClientProperties.getApplication() != null) {
            if (Lifecycle.getLifecycleListener() == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    try {
                        arrayList.add((String)jSONArray.get(i2));
                        continue;
                    }
                    catch (JSONException jSONException) {
                        webViewCallback.error(LifecycleError.JSON_ERROR, new Object[0]);
                        return;
                    }
                }
                Lifecycle.setLifecycleListener(new LifecycleListener(arrayList));
                ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                webViewCallback.invoke(new Object[0]);
                return;
            }
            webViewCallback.error(LifecycleError.LISTENER_NOT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(LifecycleError.APPLICATION_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void unregister(WebViewCallback webViewCallback) {
        if (ClientProperties.getApplication() != null) {
            if (Lifecycle.getLifecycleListener() != null) {
                ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                Lifecycle.setLifecycleListener(null);
            }
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(LifecycleError.APPLICATION_NULL, new Object[0]);
    }

    public static LifecycleListener getLifecycleListener() {
        return _listener;
    }

    public static void setLifecycleListener(LifecycleListener lifecycleListener) {
        _listener = lifecycleListener;
    }
}

