/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.webplayer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.http.SslError;
import android.os.Build;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ClientCertRequest;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.unity3d.splash.services.ads.webplayer.WebPlayerBridgeInterface;
import com.unity3d.splash.services.ads.webplayer.WebPlayerEvent;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.misc.ViewUtilities;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebPlayer
extends WebView {
    private Map _erroredSettings;
    private JSONObject _eventSettings;
    private Method _evaluateJavascript = null;
    private String viewId;

    public WebPlayer(Context context, String string, JSONObject jSONObject, JSONObject jSONObject2) {
        super(context);
        this.viewId = string;
        context = this.getSettings();
        if (Build.VERSION.SDK_INT >= 16) {
            context.setAllowFileAccessFromFileURLs(false);
            context.setAllowUniversalAccessFromFileURLs(false);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                this._evaluateJavascript = WebView.class.getMethod("evaluateJavascript", String.class, ValueCallback.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DeviceLog.exception("Method evaluateJavascript not found", noSuchMethodException);
                this._evaluateJavascript = null;
            }
        }
        context.setAppCacheEnabled(false);
        context.setCacheMode(2);
        context.setDatabaseEnabled(false);
        context.setDomStorageEnabled(false);
        context.setGeolocationEnabled(false);
        context.setJavaScriptEnabled(true);
        context.setLoadsImagesAutomatically(true);
        context.setPluginState(WebSettings.PluginState.OFF);
        context.setRenderPriority(WebSettings.RenderPriority.NORMAL);
        context.setSaveFormData(false);
        context.setSavePassword(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setInitialScale(0);
        this.setBackgroundColor(0);
        ViewUtilities.setBackground((View)this, (Drawable)new ColorDrawable(0));
        this.setBackgroundResource(0);
        this.setSettings(jSONObject, jSONObject2);
        this.setWebViewClient(new WebPlayerClient());
        this.setWebChromeClient(new WebPlayerChromeClient());
        this.setDownloadListener(new WebPlayerDownloadListener());
        this.addJavascriptInterface(new WebPlayerBridgeInterface(string), "webplayerbridge");
    }

    public void setEventSettings(JSONObject jSONObject) {
        this._eventSettings = jSONObject;
    }

    public void setSettings(JSONObject jSONObject, JSONObject jSONObject2) {
        if (this._erroredSettings != null) {
            this._erroredSettings.clear();
        }
        WebSettings webSettings = this.getSettings();
        this.setTargetSettings(webSettings, jSONObject);
        this.setTargetSettings((Object)this, jSONObject2);
    }

    public Map getErroredSettings() {
        return this._erroredSettings;
    }

    private Object setTargetSettings(Object object, JSONObject jSONObject) {
        if (jSONObject != null) {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    JSONArray jSONArray = jSONObject.getJSONArray(string);
                    Class[] classArray = this.getTypes(jSONArray);
                    object.getClass().getMethod(string, classArray).invoke(object, this.getValues(jSONArray));
                }
                catch (Exception exception) {
                    this.addErroredSetting(string, exception.getMessage());
                    DeviceLog.exception("Setting errored", exception);
                }
            }
        }
        return object;
    }

    public void invokeJavascript(String string) {
        Utilities.runOnUiThread(new JavaScriptInvocation(string, this));
    }

    public void sendEvent(JSONArray jSONArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:window.nativebridge.receiveEvent(");
        stringBuilder.append(jSONArray.toString());
        stringBuilder.append(")");
        this.invokeJavascript(stringBuilder.toString());
    }

    private Class[] getTypes(JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        Class[] classArray = new Class[jSONArray.length()];
        if (jSONArray != null) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                Class<?> clazz;
                if (jSONArray.get(i2) instanceof JSONObject) {
                    clazz = Class.forName(((JSONObject)jSONArray.get(i2)).getString("className"));
                    if (clazz == null) continue;
                    classArray[i2] = clazz;
                    continue;
                }
                clazz = jSONArray.get(i2).getClass();
                classArray[i2] = this.getPrimitiveClass(clazz);
            }
        }
        return classArray;
    }

    public Class getPrimitiveClass(Class clazz) {
        String string = clazz.getName();
        if (string.equals("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (string.equals("java.lang.Short")) {
            return Short.TYPE;
        }
        if (string.equals("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (string.equals("java.lang.Long")) {
            return Long.TYPE;
        }
        if (string.equals("java.lang.Character")) {
            return Character.TYPE;
        }
        if (string.equals("java.lang.Float")) {
            return Float.TYPE;
        }
        if (string.equals("java.lang.Double")) {
            return Double.TYPE;
        }
        if (string.equals("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("java.lang.Void")) {
            return Void.TYPE;
        }
        return clazz;
    }

    private Object[] getValues(JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        Object[] objectArray = new Object[jSONArray.length()];
        Object[] objectArray2 = new Object[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            if (jSONArray.get(i2) instanceof JSONObject) {
                Object object = (JSONObject)jSONArray.get(i2);
                Object object2 = object.get("value");
                String string = object.getString("type");
                String string2 = null;
                if (object.has("className")) {
                    string2 = object.getString("className");
                }
                if (string2 == null || !string.equals("Enum") || (object = Class.forName(string2)) == null) continue;
                objectArray2[i2] = Enum.valueOf(object, (String)object2);
                continue;
            }
            objectArray2[i2] = jSONArray.get(i2);
        }
        if (jSONArray != null) {
            System.arraycopy(objectArray2, 0, objectArray, 0, jSONArray.length());
        }
        return objectArray;
    }

    private void addErroredSetting(String string, String string2) {
        if (this._erroredSettings == null) {
            this._erroredSettings = new HashMap();
        }
        this._erroredSettings.put(string, string2);
    }

    private boolean shouldCallSuper(String string) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(string) && this._eventSettings.getJSONObject(string).has("callSuper")) {
                return this._eventSettings.getJSONObject(string).getBoolean("callSuper");
            }
        }
        catch (Exception exception) {
            DeviceLog.exception("Error getting super call status", exception);
        }
        return true;
    }

    private boolean shouldSendEvent(String string) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(string) && this._eventSettings.getJSONObject(string).has("sendEvent")) {
                return this._eventSettings.getJSONObject(string).getBoolean("sendEvent");
            }
        }
        catch (Exception exception) {
            DeviceLog.exception("Error getting send event status", exception);
        }
        return false;
    }

    private Object getReturnValue(String string, Class clazz, Object object) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(string) && this._eventSettings.getJSONObject(string).has("returnValue")) {
                return clazz.cast(this._eventSettings.getJSONObject(string).get("returnValue"));
            }
        }
        catch (Exception exception) {
            DeviceLog.exception("Error getting default return value", exception);
        }
        return object;
    }

    private boolean hasReturnValue(String string) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(string) && this._eventSettings.getJSONObject(string).has("returnValue")) {
                return true;
            }
        }
        catch (Exception exception) {
            DeviceLog.exception("Error getting default return value", exception);
        }
        return false;
    }

    private class WebPlayerDownloadListener
    implements DownloadListener {
        private WebPlayerDownloadListener() {
        }

        public void onDownloadStart(String string, String string2, String string3, String string4, long l2) {
            if (WebPlayer.this.shouldSendEvent("onDownloadStart")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.DOWNLOAD_START, string, string2, string3, string4, l2, WebPlayer.this.viewId);
            }
        }
    }

    @TargetApi(value=21)
    private class WebPlayerChromeClient
    extends WebChromeClient {
        private WebPlayerChromeClient() {
        }

        public void onGeolocationPermissionsShowPrompt(String string, GeolocationPermissions.Callback callback) {
            if (WebPlayer.this.shouldCallSuper("onGeolocationPermissionsShowPrompt")) {
                super.onGeolocationPermissionsShowPrompt(string, callback);
            }
            if (WebPlayer.this.shouldSendEvent("onGeolocationPermissionsShowPrompt")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.GEOLOCATION_PERMISSIONS_SHOW, string, WebPlayer.this.viewId);
            }
        }

        public void onPermissionRequest(PermissionRequest permissionRequest) {
            if (WebPlayer.this.shouldCallSuper("onPermissionRequest")) {
                super.onPermissionRequest(permissionRequest);
            }
            if (WebPlayer.this.shouldSendEvent("onPermissionRequest")) {
                String string = "";
                if (permissionRequest != null && permissionRequest.getOrigin() != null) {
                    string = permissionRequest.getOrigin().toString();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PERMISSION_REQUEST, string, WebPlayer.this.viewId);
            }
        }

        public void onProgressChanged(WebView webView, int n2) {
            if (WebPlayer.this.shouldCallSuper("onProgressChanged")) {
                super.onProgressChanged(webView, n2);
            }
            if (WebPlayer.this.shouldSendEvent("onProgressChanged")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PROGRESS_CHANGED, n2, WebPlayer.this.viewId);
            }
        }

        public void onReceivedTitle(WebView webView, String string) {
            if (WebPlayer.this.shouldCallSuper("onReceivedTitle")) {
                super.onReceivedTitle(webView, string);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedTitle")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.RECEIVED_TITLE, string, WebPlayer.this.viewId);
            }
        }

        public void onReceivedIcon(WebView webView, Bitmap bitmap) {
            if (WebPlayer.this.shouldCallSuper("onReceivedIcon")) {
                super.onReceivedIcon(webView, bitmap);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedIcon")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.RECEIVED_ICON, WebPlayer.this.viewId);
            }
        }

        public void onReceivedTouchIconUrl(WebView webView, String string, boolean bl) {
            if (WebPlayer.this.shouldCallSuper("onReceivedTouchIconUrl")) {
                super.onReceivedTouchIconUrl(webView, string, bl);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedTouchIconUrl")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.RECEIVED_TOUCH_ICON_URL, string, bl, WebPlayer.this.viewId);
            }
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
            if (WebPlayer.this.shouldCallSuper("onShowCustomView")) {
                super.onShowCustomView(view, customViewCallback);
            }
            if (WebPlayer.this.shouldSendEvent("onShowCustomView")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOW_CUSTOM_VIEW, WebPlayer.this.viewId);
            }
        }

        public void onHideCustomView() {
            if (WebPlayer.this.shouldCallSuper("onHideCustomView")) {
                super.onHideCustomView();
            }
            if (WebPlayer.this.shouldSendEvent("onHideCustomView")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.HIDE_CUSTOM_VIEW, WebPlayer.this.viewId);
            }
        }

        public boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
            Boolean bl3 = false;
            if (WebPlayer.this.shouldCallSuper("onCreateWindow")) {
                bl3 = super.onCreateWindow(webView, bl, bl2, message);
            }
            if (WebPlayer.this.shouldSendEvent("onCreateWindow")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CREATE_WINDOW, bl, bl2, message, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("onCreateWindow")) {
                bl3 = (Boolean)WebPlayer.this.getReturnValue("onCreateWindow", Boolean.class, false);
            }
            return bl3;
        }

        public void onRequestFocus(WebView webView) {
            if (WebPlayer.this.shouldCallSuper("onRequestFocus")) {
                super.onRequestFocus(webView);
            }
            if (WebPlayer.this.shouldSendEvent("onRequestFocus")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.REQUEST_FOCUS, WebPlayer.this.viewId);
            }
        }

        public void onCloseWindow(WebView webView) {
            if (WebPlayer.this.shouldCallSuper("onCloseWindow")) {
                super.onCloseWindow(webView);
            }
            if (WebPlayer.this.shouldSendEvent("onCloseWindow")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CLOSE_WINDOW, WebPlayer.this.viewId);
            }
        }

        public boolean onJsAlert(WebView webView, String string, String string2, JsResult jsResult) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("onJsAlert")) {
                bl = super.onJsAlert(webView, string, string2, jsResult);
            }
            if (WebPlayer.this.shouldSendEvent("onJsAlert")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.JS_ALERT, string, string2, jsResult, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("onJsAlert")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("onJsAlert", Boolean.class, true);
            }
            return bl;
        }

        public boolean onJsConfirm(WebView webView, String string, String string2, JsResult jsResult) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("onJsConfirm")) {
                bl = super.onJsConfirm(webView, string, string2, jsResult);
            }
            if (WebPlayer.this.shouldSendEvent("onJsConfirm")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.JS_CONFIRM, string, string2, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("onJsConfirm")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("onJsConfirm", Boolean.class, true);
            }
            return bl;
        }

        public boolean onJsPrompt(WebView webView, String string, String string2, String string3, JsPromptResult jsPromptResult) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("onJsPrompt")) {
                bl = super.onJsPrompt(webView, string, string2, string3, jsPromptResult);
            }
            if (WebPlayer.this.shouldSendEvent("onJsPrompt")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.JS_PROMPT, string, string2, string3, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("onJsPrompt")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("onJsPrompt", Boolean.class, true);
            }
            return bl;
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("onConsoleMessage")) {
                bl = super.onConsoleMessage(consoleMessage);
            }
            if (WebPlayer.this.shouldSendEvent("onConsoleMessage")) {
                String string = "";
                if (consoleMessage != null) {
                    string = consoleMessage.message();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CONSOLE_MESSAGE, string, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("onConsoleMessage")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("onConsoleMessage", Boolean.class, true);
            }
            return bl;
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback valueCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("onShowFileChooser")) {
                bl = super.onShowFileChooser(webView, valueCallback, fileChooserParams);
            }
            if (WebPlayer.this.shouldSendEvent("onShowFileChooser")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOW_FILE_CHOOSER, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("onShowFileChooser") && (bl = (Boolean)WebPlayer.this.getReturnValue("onShowFileChooser", Boolean.class, true)).booleanValue()) {
                valueCallback.onReceiveValue(null);
            }
            return bl;
        }
    }

    private class WebPlayerClient
    extends WebViewClient {
        private WebPlayerClient() {
        }

        public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
            if (WebPlayer.this.shouldCallSuper("onPageStarted")) {
                super.onPageStarted(webView, string, bitmap);
            }
            if (WebPlayer.this.shouldSendEvent("onPageStarted")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PAGE_STARTED, string, WebPlayer.this.viewId);
            }
        }

        public void onPageFinished(WebView webView, String string) {
            if (WebPlayer.this.shouldCallSuper("onPageFinished")) {
                super.onPageFinished(webView, string);
            }
            if (WebPlayer.this.shouldSendEvent("onPageFinished")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PAGE_FINISHED, string, WebPlayer.this.viewId);
            }
        }

        public void onReceivedError(WebView webView, int n2, String string, String string2) {
            if (WebPlayer.this.shouldCallSuper("onReceivedError")) {
                super.onReceivedError(webView, n2, string, string2);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedError")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.ERROR, string2, string, WebPlayer.this.viewId);
            }
        }

        @TargetApi(value=25)
        public void onReceivedError(WebView object, WebResourceRequest webResourceRequest, WebResourceError object2) {
            if (WebPlayer.this.shouldCallSuper("onReceivedError")) {
                super.onReceivedError(object, webResourceRequest, object2);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedError")) {
                object = "";
                if (object2 != null && object2.getDescription() != null) {
                    object = object2.getDescription().toString();
                }
                object2 = "";
                if (webResourceRequest != null && webResourceRequest.getUrl() != null) {
                    object2 = webResourceRequest.getUrl().toString();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.ERROR, object2, object, WebPlayer.this.viewId);
            }
        }

        public void onLoadResource(WebView webView, String string) {
            if (WebPlayer.this.shouldCallSuper("onLoadResource")) {
                super.onLoadResource(webView, string);
            }
            if (WebPlayer.this.shouldSendEvent("onLoadResource")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.LOAD_RESOUCE, string, WebPlayer.this.viewId);
            }
        }

        @TargetApi(value=14)
        public void onReceivedSslError(WebView object, SslErrorHandler sslErrorHandler, SslError sslError) {
            if (WebPlayer.this.shouldCallSuper("onReceivedSslError")) {
                super.onReceivedSslError(object, sslErrorHandler, sslError);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedSslError")) {
                object = "";
                if (sslError != null) {
                    object = sslError.getUrl();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SSL_ERROR, object, WebPlayer.this.viewId);
            }
        }

        @TargetApi(value=21)
        public void onReceivedClientCertRequest(WebView object, ClientCertRequest clientCertRequest) {
            if (WebPlayer.this.shouldCallSuper("onReceivedClientCertRequest")) {
                super.onReceivedClientCertRequest(object, clientCertRequest);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedClientCertRequest")) {
                object = "";
                int n2 = -1;
                if (clientCertRequest != null) {
                    object = clientCertRequest.getHost();
                    n2 = clientCertRequest.getPort();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CLIENT_CERT_REQUEST, object, n2, WebPlayer.this.viewId);
            }
        }

        public void onReceivedHttpAuthRequest(WebView webView, HttpAuthHandler httpAuthHandler, String string, String string2) {
            if (WebPlayer.this.shouldCallSuper("onReceivedHttpAuthRequest")) {
                super.onReceivedHttpAuthRequest(webView, httpAuthHandler, string, string2);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedHttpAuthRequest")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.HTTP_AUTH_REQUEST, string, string2, WebPlayer.this.viewId);
            }
        }

        public void onScaleChanged(WebView webView, float f2, float f3) {
            if (WebPlayer.this.shouldCallSuper("onScaleChanged")) {
                super.onScaleChanged(webView, f2, f3);
            }
            if (WebPlayer.this.shouldSendEvent("onScaleChanged")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SCALE_CHANGED, Float.valueOf(f2), Float.valueOf(f3), WebPlayer.this.viewId);
            }
        }

        public void onReceivedLoginRequest(WebView webView, String string, String string2, String string3) {
            if (WebPlayer.this.shouldCallSuper("onReceivedLoginRequest")) {
                super.onReceivedLoginRequest(webView, string, string2, string3);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedLoginRequest")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.LOGIN_REQUEST, string, string2, string3, WebPlayer.this.viewId);
            }
        }

        @TargetApi(value=21)
        public void onReceivedHttpError(WebView object, WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
            if (WebPlayer.this.shouldCallSuper("onReceivedHttpError")) {
                super.onReceivedHttpError(object, webResourceRequest, webResourceResponse);
            }
            if (WebPlayer.this.shouldSendEvent("onReceivedHttpError")) {
                object = "";
                if (webResourceRequest != null && webResourceRequest.getUrl() != null) {
                    object = webResourceRequest.getUrl().toString();
                }
                int n2 = -1;
                String string = "";
                if (webResourceResponse != null) {
                    n2 = webResourceResponse.getStatusCode();
                    string = webResourceResponse.getReasonPhrase();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.HTTP_ERROR, object, string, n2, WebPlayer.this.viewId);
            }
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("shouldOverrideUrlLoading")) {
                bl = super.shouldOverrideUrlLoading(webView, webResourceRequest);
            }
            if (WebPlayer.this.shouldSendEvent("shouldOverrideUrlLoading")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_OVERRIDE_URL_LOADING, webResourceRequest.getUrl().toString(), webResourceRequest.getMethod(), WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("shouldOverrideUrlLoading")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("shouldOverrideUrlLoading", Boolean.class, true);
            }
            return bl;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("shouldOverrideUrlLoading")) {
                bl = super.shouldOverrideUrlLoading(webView, string);
            }
            if (WebPlayer.this.shouldSendEvent("shouldOverrideUrlLoading")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_OVERRIDE_URL_LOADING, string, WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("shouldOverrideUrlLoading")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("shouldOverrideUrlLoading", Boolean.class, true);
            }
            return bl;
        }

        public void onPageCommitVisible(WebView webView, String string) {
            if (WebPlayer.this.shouldCallSuper("onPageCommitVisible")) {
                super.onPageCommitVisible(webView, string);
            }
            if (WebPlayer.this.shouldSendEvent("onPageCommitVisible")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PAGE_COMMIT_VISIBLE, string, WebPlayer.this.viewId);
            }
        }

        @TargetApi(value=21)
        public WebResourceResponse shouldInterceptRequest(WebView webView, WebResourceRequest webResourceRequest) {
            WebResourceResponse webResourceResponse = null;
            if (WebPlayer.this.shouldCallSuper("shouldInterceptRequest")) {
                webResourceResponse = super.shouldInterceptRequest(webView, webResourceRequest);
            }
            if (WebPlayer.this.shouldSendEvent("shouldInterceptRequest")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_INTERCEPT_REQUEST, webResourceRequest.getUrl().toString(), WebPlayer.this.viewId);
            }
            return webResourceResponse;
        }

        public void onFormResubmission(WebView webView, Message message, Message message2) {
            if (WebPlayer.this.shouldCallSuper("onFormResubmission")) {
                super.onFormResubmission(webView, message, message2);
            }
            if (WebPlayer.this.shouldSendEvent("onFormResubmission")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.FORM_RESUBMISSION, WebPlayer.this.viewId);
            }
        }

        public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
            Boolean bl = false;
            if (WebPlayer.this.shouldCallSuper("shouldOverrideKeyEvent")) {
                bl = super.shouldOverrideKeyEvent(webView, keyEvent);
            }
            if (WebPlayer.this.shouldSendEvent("shouldOverrideKeyEvent")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_OVERRIDE_KEY_EVENT, keyEvent.getKeyCode(), keyEvent.getAction(), WebPlayer.this.viewId);
            }
            if (WebPlayer.this.hasReturnValue("shouldOverrideKeyEvent")) {
                bl = (Boolean)WebPlayer.this.getReturnValue("shouldOverrideKeyEvent", Boolean.class, true);
            }
            return bl;
        }

        public void onUnhandledKeyEvent(WebView webView, KeyEvent keyEvent) {
            if (WebPlayer.this.shouldCallSuper("onUnhandledKeyEvent")) {
                super.onUnhandledKeyEvent(webView, keyEvent);
            }
            if (WebPlayer.this.shouldSendEvent("onUnhandledKeyEvent")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.UNHANDLED_KEY_EVENT, keyEvent.getKeyCode(), keyEvent.getAction(), WebPlayer.this.viewId);
            }
        }
    }

    private class JavaScriptInvocation
    implements Runnable {
        private String _jsString = null;
        private WebView _webView = null;

        public JavaScriptInvocation(String string, WebView webView) {
            this._jsString = string;
            this._webView = webView;
        }

        @Override
        public void run() {
            if (this._jsString != null) {
                try {
                    if (Build.VERSION.SDK_INT >= 19) {
                        WebPlayer.this._evaluateJavascript.invoke((Object)this._webView, this._jsString, null);
                        return;
                    }
                    WebPlayer.this.loadUrl(this._jsString);
                    return;
                }
                catch (Exception exception) {
                    DeviceLog.exception("Error while processing JavaScriptString", exception);
                    return;
                }
            }
            DeviceLog.error("Could not process JavaScript, the string is NULL");
        }
    }
}

