/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.load;

import android.text.TextUtils;
import com.unity3d.splash.services.ads.load.ILoadBridge;
import com.unity3d.splash.services.ads.load.LoadBridge;
import com.unity3d.splash.services.core.configuration.IInitializationListener;
import com.unity3d.splash.services.core.configuration.IInitializationNotificationCenter;
import com.unity3d.splash.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.splash.services.core.properties.SdkProperties;
import java.util.LinkedHashMap;

public class LoadModule
implements IInitializationListener {
    private static LoadModule instance;
    private ILoadBridge _loadBridge;
    private IInitializationNotificationCenter _initializationNotificationCenter;
    private LinkedHashMap _loadEventBuffer = new LinkedHashMap();

    public static LoadModule getInstance() {
        if (instance == null) {
            LoadBridge loadBridge = new LoadBridge();
            InitializationNotificationCenter initializationNotificationCenter = InitializationNotificationCenter.getInstance();
            instance = new LoadModule(loadBridge, initializationNotificationCenter);
        }
        return instance;
    }

    public LoadModule(ILoadBridge iLoadBridge, IInitializationNotificationCenter iInitializationNotificationCenter) {
        this._loadBridge = iLoadBridge;
        this._initializationNotificationCenter = iInitializationNotificationCenter;
        this._initializationNotificationCenter.addListener(this);
    }

    public synchronized void load(String string) {
        this.addPlacementId(string);
        if (SdkProperties.isInitialized()) {
            this.sendLoadEvents();
        }
    }

    @Override
    public synchronized void onSdkInitialized() {
        this.sendLoadEvents();
    }

    @Override
    public void onSdkInitializationFailed(String string, int n2) {
    }

    private void addPlacementId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this._loadEventBuffer.containsKey(string)) {
                Integer n2 = (Integer)this._loadEventBuffer.get(string);
                if (n2 != null) {
                    n2 = n2 + 1;
                    this._loadEventBuffer.put(string, n2);
                    return;
                }
                this._loadEventBuffer.put(string, new Integer(1));
                return;
            }
            this._loadEventBuffer.put(string, new Integer(1));
        }
    }

    private void sendLoadEvents() {
        if (this._loadEventBuffer.keySet().size() > 0) {
            this._loadBridge.loadPlacements(this._loadEventBuffer);
        }
        this._loadEventBuffer = new LinkedHashMap();
    }
}

