/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.api;

import android.os.Build;
import com.unity3d.splash.services.ads.video.VideoPlayerError;
import com.unity3d.splash.services.ads.video.VideoPlayerEvent;
import com.unity3d.splash.services.ads.video.VideoPlayerView;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;

public class VideoPlayer {
    private static VideoPlayerView _videoPlayerView;

    public static void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        _videoPlayerView = videoPlayerView;
    }

    public static VideoPlayerView getVideoPlayerView() {
        return _videoPlayerView;
    }

    @WebViewExposed
    public static void setProgressEventInterval(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().setProgressEventInterval(n2);
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getProgressEventInterval(WebViewCallback webViewCallback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(VideoPlayer.getVideoPlayerView().getProgressEventInterval());
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void prepare(String string, Double d2, WebViewCallback webViewCallback) {
        VideoPlayer.prepare(string, d2, 0, webViewCallback);
    }

    @WebViewExposed
    public static void prepare(final String string, final Double d2, final Integer n2, WebViewCallback webViewCallback) {
        DeviceLog.debug("Preparing video for playback: " + string);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().prepare(string, d2.floatValue(), n2);
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(string);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void play(WebViewCallback webViewCallback) {
        DeviceLog.debug("Starting playback of prepared video");
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().play();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void pause(WebViewCallback webViewCallback) {
        DeviceLog.debug("Pausing current video");
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().pause();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void stop(WebViewCallback webViewCallback) {
        DeviceLog.debug("Stopping current video");
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().stop();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void seekTo(final Integer n2, WebViewCallback webViewCallback) {
        DeviceLog.debug("Seeking video to time: " + n2);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().seekTo(n2);
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getCurrentPosition(WebViewCallback webViewCallback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(VideoPlayer.getVideoPlayerView().getCurrentPosition());
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getVolume(WebViewCallback webViewCallback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(Float.valueOf(VideoPlayer.getVideoPlayerView().getVolume()));
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setVolume(Double d2, WebViewCallback webViewCallback) {
        DeviceLog.debug("Setting video volume: " + d2);
        if (VideoPlayer.getVideoPlayerView() != null) {
            VideoPlayer.getVideoPlayerView().setVolume(Float.valueOf(d2.floatValue()));
            webViewCallback.invoke(d2);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setInfoListenerEnabled(boolean bl, WebViewCallback webViewCallback) {
        if (Build.VERSION.SDK_INT > 16) {
            if (VideoPlayer.getVideoPlayerView() != null) {
                VideoPlayer.getVideoPlayerView().setInfoListenerEnabled(bl);
                webViewCallback.invoke(new Object[]{WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.INFO, bl});
                return;
            }
            webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(VideoPlayerError.API_LEVEL_ERROR, Build.VERSION.SDK_INT, bl);
    }

    @WebViewExposed
    public static void getVideoViewRectangle(WebViewCallback webViewCallback) {
        Object object = VideoPlayer.getVideoPlayerView();
        if (object != null) {
            object = object.getVideoViewRectangle();
            webViewCallback.invoke((int)object[0], (int)object[1], (int)object[2], (int)object[3]);
            return;
        }
        webViewCallback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
    }
}

