/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.adunit;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.widget.RelativeLayout;
import com.unity3d.splash.services.ads.adunit.AdUnitMotionEvent;
import java.util.ArrayList;

public class AdUnitRelativeLayout
extends RelativeLayout {
    private final ArrayList _motionEvents = new ArrayList();
    private int _maxEvents = 10000;
    private boolean _shouldCapture = false;

    public AdUnitRelativeLayout(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=14)
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        super.onInterceptTouchEvent(motionEvent);
        if (this._shouldCapture && this._motionEvents.size() < this._maxEvents) {
            boolean bl = (motionEvent.getFlags() & 1) != 0;
            ArrayList arrayList = this._motionEvents;
            synchronized (arrayList) {
                this._motionEvents.add(new AdUnitMotionEvent(motionEvent.getActionMasked(), bl, motionEvent.getToolType(0), motionEvent.getSource(), motionEvent.getDeviceId(), motionEvent.getX(0), motionEvent.getY(0), motionEvent.getEventTime(), motionEvent.getPressure(0), motionEvent.getSize(0)));
            }
        }
        return false;
    }

    public void startCapture(int n2) {
        this._maxEvents = n2;
        this._shouldCapture = true;
    }

    public void endCapture() {
        this._shouldCapture = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCapture() {
        ArrayList arrayList = this._motionEvents;
        synchronized (arrayList) {
            this._motionEvents.clear();
            return;
        }
    }

    public int getMaxEventCount() {
        return this._maxEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentEventCount() {
        ArrayList arrayList = this._motionEvents;
        synchronized (arrayList) {
            return this._motionEvents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray getEvents(SparseArray sparseArray) {
        SparseIntArray sparseIntArray = new SparseIntArray();
        SparseArray sparseArray2 = new SparseArray();
        ArrayList arrayList = this._motionEvents;
        synchronized (arrayList) {
            for (AdUnitMotionEvent adUnitMotionEvent : this._motionEvents) {
                ArrayList arrayList2 = (ArrayList)sparseArray.get(adUnitMotionEvent.getAction());
                if (arrayList2 == null) continue;
                int n2 = (Integer)arrayList2.get(0);
                if (sparseIntArray.get(adUnitMotionEvent.getAction(), 0) == n2) {
                    if (sparseArray2.get(adUnitMotionEvent.getAction()) == null) {
                        sparseArray2.put(adUnitMotionEvent.getAction(), (Object)new SparseArray());
                    }
                    ((SparseArray)sparseArray2.get(adUnitMotionEvent.getAction())).put(n2, (Object)adUnitMotionEvent);
                    arrayList2.remove(0);
                }
                sparseIntArray.put(adUnitMotionEvent.getAction(), sparseIntArray.get(adUnitMotionEvent.getAction()) + 1);
            }
        }
        return sparseArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseIntArray getEventCount(ArrayList arrayList) {
        SparseIntArray sparseIntArray = new SparseIntArray();
        ArrayList arrayList2 = this._motionEvents;
        synchronized (arrayList2) {
            block3: for (AdUnitMotionEvent adUnitMotionEvent : this._motionEvents) {
                for (Integer n2 : arrayList) {
                    if (adUnitMotionEvent.getAction() != n2.intValue()) continue;
                    sparseIntArray.put(n2.intValue(), sparseIntArray.get(n2.intValue(), 0) + 1);
                    continue block3;
                }
            }
        }
        return sparseIntArray;
    }
}

