/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.adunit;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.unity3d.splash.services.ads.adunit.AdUnitEvent;
import com.unity3d.splash.services.ads.adunit.AdUnitRelativeLayout;
import com.unity3d.splash.services.ads.adunit.IAdUnitViewHandler;
import com.unity3d.splash.services.ads.adunit.PermissionsEvent;
import com.unity3d.splash.services.ads.api.AdUnit;
import com.unity3d.splash.services.ads.configuration.IAdsModuleConfiguration;
import com.unity3d.splash.services.core.api.Intent;
import com.unity3d.splash.services.core.configuration.Configuration;
import com.unity3d.splash.services.core.configuration.IModuleConfiguration;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.ViewUtilities;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;

public class AdUnitActivity
extends Activity {
    public static final String EXTRA_VIEWS = "views";
    public static final String EXTRA_ACTIVITY_ID = "activityId";
    public static final String EXTRA_ORIENTATION = "orientation";
    public static final String EXTRA_SYSTEM_UI_VISIBILITY = "systemUiVisibility";
    public static final String EXTRA_KEY_EVENT_LIST = "keyEvents";
    public static final String EXTRA_KEEP_SCREEN_ON = "keepScreenOn";
    public static final String EXTRA_DISPLAY_CUTOUT_MODE = "displayCutoutMode";
    protected AdUnitRelativeLayout _layout;
    private String[] _views;
    private int _orientation = -1;
    private int _systemUiVisibility;
    private int _activityId;
    private ArrayList _keyEventList;
    boolean _keepScreenOn;
    private Map _viewHandlers;
    private int _displayCutoutMode;

    protected void onCreate(Bundle bundle) {
        AdUnitEvent adUnitEvent;
        super.onCreate(bundle);
        if (WebViewApp.getCurrentApp() == null) {
            DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onCreate");
            this.finish();
            return;
        }
        AdUnit.setAdUnitActivity(this);
        Intent.setActiveActivity(this);
        this.createLayout();
        ViewUtilities.removeViewFromParent((View)this._layout);
        this.addContentView((View)this._layout, this._layout.getLayoutParams());
        if (bundle == null) {
            this._views = this.getIntent().getStringArrayExtra(EXTRA_VIEWS);
            this._keyEventList = this.getIntent().getIntegerArrayListExtra(EXTRA_KEY_EVENT_LIST);
            if (this.getIntent().hasExtra(EXTRA_ORIENTATION)) {
                this._orientation = this.getIntent().getIntExtra(EXTRA_ORIENTATION, -1);
            }
            if (this.getIntent().hasExtra(EXTRA_SYSTEM_UI_VISIBILITY)) {
                this._systemUiVisibility = this.getIntent().getIntExtra(EXTRA_SYSTEM_UI_VISIBILITY, 0);
            }
            if (this.getIntent().hasExtra(EXTRA_ACTIVITY_ID)) {
                this._activityId = this.getIntent().getIntExtra(EXTRA_ACTIVITY_ID, -1);
            }
            if (this.getIntent().hasExtra(EXTRA_DISPLAY_CUTOUT_MODE)) {
                this._displayCutoutMode = this.getIntent().getIntExtra(EXTRA_DISPLAY_CUTOUT_MODE, 0);
            }
            adUnitEvent = AdUnitEvent.ON_CREATE;
        } else {
            this._views = bundle.getStringArray(EXTRA_VIEWS);
            this._orientation = bundle.getInt(EXTRA_ORIENTATION, -1);
            this._systemUiVisibility = bundle.getInt(EXTRA_SYSTEM_UI_VISIBILITY, 0);
            this._keyEventList = bundle.getIntegerArrayList(EXTRA_KEY_EVENT_LIST);
            this._keepScreenOn = bundle.getBoolean(EXTRA_KEEP_SCREEN_ON);
            this._activityId = bundle.getInt(EXTRA_ACTIVITY_ID, -1);
            this._displayCutoutMode = bundle.getInt(EXTRA_DISPLAY_CUTOUT_MODE, 0);
            this.setKeepScreenOn(this._keepScreenOn);
            adUnitEvent = AdUnitEvent.ON_RESTORE;
        }
        this.setOrientation(this._orientation);
        this.setSystemUiVisibility(this._systemUiVisibility);
        this.setLayoutInDisplayCutoutMode(this._displayCutoutMode);
        if (this._views != null) {
            String[] stringArray = this._views;
            int n2 = this._views.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = stringArray[i2];
                if ((object = this.getViewHandler((String)object)) == null) continue;
                object.onCreate(this, bundle);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, adUnitEvent, this._activityId);
    }

    public AdUnitRelativeLayout getLayout() {
        return this._layout;
    }

    protected void onStart() {
        super.onStart();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onStart");
                this.finish();
            }
            return;
        }
        if (this._viewHandlers != null) {
            for (Map.Entry entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                ((IAdUnitViewHandler)entry.getValue()).onStart(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_START, this._activityId);
    }

    protected void onStop() {
        super.onStop();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onStop");
                this.finish();
            }
            return;
        }
        if (this._viewHandlers != null) {
            for (Map.Entry entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                ((IAdUnitViewHandler)entry.getValue()).onStop(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_STOP, this._activityId);
    }

    protected void onResume() {
        super.onResume();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onResume");
                this.finish();
            }
            return;
        }
        this.setViews(this._views);
        if (this._viewHandlers != null) {
            for (Map.Entry entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                ((IAdUnitViewHandler)entry.getValue()).onResume(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_RESUME, this._activityId);
    }

    protected void onPause() {
        super.onPause();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onPause");
                this.finish();
            }
            return;
        }
        if (WebViewApp.getCurrentApp().getWebView() == null) {
            DeviceLog.warning("Unity Ads web view is null, from onPause");
        } else if (this.isFinishing()) {
            ViewUtilities.removeViewFromParent((View)WebViewApp.getCurrentApp().getWebView());
        }
        if (this._viewHandlers != null) {
            for (Map.Entry entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                ((IAdUnitViewHandler)entry.getValue()).onPause(this);
            }
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_PAUSE, this.isFinishing(), this._activityId);
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(EXTRA_ORIENTATION, this._orientation);
        bundle.putInt(EXTRA_SYSTEM_UI_VISIBILITY, this._systemUiVisibility);
        bundle.putIntegerArrayList(EXTRA_KEY_EVENT_LIST, this._keyEventList);
        bundle.putBoolean(EXTRA_KEEP_SCREEN_ON, this._keepScreenOn);
        bundle.putStringArray(EXTRA_VIEWS, this._views);
        bundle.putInt(EXTRA_ACTIVITY_ID, this._activityId);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (WebViewApp.getCurrentApp() == null) {
            if (!this.isFinishing()) {
                DeviceLog.error("Unity Ads web app is null, closing Unity Ads activity from onDestroy");
                this.finish();
            }
            return;
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_DESTROY, this.isFinishing(), this._activityId);
        if (this._viewHandlers != null) {
            for (Map.Entry entry : this._viewHandlers.entrySet()) {
                if (entry.getValue() == null) continue;
                ((IAdUnitViewHandler)entry.getValue()).onDestroy(this);
            }
        }
        if (AdUnit.getCurrentAdUnitActivityId() == this._activityId) {
            AdUnit.setAdUnitActivity(null);
        }
        Intent.removeActiveActivity(this);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (this._keyEventList != null && this._keyEventList.contains(n2)) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.KEY_DOWN, n2, keyEvent.getEventTime(), keyEvent.getDownTime(), keyEvent.getRepeatCount(), this._activityId);
            return true;
        }
        return false;
    }

    public void onWindowFocusChanged(boolean bl) {
        if (bl) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_FOCUS_GAINED, this._activityId);
        } else {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.ADUNIT, AdUnitEvent.ON_FOCUS_LOST, this._activityId);
        }
        super.onWindowFocusChanged(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void onRequestPermissionsResult(int n2, String[] objectArray, int[] nArray) {
        try {
            void var3_5;
            JSONArray jSONArray = new JSONArray();
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n3 = objectArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = objectArray2[i2];
                jSONArray.put(object);
            }
            for (void var8_12 : var3_5) {
                jSONArray2.put((int)var8_12);
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.PERMISSIONS, PermissionsEvent.PERMISSIONS_RESULT, n2, jSONArray, jSONArray2);
            return;
        }
        catch (Exception exception) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.PERMISSIONS, PermissionsEvent.PERMISSIONS_ERROR, exception.getMessage());
            return;
        }
    }

    public void setViewFrame(String string, int n2, int n3, int n4, int n5) {
        IAdUnitViewHandler iAdUnitViewHandler = this.getViewHandler(string);
        View view = null;
        if (string.equals("adunit")) {
            string = new FrameLayout.LayoutParams(n4, n5);
            string.setMargins(n2, n3, 0, 0);
            this._layout.setLayoutParams((ViewGroup.LayoutParams)string);
        } else if (iAdUnitViewHandler != null) {
            view = iAdUnitViewHandler.getView();
        }
        if (view != null) {
            string = new RelativeLayout.LayoutParams(n4, n5);
            string.setMargins(n2, n3, 0, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)string);
        }
    }

    public Map getViewFrame(String string) {
        HashMap<String, Integer> hashMap = this.getViewHandler(string);
        View view = null;
        if (string.equals("adunit")) {
            string = (FrameLayout.LayoutParams)this._layout.getLayoutParams();
            hashMap = new HashMap<String, Integer>();
            hashMap.put("x", ((FrameLayout.LayoutParams)string).leftMargin);
            hashMap.put("y", ((FrameLayout.LayoutParams)string).topMargin);
            hashMap.put("width", this._layout.getWidth());
            hashMap.put("height", this._layout.getHeight());
            return hashMap;
        }
        if (hashMap != null) {
            view = hashMap.getView();
        }
        if (view != null) {
            string = (RelativeLayout.LayoutParams)view.getLayoutParams();
            hashMap = new HashMap<String, Integer>();
            hashMap.put("x", ((RelativeLayout.LayoutParams)string).leftMargin);
            hashMap.put("y", ((RelativeLayout.LayoutParams)string).topMargin);
            hashMap.put("width", view.getWidth());
            hashMap.put("height", view.getHeight());
            return hashMap;
        }
        return null;
    }

    public void setViews(String[] object) {
        if (object == null) {
            object = new String[]{};
        }
        String[] stringArray = new ArrayList<String>(Arrays.asList(object));
        if (this._views == null) {
            this._views = new String[0];
        }
        Object object2 = new ArrayList<String>(Arrays.asList(this._views));
        ((ArrayList)object2).removeAll((Collection<?>)stringArray);
        stringArray = ((ArrayList)object2).iterator();
        while (stringArray.hasNext()) {
            object2 = (String)stringArray.next();
            this.getViewHandler((String)object2).destroy();
        }
        this._views = object;
        stringArray = object;
        int n2 = ((String[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = stringArray[i2];
            if (object == null) continue;
            object = this.getViewHandler((String)object);
            object.create(this);
            if (this.handleViewPlacement(object.getView())) continue;
            return;
        }
    }

    private boolean handleViewPlacement(View view) {
        if (view == null) {
            this.finish();
            DeviceLog.error("Could not place view because it is null, finishing activity");
            return false;
        }
        if (view.getParent() != null && view.getParent().equals((Object)this._layout)) {
            this._layout.bringChildToFront(view);
        } else {
            ViewUtilities.removeViewFromParent(view);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            layoutParams.setMargins(0, 0, 0, 0);
            view.setPadding(0, 0, 0, 0);
            this._layout.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
        return true;
    }

    public String[] getViews() {
        return this._views;
    }

    public void setOrientation(int n2) {
        this._orientation = n2;
        this.setRequestedOrientation(n2);
    }

    public boolean setKeepScreenOn(boolean bl) {
        this._keepScreenOn = bl;
        if (this.getWindow() == null) {
            return false;
        }
        if (bl) {
            this.getWindow().addFlags(128);
        } else {
            this.getWindow().clearFlags(128);
        }
        return true;
    }

    public boolean setSystemUiVisibility(int n2) {
        this._systemUiVisibility = n2;
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                this.getWindow().getDecorView().setSystemUiVisibility(n2);
                return true;
            }
            catch (Exception exception) {
                DeviceLog.exception("Error while setting SystemUIVisibility", exception);
                return false;
            }
        }
        return false;
    }

    public void setKeyEventList(ArrayList arrayList) {
        this._keyEventList = arrayList;
    }

    public IAdUnitViewHandler getViewHandler(String string) {
        IAdUnitViewHandler iAdUnitViewHandler;
        if (this._viewHandlers != null && this._viewHandlers.containsKey(string)) {
            iAdUnitViewHandler = (IAdUnitViewHandler)this._viewHandlers.get(string);
        } else {
            iAdUnitViewHandler = this.createViewHandler(string);
            if (iAdUnitViewHandler != null) {
                if (this._viewHandlers == null) {
                    this._viewHandlers = new HashMap();
                }
                this._viewHandlers.put(string, iAdUnitViewHandler);
            }
        }
        return iAdUnitViewHandler;
    }

    public void setLayoutInDisplayCutoutMode(int n2) {
        this._displayCutoutMode = n2;
        if (Build.VERSION.SDK_INT >= 28 && this.getWindow() != null) {
            WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
            try {
                layoutParams.getClass().getField("layoutInDisplayCutoutMode").setInt(layoutParams, n2);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                DeviceLog.debug("Error setting layoutInDisplayCutoutMode", illegalAccessException);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                DeviceLog.debug("Error getting layoutInDisplayCutoutMode", noSuchFieldException);
            }
        }
    }

    protected void createLayout() {
        if (this._layout != null) {
            return;
        }
        this._layout = new AdUnitRelativeLayout((Context)this);
        this._layout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        ViewUtilities.setBackground((View)this._layout, (Drawable)new ColorDrawable(-16777216));
    }

    private IAdUnitViewHandler createViewHandler(String string) {
        if (WebViewApp.getCurrentApp() != null) {
            Object object = WebViewApp.getCurrentApp().getConfiguration();
            for (String string2 : ((Configuration)object).getModuleConfigurationList()) {
                Map map;
                IModuleConfiguration iModuleConfiguration = ((Configuration)object).getModuleConfiguration(string2);
                if (!(iModuleConfiguration instanceof IAdsModuleConfiguration) || (map = ((IAdsModuleConfiguration)iModuleConfiguration).getAdUnitViewHandlers()) == null || !map.containsKey(string)) continue;
                object = null;
                try {
                    object = (IAdUnitViewHandler)((Class)map.get(string)).newInstance();
                }
                catch (Exception exception) {
                    DeviceLog.error("Error creating view: " + string);
                }
                return object;
            }
        }
        return null;
    }
}

