/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads;

import android.app.Activity;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.unity3d.splash.IUnityAdsListener;
import com.unity3d.splash.UnityAds;
import com.unity3d.splash.services.IUnityServicesListener;
import com.unity3d.splash.services.UnityServices;
import com.unity3d.splash.services.ads.adunit.AdUnitOpen;
import com.unity3d.splash.services.ads.load.LoadModule;
import com.unity3d.splash.services.ads.placement.Placement;
import com.unity3d.splash.services.ads.properties.AdsProperties;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.properties.ClientProperties;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public final class UnityAdsImplementation {
    public static void initialize(Activity activity, String string, IUnityAdsListener iUnityAdsListener) {
        UnityAdsImplementation.initialize(activity, string, iUnityAdsListener, false);
    }

    public static void initialize(Activity activity, String string, IUnityAdsListener iUnityAdsListener, boolean bl) {
        UnityAdsImplementation.initialize(activity, string, iUnityAdsListener, bl, false);
    }

    public static void initialize(Activity activity, String string, final IUnityAdsListener iUnityAdsListener, boolean bl, boolean bl2) {
        DeviceLog.entered();
        UnityAdsImplementation.addListener(iUnityAdsListener);
        UnityServices.initialize(activity, string, new IUnityServicesListener(){

            @Override
            public final void onUnityServicesError(UnityServices.UnityServicesError unityServicesError, String string) {
                if (unityServicesError == UnityServices.UnityServicesError.INIT_SANITY_CHECK_FAIL) {
                    iUnityAdsListener.onUnityAdsError(UnityAds.UnityAdsError.INIT_SANITY_CHECK_FAIL, string);
                    return;
                }
                if (unityServicesError == UnityServices.UnityServicesError.INVALID_ARGUMENT) {
                    iUnityAdsListener.onUnityAdsError(UnityAds.UnityAdsError.INVALID_ARGUMENT, string);
                }
            }
        }, bl, bl2);
    }

    public static boolean isInitialized() {
        return UnityServices.isInitialized();
    }

    @Deprecated
    public static void setListener(IUnityAdsListener iUnityAdsListener) {
        AdsProperties.addListener(iUnityAdsListener);
    }

    public static void addListener(IUnityAdsListener iUnityAdsListener) {
        AdsProperties.addListener(iUnityAdsListener);
    }

    public static void removeListener(IUnityAdsListener iUnityAdsListener) {
        AdsProperties.removeListener(iUnityAdsListener);
    }

    @Deprecated
    public static IUnityAdsListener getListener() {
        Iterator iterator = AdsProperties.getListeners().iterator();
        if (iterator.hasNext()) {
            return (IUnityAdsListener)iterator.next();
        }
        return null;
    }

    public static boolean isSupported() {
        return UnityServices.isSupported();
    }

    public static String getVersion() {
        return UnityServices.getVersion();
    }

    public static boolean isReady() {
        return UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && Placement.isReady();
    }

    public static boolean isReady(String string) {
        return UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && string != null && Placement.isReady(string);
    }

    public static UnityAds.PlacementState getPlacementState() {
        if (UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized()) {
            return Placement.getPlacementState();
        }
        return UnityAds.PlacementState.NOT_AVAILABLE;
    }

    public static UnityAds.PlacementState getPlacementState(String string) {
        if (UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && string != null) {
            return Placement.getPlacementState(string);
        }
        return UnityAds.PlacementState.NOT_AVAILABLE;
    }

    public static void show(Activity activity) {
        if (Placement.getDefaultPlacement() != null) {
            UnityAdsImplementation.show(activity, Placement.getDefaultPlacement());
            return;
        }
        UnityAdsImplementation.handleShowError("", UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads default placement is not initialized");
    }

    public static void show(final Activity activity, final String string) {
        if (activity == null) {
            UnityAdsImplementation.handleShowError(string, UnityAds.UnityAdsError.INVALID_ARGUMENT, "Activity must not be null");
            return;
        }
        if (UnityAdsImplementation.isReady(string)) {
            DeviceLog.info("Unity Ads opening new ad unit for placement " + string);
            ClientProperties.setActivity(activity);
            new Thread(new Runnable(){

                @Override
                public final void run() {
                    Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("requestedOrientation", activity.getRequestedOrientation());
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("rotation", display.getRotation());
                        if (Build.VERSION.SDK_INT >= 13) {
                            Point point = new Point();
                            display.getSize(point);
                            jSONObject2.put("width", point.x);
                            jSONObject2.put("height", point.y);
                        } else {
                            jSONObject2.put("width", display.getWidth());
                            jSONObject2.put("height", display.getHeight());
                        }
                        jSONObject.put("display", (Object)jSONObject2);
                    }
                    catch (JSONException jSONException) {
                        DeviceLog.exception("JSON error while constructing show options", (Exception)((Object)jSONException));
                    }
                    try {
                        if (!AdUnitOpen.open(string, jSONObject)) {
                            UnityAdsImplementation.handleShowError(string, UnityAds.UnityAdsError.INTERNAL_ERROR, "Webapp timeout, shutting down Unity Ads");
                        }
                        return;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        DeviceLog.exception("Could not get callback method", noSuchMethodException);
                        UnityAdsImplementation.handleShowError(string, UnityAds.UnityAdsError.SHOW_ERROR, "Could not get com.unity3d.ads.properties.showCallback method");
                        return;
                    }
                }
            }).start();
            return;
        }
        if (!UnityAdsImplementation.isSupported()) {
            UnityAdsImplementation.handleShowError(string, UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads is not supported for this device");
            return;
        }
        if (!UnityAdsImplementation.isInitialized()) {
            UnityAdsImplementation.handleShowError(string, UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads is not initialized");
            return;
        }
        UnityAdsImplementation.handleShowError(string, UnityAds.UnityAdsError.SHOW_ERROR, "Placement \"" + string + "\" is not ready");
    }

    private static void handleShowError(final String string, final UnityAds.UnityAdsError unityAdsError, final String string2) {
        string2 = "Unity Ads show failed: " + string2;
        DeviceLog.error(string2);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                for (IUnityAdsListener iUnityAdsListener : AdsProperties.getListeners()) {
                    iUnityAdsListener.onUnityAdsError(unityAdsError, string2);
                    if (string != null) {
                        iUnityAdsListener.onUnityAdsFinish(string, UnityAds.FinishState.ERROR);
                        continue;
                    }
                    iUnityAdsListener.onUnityAdsFinish("", UnityAds.FinishState.ERROR);
                }
            }
        });
    }

    public static void setDebugMode(boolean bl) {
        UnityServices.setDebugMode(bl);
    }

    public static boolean getDebugMode() {
        return UnityServices.getDebugMode();
    }

    public static String getDefaultPlacement() {
        return Placement.getDefaultPlacement();
    }

    public static void load(String string) {
        LoadModule.getInstance().load(string);
    }
}

