/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash;

import android.app.Activity;
import com.unity3d.splash.IUnityAdsListener;
import com.unity3d.splash.mediation.IUnityAdsExtendedListener;
import com.unity3d.splash.services.ads.UnityAdsImplementation;

public final class UnityAds {
    public static final String LAUNCH_SCREEN_PLACEMENT = "unity-launch-screen";
    private static String defaultGameId = "3194466";
    private static IUnityAdsListener launchScreenAdsListener = null;
    private static boolean skipLaunchScreenAds = false;
    private static boolean shownOnce = false;

    public static void initialize(Activity activity, String string, IUnityAdsListener iUnityAdsListener) {
        UnityAdsImplementation.initialize(activity, string, iUnityAdsListener, false, false);
    }

    public static void showLaunchScreenAds(Activity activity) {
        UnityAds.showLaunchScreenAds(activity, defaultGameId, null);
    }

    public static void showLaunchScreenAds(Activity activity, IAdsFinishListener iAdsFinishListener) {
        UnityAds.showLaunchScreenAds(activity, defaultGameId, iAdsFinishListener);
    }

    public static void showLaunchScreenAds(Activity activity, String string, IAdsFinishListener iAdsFinishListener) {
        if (launchScreenAdsListener == null) {
            if (iAdsFinishListener == null) {
                iAdsFinishListener = new IAdsFinishListener(){

                    @Override
                    public final void onUnityAdsFinish(String string, FinishState finishState) {
                    }
                };
            }
            launchScreenAdsListener = new LaunchScreenAdsListener(activity, iAdsFinishListener);
        }
        if (!UnityAdsImplementation.isInitialized()) {
            UnityAdsImplementation.initialize(activity, string, launchScreenAdsListener);
            return;
        }
        if (UnityAdsImplementation.isReady(LAUNCH_SCREEN_PLACEMENT)) {
            UnityAdsImplementation.show(activity, LAUNCH_SCREEN_PLACEMENT);
        }
    }

    public static boolean isSkipLaunchScreenAds() {
        return skipLaunchScreenAds;
    }

    public static void setSkipLaunchScreenAds(boolean bl) {
        skipLaunchScreenAds = bl;
    }

    static class LaunchScreenAdsListener
    implements IUnityAdsExtendedListener {
        private Activity activity;
        private IAdsFinishListener adsFinishListener;

        public LaunchScreenAdsListener(Activity activity, IAdsFinishListener iAdsFinishListener) {
            this.activity = activity;
            this.adsFinishListener = iAdsFinishListener;
        }

        @Override
        public void onUnityAdsReady(String string) {
            if (UnityAds.LAUNCH_SCREEN_PLACEMENT.equalsIgnoreCase(string) && !skipLaunchScreenAds && !shownOnce) {
                UnityAdsImplementation.show(this.activity, string);
                shownOnce = true;
            }
        }

        @Override
        public void onUnityAdsStart(String string) {
        }

        @Override
        public void onUnityAdsFinish(String string, FinishState finishState) {
            this.adsFinishListener.onUnityAdsFinish(string, finishState);
        }

        @Override
        public void onUnityAdsError(UnityAdsError unityAdsError, String string) {
            this.adsFinishListener.onUnityAdsFinish(null, FinishState.ERROR);
        }

        @Override
        public void onUnityAdsClick(String string) {
        }

        @Override
        public void onUnityAdsPlacementStateChanged(String string, PlacementState placementState, PlacementState placementState2) {
        }
    }

    public static enum UnityAdsError {
        NOT_INITIALIZED,
        INITIALIZE_FAILED,
        INVALID_ARGUMENT,
        VIDEO_PLAYER_ERROR,
        INIT_SANITY_CHECK_FAIL,
        AD_BLOCKER_DETECTED,
        FILE_IO_ERROR,
        DEVICE_ID_ERROR,
        SHOW_ERROR,
        INTERNAL_ERROR;

    }

    public static enum PlacementState {
        READY,
        NOT_AVAILABLE,
        DISABLED,
        WAITING,
        NO_FILL;

    }

    public static enum FinishState {
        ERROR,
        SKIPPED,
        COMPLETED;

    }

    public static interface IAdsFinishListener {
        public void onUnityAdsFinish(String var1, FinishState var2);
    }
}

