/*
 * Decompiled with CFR 0.152.
 */
package com.excelliance.lbsdk.life;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import com.excelliance.lbsdk.LBSdkHelper;
import com.excelliance.lbsdk.base.BaseUtil;
import com.excelliance.lbsdk.base.f;
import com.excelliance.lbsdk.life.LifeCycleContentProvider;
import com.excelliance.lbsdk.life.b;
import com.excelliance.lbsdk.p.h;
import com.excelliance.lbsdk.q.c;
import java.io.File;

public class LifeCycleHelper {
    private static final String TAG = "LifeCycle";
    public static final String PROVIDER_NAME = "com.excelliance.lbsdk.life.LifeCycleContentProvider";
    private static String sAuthority;
    public static final int CREATE = 1;
    public static final int START = 2;
    public static final int RESUME = 3;
    public static final int PAUSE = 4;
    public static final int STOP = 5;
    public static final int DESTROY = 6;
    public static final String MODULE_FIRST = "first";
    public static final String MODULE_ITEM = "item";
    public static final String MODULE_LBMAIN = "lbmain";
    private Context mContext;
    private ContentResolver mResolver;
    private static Uri mContentUri;
    private static Uri mContentUriLBMain;
    private static LifeCycleHelper instance;
    private static boolean mInit;
    private static boolean mHasRegistered;

    public void checkDisableLifeCycle() {
        if (mInit) {
            File file = new File(this.mContext.getCacheDir().getParent(), "disable_life_cycle");
            mInit = !file.exists();
        }
    }

    private LifeCycleHelper(Context context) {
        this.mContext = context;
        boolean bl = mInit = f.a(context, "DONT_USE_ACTIVITY_TASK", false) && this.hasLifeCycleProvider(LBSdkHelper.getHostPackageInfo(context));
        if (mInit) {
            this.mResolver = context.getContentResolver();
            mContentUri = LifeCycleHelper.generateContentUri(context, MODULE_ITEM);
            mContentUriLBMain = LifeCycleHelper.generateContentUri(context, MODULE_LBMAIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LifeCycleHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<LifeCycleHelper> clazz = LifeCycleHelper.class;
        synchronized (LifeCycleHelper.class) {
            if (instance != null) return instance;
            instance = new LifeCycleHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void setActivityStatus(b b2) {
        if (mInit) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("hashcode", Integer.valueOf(b2.a));
            contentValues.put("pid", Integer.valueOf(b2.b));
            contentValues.put("name", b2.c);
            contentValues.put("status", Integer.valueOf(b2.d));
            this.mResolver.insert(mContentUri, contentValues);
        }
    }

    public static boolean isLBMainOnTop(Context context) {
        return LifeCycleHelper.isLBMainOnTop(context, false);
    }

    public static boolean isLBMainOnTop(Context context, boolean bl) {
        if (mInit) {
            Cursor cursor = context.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    n = cursor.getInt(0);
                    n2 = cursor.getInt(1);
                    n3 = cursor.getInt(2);
                }
                cursor.close();
            }
            a.a(TAG, "isLBMainOnTop: nc:" + n + " p:" + n2 + " a:" + n3);
            return n > 0 && n < (bl ? 5 : 4) || n2 > 0 && n2 < (bl ? 5 : 4) || n3 > 0 && n3 < (bl ? 5 : 4);
        }
        String string = BaseUtil.b(context);
        return string != null && (string.contains("com.excelliance.open.NextChapter") || string.contains("com.excelliance.open.NextChapterNew") || string.contains("com.excelliance.open.PromptActivity") || string.contains("com.excelliance.open.NewPromptActivity"));
    }

    public static boolean isNextChapterOnTop(Context context) {
        if (mInit) {
            Cursor cursor = context.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n = -1;
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    n = cursor.getInt(0);
                }
                cursor.close();
            }
            a.a(TAG, "isNextChapterOnTop: nc:" + n);
            return n > 0 && n < 4;
        }
        String string = BaseUtil.b(context);
        return string != null && (string.contains("com.excelliance.open.NextChapter") || string.contains("com.excelliance.open.NextChapterNew"));
    }

    public static boolean isPromptOnTop(Context context) {
        if (mInit) {
            Cursor cursor = context.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n = -1;
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    n = cursor.getInt(1);
                }
                cursor.close();
            }
            a.a(TAG, "isPromptOnTop: p:" + n);
            return n > 0 && n < 4;
        }
        String string = BaseUtil.b(context);
        return string != null && (string.contains("com.excelliance.open.PromptActivity") || string.contains("com.excelliance.open.NewPromptActivity"));
    }

    public static boolean isAssistOnTop(Context context) {
        if (mInit) {
            Cursor cursor = context.getContentResolver().query(mContentUriLBMain, null, null, null, null);
            int n = -1;
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    n = cursor.getInt(2);
                }
                cursor.close();
            }
            a.a(TAG, "isAssistOnTop: a:" + n);
            return n > 0 && n < 4;
        }
        String string = BaseUtil.b(context);
        return string != null && string.contains("com.excelliance.open.AssistActivity");
    }

    public static boolean isForeground(Context context) {
        if (mInit) {
            return !LifeCycleHelper.isFirstActivityCreate(context) || LifeCycleHelper.getForegroundTopActivity(context) != null;
        }
        return BaseUtil.j(context);
    }

    public static boolean isTopActivity(Context context) {
        if (mInit) {
            return LifeCycleHelper.getForegroundTopActivity(context) != null;
        }
        return BaseUtil.f(context);
    }

    public static boolean isFirstActivityCreate(Context context) {
        Cursor cursor = context.getContentResolver().query(LifeCycleHelper.generateContentUri(context, MODULE_FIRST), null, null, null, null);
        int n = 0;
        if (cursor != null) {
            while (cursor.moveToNext()) {
                n = cursor.getInt(0);
            }
            cursor.close();
        }
        return n == 1;
    }

    public static String getTopActivity(Context context) {
        if (mInit) {
            Cursor cursor = context.getContentResolver().query(LifeCycleHelper.generateContentUri(context, MODULE_ITEM), null, null, null, null);
            String string = null;
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    b b2 = new b();
                    b2.a = cursor.getInt(0);
                    b2.b = cursor.getInt(1);
                    b2.c = cursor.getString(2);
                    b2.d = cursor.getInt(3);
                    string = b2.c;
                }
                cursor.close();
            }
            return string;
        }
        return BaseUtil.b(context);
    }

    public static String getForegroundTopActivity(Context context) {
        Cursor cursor = context.getContentResolver().query(LifeCycleHelper.generateContentUri(context, MODULE_ITEM), null, null, null, null);
        String string = null;
        if (cursor != null) {
            while (cursor.moveToNext()) {
                b b2 = new b();
                b2.a = cursor.getInt(0);
                b2.b = cursor.getInt(1);
                b2.c = cursor.getString(2);
                b2.d = cursor.getInt(3);
                if (b2.d <= 4) {
                    string = b2.c;
                }
                a.a(TAG, "getForegroundTopActivity: " + string + " status:" + b2.d);
            }
            cursor.close();
        }
        return string;
    }

    public static void clearActivityStack(Context context, int n) {
        if (mInit) {
            context.getContentResolver().delete(LifeCycleHelper.generateContentUri(context, MODULE_ITEM), "", new String[]{String.valueOf(n)});
        }
    }

    private static synchronized String getAuthority(Context context) {
        if (sAuthority != null) {
            return sAuthority;
        }
        try {
            ComponentName componentName = new ComponentName(context.getPackageName(), LifeCycleContentProvider.class.getName());
            ProviderInfo providerInfo = context.getPackageManager().getProviderInfo(componentName, 65536);
            sAuthority = providerInfo.authority;
            return sAuthority;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new h("LifeCycleProvider should be defined in your AndroidManifest.xml");
        }
    }

    private static Uri generateContentUri(Context context, String string) {
        try {
            String string2 = LifeCycleHelper.getAuthority(context);
            Uri uri = Uri.parse((String)("content://" + string2));
            Uri uri2 = Uri.withAppendedPath((Uri)uri, (String)string);
            return uri2;
        }
        catch (Exception exception) {
            a.a(TAG, "no provider");
            mInit = false;
            return null;
        }
    }

    @TargetApi(value=14)
    public void registerLifeCycle(Application application) {
        if (!mInit) {
            return;
        }
        if (mHasRegistered) {
            a.a(TAG, "has Registered");
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                String string = activity.getComponentName().getClassName();
                int n = Process.myPid();
                int n2 = activity.hashCode();
                b b2 = new b(n2, n, string, 1);
                LifeCycleHelper.this.setActivityStatus(b2);
                a.a(LifeCycleHelper.TAG, "onActivityCreated: " + b2);
            }

            public void onActivityStarted(Activity activity) {
                String string = activity.getComponentName().getClassName();
                int n = Process.myPid();
                int n2 = activity.hashCode();
                b b2 = new b(n2, n, string, 2);
                LifeCycleHelper.this.setActivityStatus(b2);
                a.a(LifeCycleHelper.TAG, "onActivityStarted: " + b2);
            }

            public void onActivityResumed(Activity activity) {
                String string = activity.getComponentName().getClassName();
                int n = Process.myPid();
                int n2 = activity.hashCode();
                b b2 = new b(n2, n, string, 3);
                LifeCycleHelper.this.setActivityStatus(b2);
                a.a(LifeCycleHelper.TAG, "onActivityResumed: " + b2);
            }

            public void onActivityPaused(Activity activity) {
                String string = activity.getComponentName().getClassName();
                int n = Process.myPid();
                int n2 = activity.hashCode();
                b b2 = new b(n2, n, string, 4);
                LifeCycleHelper.this.setActivityStatus(b2);
                a.a(LifeCycleHelper.TAG, "onActivityPaused: " + b2);
            }

            public void onActivityStopped(Activity activity) {
                String string = activity.getComponentName().getClassName();
                int n = Process.myPid();
                int n2 = activity.hashCode();
                b b2 = new b(n2, n, string, 5);
                LifeCycleHelper.this.setActivityStatus(b2);
                a.a(LifeCycleHelper.TAG, "onActivityStopped: " + b2);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
                String string = activity.getComponentName().getClassName();
                int n = Process.myPid();
                int n2 = activity.hashCode();
                b b2 = new b(n2, n, string, 6);
                LifeCycleHelper.this.setActivityStatus(b2);
                a.a(LifeCycleHelper.TAG, "onActivityDestroyed: " + b2);
            }
        });
        mHasRegistered = true;
    }

    private boolean hasLifeCycleProvider(PackageInfo packageInfo) {
        if (packageInfo == null || packageInfo.providers == null || packageInfo.providers.length == 0) {
            return false;
        }
        for (ProviderInfo providerInfo : packageInfo.providers) {
            if (!PROVIDER_NAME.equals(providerInfo.name)) continue;
            a.a(TAG, "has LifeCycleProvider");
            return true;
        }
        return false;
    }

    static {
        mInit = false;
        mHasRegistered = false;
    }

    public static class a {
        public static void a(String string, String string2) {
            c.c(string, string2, new Object[0]);
        }
    }
}

