# About Unity UI

Use the Unity UI package to create in-game user interfaces fast and intuitively. For example taking a couple components such as a panel, and buttons you can create a basic main menu for your application.

# Installing Unity UI

A base version of Unity UI is included by default for each Unity release.

To install this package, follow the instructions in the [Package Manager documentation](https://docs.unity3d.com/Packages/com.unity.package-manager-ui@latest/index.html).

# Using Unity UI

The Unity UI user manual can be found [here](https://docs.unity3d.com/2018.1/Documentation/Manual/UISystem.html). It will cover a basic overview of all the available components as well as a few How Tos.

#### **Support & API Documentation**
Should you have questions or require assistance, please visit the [Unity UI](https://forum.unity.com/forums/unity-ui-textmesh-pro.60/) section of the Unity forum. In the event you are unable to find the information you seek, always feel free to post on the [Unity UI](https://forum.unity.com/forums/unity-ui-textmesh-pro.60/) section user forum.

Class descriptions and API compatibility can be found in the [UnityEngine.UI](https://docs.unity3d.com/ScriptReference/) section of the script reference page.

# Technical details
## Requirements

This version of Unity UI is compatible with the following versions of the Unity Editor:

* 2019.2 and later (recommended)

## Package contents

|Location|Description|
|---|---|
|`<Editor>`| Root folder containing the source for the Unity UI Editor scripts. These provide custom inspectors and layouts for the components|
|`<Runtime>`| Root folder containing the source for the Unity UI Runtime. These are the runtime files and basic components available for use.|
