
// qqgame_wsclientDlg.cpp : implementation file
//

#include "stdafx.h"
#include "qqgame_wsclient.h"
#include "qqgame_wsclientDlg.h"
#include "afxdialogex.h"

#include "websocket/game_websocket_client.h"
#include "common/format.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

Cqqgame_wsclientDlg::Cqqgame_wsclientDlg(CWnd* pParent, std::wstring id, std::wstring key, std::wstring pfkey, std::wstring port)
	: CDialogEx(Cqqgame_wsclientDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hall_id = id;
	m_hall_key = key;
	m_hall_pfkey = pfkey;
	m_hall_port = port;
}

void Cqqgame_wsclientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(Cqqgame_wsclientDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &Cqqgame_wsclientDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &Cqqgame_wsclientDlg::OnBnClickedButton2)
	ON_LBN_SELCHANGE(IDC_LIST1, &Cqqgame_wsclientDlg::OnLbnSelchangeList1)
	ON_EN_CHANGE(IDC_EDIT4, &Cqqgame_wsclientDlg::OnEnChangeEdit4)
	ON_BN_CLICKED(IDC_BUTTON4, &Cqqgame_wsclientDlg::OnBnClickedButton4)
	ON_EN_CHANGE(IDC_EDIT3, &Cqqgame_wsclientDlg::OnEnChangeEdit3)
	ON_BN_CLICKED(IDC_BUTTON3, &Cqqgame_wsclientDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON6, &Cqqgame_wsclientDlg::OnBnClickedButton6)
END_MESSAGE_MAP()


// Cqqgame_wsclientDlg message handlers

BOOL Cqqgame_wsclientDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	connect_ws();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void Cqqgame_wsclientDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR Cqqgame_wsclientDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void Cqqgame_wsclientDlg::OnBnClickedButton1()
{
	CString str;
	GetDlgItem(IDC_EDIT1)->GetWindowText(str);

	std::string data = fmt::format(R"("cmd":"buy_vip", "param":"{}")", str.GetString());
	data = "{" + data + "}";

	if (m_game_ws)
	{
		m_game_ws->send_data(data);
	}

}

void Cqqgame_wsclientDlg::OnBnClickedButton2()
{
	// TODO: Add your control notification handler code here

	CString str;
	GetDlgItem(IDC_EDIT2)->GetWindowText(str);

	std::string param_str = CT2A(str.GetBuffer());
	std::string data = fmt::format(R"("cmd":"buy_vip", "param":"{}")", param_str);
	data = "{" + data + "}";

	if (m_game_ws)
	{
		m_game_ws->send_data(data);
	}

}


void Cqqgame_wsclientDlg::OnLbnSelchangeList1()
{
	// TODO: Add your control notification handler code here
}


void Cqqgame_wsclientDlg::OnEnChangeEdit4()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialogEx::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
}


void Cqqgame_wsclientDlg::connect_ws()
{
	m_game_ws.reset(new game_websocket_client());
	if (m_game_ws)
	{

		m_game_ws->start_websocket(m_hall_id, m_hall_port,
			std::bind(&Cqqgame_wsclientDlg::on_ws_connect, this, std::placeholders::_1),
			std::bind(&Cqqgame_wsclientDlg::on_ws_recieve, this, std::placeholders::_1),
			std::bind(&Cqqgame_wsclientDlg::on_ws_broken, this));
	}
}

//ӳɹʧ
void Cqqgame_wsclientDlg::on_ws_connect(bool succ)
{
}

//յϢϷɸյϢ
void Cqqgame_wsclientDlg::on_ws_recieve(const std::string& data)
{

}

//ӶϿ
void Cqqgame_wsclientDlg::on_ws_broken()
{
}


void Cqqgame_wsclientDlg::OnEnChangeEdit3()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialogEx::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
}


void Cqqgame_wsclientDlg::OnBnClickedButton3()
{
	CString str;
	GetDlgItem(IDC_EDIT3)->GetWindowText(str);

	std::string cmd = CT2A(str.GetBuffer());

	if (m_game_ws)
	{
		m_game_ws->send_data(cmd);
	}

}

void Cqqgame_wsclientDlg::OnBnClickedButton4()
{
	if (m_game_ws->is_connected())
	{
		return;
	}
	else
	{
		m_game_ws->start_websocket(m_hall_id, m_hall_port,
			std::bind(&Cqqgame_wsclientDlg::on_ws_connect, this, std::placeholders::_1),
			std::bind(&Cqqgame_wsclientDlg::on_ws_recieve, this, std::placeholders::_1),
			std::bind(&Cqqgame_wsclientDlg::on_ws_broken, this));
	}

}



void Cqqgame_wsclientDlg::OnBnClickedButton6()
{
	// TODO: Add your control notification handler code here
	STARTUPINFOW siStartupInfo = { 0 };
	PROCESS_INFORMATION stProcessInformation = { 0 };

	CString str;
	GetDlgItem(IDC_EDIT3)->GetWindowText(str);

	std::wstring exe_path(L"");

	if (str.IsEmpty())
	{
		exe_path = L"qqgame_wsclient.exe";
	}
	else
	{
		exe_path = str;
	}

	std::wstring cmdline(exe_path);
	cmdline.append(L" ");
	cmdline.append(GetCommandLine());

	CreateProcess(NULL, (LPWSTR)cmdline.c_str(), NULL, NULL, FALSE
		, CREATE_NEW_CONSOLE, NULL, NULL, &siStartupInfo, &stProcessInformation);

}
