package com.youweiwlgm.distribute;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.youweiwlgm.baselibrary.YWWLApi;
import com.youweiwlgm.baselibrary.constant.SDKContants;
import com.youweiwlgm.baselibrary.entity.GamePropsInfo;
import com.youweiwlgm.baselibrary.entity.RealNameInfo;
import com.youweiwlgm.baselibrary.entity.RolesInfo;
import com.youweiwlgm.baselibrary.entity.SdkInitResult;
import com.youweiwlgm.baselibrary.entity.SdkLoginResult;
import com.youweiwlgm.baselibrary.entity.SdkPayResult;
import com.youweiwlgm.baselibrary.event.ISdkExitListener;
import com.youweiwlgm.baselibrary.event.ISdkInitListener;
import com.youweiwlgm.baselibrary.event.ISdkLoginListener;
import com.youweiwlgm.baselibrary.event.ISdkLogoutListener;
import com.youweiwlgm.baselibrary.event.ISdkPayListener;
import com.youweiwlgm.baselibrary.event.ISdkPrivacyAgreementListener;
import com.youweiwlgm.baselibrary.event.ISdkRealNameListener;
import com.youweiwlgm.baselibrary.event.ISdkRoleListener;

public class MainActivity extends Activity implements View.OnClickListener {

    private final static String TAG = "MainActivity";
    TextView tvTips;
    Button btnlogin;
    Button btnSubmitRole;
    Button btnLogout;
    Button btnBuyProp;
    Button btnExit;
    EditText edtPrice, edtId;
    Button btnCollectionDiaitalCenter;
    LinearLayout layoutPay;
    private int price = 10; //测试道具价格(单位:分)
    private String propsId = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_main);
        tvTips = findViewById(R.id.tv_tips);
        btnCollectionDiaitalCenter = findViewById(R.id.gm_convvertible_diaital_center_btn);
        btnlogin = findViewById(R.id.loginBtn);
        btnlogin.setOnClickListener(this);
        btnlogin.setVisibility(View.GONE);
        btnCollectionDiaitalCenter.setOnClickListener(this);
        btnSubmitRole = findViewById(R.id.btnSubmitRole);
        btnSubmitRole.setOnClickListener(this);
        btnSubmitRole.setVisibility(View.GONE);

        btnLogout = findViewById(R.id.logoutBtn);
        btnLogout.setOnClickListener(this);
        btnLogout.setVisibility(View.GONE);

        btnBuyProp = findViewById(R.id.btnBuyProp);
        btnBuyProp.setOnClickListener(this);

        layoutPay = findViewById(R.id.layoutPay);
        layoutPay.setVisibility(View.GONE);

        edtId = findViewById(R.id.edtId);
        edtPrice = findViewById(R.id.edtPrice);
        btnExit = findViewById(R.id.exitBtn);
        btnExit.setOnClickListener(this);
        findViewById(R.id.gm_convvertible_diaital_collections_list_btn).setOnClickListener(this);
        findViewById(R.id.gm_extractable_diaital_collections_list_btn).setOnClickListener(this);
        Log.i(TAG, "ywwl version:" + YWWLApi.getInstance().sdkVerision());

        initListener();
        //todo 授权
        YWWLApi.getInstance().privacyAuthorization(this);
    }

    /**
     * 初始化各功能回调监听
     */
    private void initListener() {

        //todo 初始化结果监听
        YWWLApi.getInstance().setSdkInitListener(new ISdkInitListener() {
            @Override
            public void initResult(SdkInitResult initResult) {
                if (null == initResult) {
                    return;
                }
                if (initResult.getErrorCode() == SDKContants.RESULT_SUCCESS) {
                    btnlogin.setVisibility(View.VISIBLE);
                    Toast.makeText(MainActivity.this, initResult.getErrorMesage(), Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "初始化失败：" + initResult.getErrorMesage(), Toast.LENGTH_SHORT).show();
                }
            }
        });


        //todo 用户登录结果监听
        YWWLApi.getInstance().setSdkLoginListener(new ISdkLoginListener() {
            @Override
            public void loginResult(SdkLoginResult loginResult) {
                if (null == loginResult) {
                    return;
                }
                if (loginResult.getErrorCode() == SDKContants.RESULT_SUCCESS) {
                    String userId = loginResult.getUserId();  //user_id（例："abc_123",用户唯一标识，不会重复，区分大小写）
                    String token = loginResult.getToken();    //user_token
                    Boolean userCertification = loginResult.isUserCertification(); //用户实名状态，true：已实名认证  false:未实名认证
                    String userBirthday = loginResult.getUserBirthday();           //用户生日信息（例:"19950712"）
                    /**这时游戏服务器需要拿userId和token访问sdk服务器，进行登录验证。详见《分发sdk服务端接口文档》*/
                    Toast.makeText(MainActivity.this, "登录成功：" + "userId:" + userId + ", token:" + token, Toast.LENGTH_SHORT).show();
                    if (userCertification) {
                        Log.w(TAG, "该用户已经实名认证，生日为：" + userBirthday);
                    }
                    layoutPay.setVisibility(View.VISIBLE);
                    btnSubmitRole.setVisibility(View.VISIBLE);
                    btnLogout.setVisibility(View.VISIBLE);
                    tvTips.setText("登录成功：user_id = " + userId);
                } else {
                    Toast.makeText(MainActivity.this, "登录失败：" + loginResult.getErrorMesage(), Toast.LENGTH_SHORT).show();
                }
            }
        });


        //todo 支付结果监听
        YWWLApi.getInstance().setSdkPayListener(new ISdkPayListener() {
            @Override
            public void payResult(SdkPayResult payResult) {
                Log.w(TAG, "支付结果");
                if (null == payResult) {
                    return;
                }
                /**支付结果应以sdk服务端通知为准，服务端通知规则详见《分发sdk服务端接口文档》*/
                if (payResult.getErrorCode() == SDKContants.RESULT_SUCCESS) {
                    Toast.makeText(MainActivity.this, "支付成功", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "支付失败：" + payResult.getErrorMesage(), Toast.LENGTH_SHORT).show();
                }
            }
        });


        //todo 上传角色结果监听
        YWWLApi.getInstance().setSdkRoleListener(new ISdkRoleListener() {
            @Override
            public void submitResult(int result) {

                Log.i(TAG, Log.getStackTraceString(new Throwable()));
                if (result == SDKContants.RESULT_SUCCESS) {
                    Toast.makeText(MainActivity.this, "上传角色信息成功", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "上传角色信息失败", Toast.LENGTH_SHORT).show();
                }
            }
        });


        //todo 注销登录结果监听
        YWWLApi.getInstance().setSdkLogoutListener(new ISdkLogoutListener() {
            @Override
            public void logoutResult(int logoutResult) {
                if (logoutResult == SDKContants.RESULT_SUCCESS) {
                    btnSubmitRole.setVisibility(View.GONE);
                    btnLogout.setVisibility(View.GONE);
                    layoutPay.setVisibility(View.GONE);
                    tvTips.setText("用户未登录");
                    Toast.makeText(MainActivity.this, "注销登录成功", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "注销登录失败", Toast.LENGTH_SHORT).show();
                }

            }
        });
        YWWLApi.getInstance().setRealnameListener(new ISdkRealNameListener() {
            @Override
            public void submitResult(RealNameInfo realNameInfo) {

            }
        });
        //设置实名认证结果回调
        YWWLApi.getInstance().setRealnameListener(new ISdkRealNameListener() {
            @Override
            public void submitResult(RealNameInfo realNameInfo) {
                //0已成年 1未成年 2等待中
                int status = realNameInfo.stauts;
                //生日
                String birthday = realNameInfo.birthday;
                //身份证
                String idCard = realNameInfo.idcard;
                //姓名
                String realName = realNameInfo.realname;
            }
        });
        //todo 退出游戏程序结果监听
        YWWLApi.getInstance().setSdkExitListener(new ISdkExitListener() {
            @Override
            public void exitResult(int SdkExitresult) {
                if (SdkExitresult == SDKContants.RESULT_SUCCESS) {
                    Log.w(TAG, "玩家执行了退出程序操作");
                    //这里设置游戏自己的关闭进程、退出程序等操作
                    Process.killProcess(Process.myPid());
                }
            }
        });
        //隐私协议授权 回调
        YWWLApi.getInstance().setSdkPrivacyAgreementListener(new ISdkPrivacyAgreementListener() {
            @Override
            public void privacyAgreementResult(int result) {
                if (result == SDKContants.RESULT_SUCCESS) {
                    Log.w(TAG, "已经授权隐私协议，可以进行权限和初始化!");
                    YWWLApi.getInstance().init(MainActivity.this, true);
                } else {
                    Process.killProcess(Process.myPid());
                }
            }
        });

    }

    private void queryRealName() {
        YWWLApi.getInstance().queryRealname(MainActivity.this);
    }


    /**
     * 下面是sdk主要的几个方法（必接）
     * sdk初始化
     * sdk登录
     * sdk发起支付
     * sdk上传游戏角色信息
     * sdk注销登录
     */
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.loginBtn:
                //todo 发起sdk登录
                YWWLApi.getInstance().login(MainActivity.this);
                break;
            case R.id.gm_convvertible_diaital_center_btn:
                YWWLApi.getInstance().showGmCenter(MainActivity.this);
                break;
            case R.id.btnBuyProp:
                if (!TextUtils.isEmpty(edtPrice.getText().toString())) {
                    price = Integer.valueOf(edtPrice.getText().toString());
                }
                if (!TextUtils.isEmpty(edtId.getText().toString())) {
                    propsId = edtId.getText().toString();
                }
                //todo 设置道具信息，发起sdk支付  所有参数必填，游戏没有的字段传一个默认值或空字符
                GamePropsInfo gamePropsInfo = new GamePropsInfo();
                gamePropsInfo.setPropsId(propsId);//渠道道具id
                gamePropsInfo.setPropsName("测试道具");//道具名称
                gamePropsInfo.setPropsDesc("这是道具描述");//道具描述
                gamePropsInfo.setPropsPrice(price);//道具价格（单位：分）
                gamePropsInfo.setPropsNumber(1);//购买数量
                gamePropsInfo.setRoleId("1");//游戏角色id
                gamePropsInfo.setRoleName("测试角色");//游戏角色名
                gamePropsInfo.setRoleLevel("1");//游戏角色等级
                gamePropsInfo.setServerId("1");//游戏区服id
                gamePropsInfo.setServerName("测试1区");//游戏区服名
                gamePropsInfo.setGameOrderId(System.currentTimeMillis() + "");//游戏订单号（每次支付订单号不可重复）
                gamePropsInfo.setExtend("测试透传数据");//游戏透传信息
                gamePropsInfo.setCount(1);//玩家获取的游戏币/道具数量
                gamePropsInfo.setRoleVipLevel("1");//玩家VIP等级
                gamePropsInfo.setPartyName("荣耀圣殿");//工会 帮会名称
                gamePropsInfo.setRoleBalance("5000");//玩家战力
                YWWLApi.getInstance().pay(MainActivity.this, gamePropsInfo);
                break;

            case R.id.btnSubmitRole:
                //todo 设置游戏角色信息，上传游戏角色  所有参数必填，游戏没有的字段传一个默认值或空字符
                RolesInfo rolesInfo = new RolesInfo();
                rolesInfo.setRoleId("1");//角色Id
                rolesInfo.setRoleName("测试角色");//角色名
                rolesInfo.setLeval("1");//角色等级
                rolesInfo.setBalance("1");//角色余额
                rolesInfo.setRoleCombat("9999");//角色战力值
                rolesInfo.setVipLevel("1");//角色vip等级
                rolesInfo.setZoneId("1");//区服Id
                rolesInfo.setZoneName("测试1区");//区服名
                rolesInfo.setGuildName("测试公会");//工会/帮会名
                rolesInfo.setSubmitType("1");//上传场景类型：1:创建角色 2:角色登录 3:角色升级 4:角色退出 0:其他场景
                rolesInfo.setRoleGender("男");//角色性别
                rolesInfo.setPartyId("123");//工会/帮会id
                rolesInfo.setPartyRoleName("帮主");//角色在帮派中的名称
                rolesInfo.setPartyRoleId("1");//角色在帮派中的id
                rolesInfo.setProfessionId("1");//职业id
                rolesInfo.setProfession("法师");//职业
                rolesInfo.setFriendList("[]");//设置好友关系列表
                rolesInfo.setRoleCreateTime("1101201511");//角色创建时间 值为10位数时间戳
                YWWLApi.getInstance().submitRoleInfo(MainActivity.this, rolesInfo);
                break;

            case R.id.logoutBtn:
                //todo 注销登录
                YWWLApi.getInstance().logout(MainActivity.this);
                break;

            case R.id.exitBtn:
                //todo 退出程序
                YWWLApi.getInstance().exit(MainActivity.this);
                break;
            case R.id.gm_convvertible_diaital_collections_list_btn:
                //显示藏品兑换列表
                YWWLApi.getInstance().showDigitalCollectionBag(MainActivity.this);
                break;
            case R.id.gm_extractable_diaital_collections_list_btn:
                //显示道具提取列表
                YWWLApi.getInstance().showGamePropsBag(MainActivity.this);
                break;
        }
    }


    /**
     * 下面是游戏页面生命周期相关方法
     */
    @Override
    protected void onResume() {
        super.onResume();
        YWWLApi.getInstance().onResume(this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        YWWLApi.getInstance().onPause(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        YWWLApi.getInstance().onStop(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        YWWLApi.getInstance().onDestroy(this);
    }

    @Override
    protected void onStart() {
        super.onStart();
        YWWLApi.getInstance().onStart(this);
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        YWWLApi.getInstance().onRestart(this);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        YWWLApi.getInstance().handleIntent(this, intent);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        YWWLApi.getInstance().onActivityResult(this, requestCode, resultCode, data);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        YWWLApi.getInstance().onBackPressed(this);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        YWWLApi.getInstance().onConfigurationChanged(this, newConfig);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        YWWLApi.getInstance().onRequestPermissionsResult(this, requestCode, permissions, grantResults);
    }


    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) { //点击了返回按键
            YWWLApi.getInstance().exit(MainActivity.this);
        }
        return false;
    }

}
