package com.youweiwlgm.distribute;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;

import com.youweiwlgm.baselibrary.YWWLApi;


public class BaseApplication extends Application {
    @Override
    public void onCreate() {
        super.onCreate();
        YWWLApi.getInstance().initApplication(this);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
       YWWLApi.getInstance().attachBaseContext(this, base);
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        YWWLApi.getInstance().onTerminate(this);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        YWWLApi.getInstance().onConfigurationChanged(this, newConfig);
    }
}
