//
//  YYLXMchInterfaceManager.h
//  YYLXMchInterface
//
//  Created by xiaoLv on 2022/11/4.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
@class YYLXMchPayInfo,YYLXMchPlayerInfo;

@protocol YYLXMchInterfaceDelegate <NSObject>
@optional
- (void)mchInitResult:(BOOL)success;
- (void)mchLoginSuccessWithResultData:(NSDictionary *)loginDataDic;
- (void)mchLoginFail;
- (void)mchDidLogout:(BOOL)success;
- (void)mchCreateOrderResult:(BOOL)success;
- (void)mchPayResult:(BOOL)success;
- (void)mchUploadplayerInfo:(BOOL)success;
@end


@interface YYLXMchInterfaceManager : NSObject
@property (nonatomic,weak) id <YYLXMchInterfaceDelegate>delegate;

+ (YYLXMchInterfaceManager *)shareInstance;
/**
 *  初始化
 */
- (void)doInit:(id<YYLXMchInterfaceDelegate>)target application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions;
/**
 *  登录
 */
- (void)doLogin;
/**
 *  注销
 */
- (void)doLogout;
/**
 *  sdk支付
 */
- (void)doPay:(YYLXMchPayInfo *)sdkPayInfo;
- (void)doApplePay:(YYLXMchPayInfo *)sdkPayInfo;

/**
 *  上传角色信息
 */
- (void)doUpdatePlayerInfo:(YYLXMchPlayerInfo *)playerInfo;

/**
 *   显示Gm主界面View
 */
- (void)doShowGmMainView;
/**
 *   显示GM藏品兑换View
 */
- (void)doShowGmExchangeItemsView;

/**
 *   显示GM提取藏品View
 */
- (void)doShowGmExtractCollectionView;

//在应用对应的生命周期回调中调用
- (int)application:(UIApplication *)application handleOpenURL:(NSURL *)url;
- (int)application:(UIApplication *)application openURL:(NSURL *)url options:(NSDictionary<NSString*, id> *)options;
- (int)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation;

/**  推送消息
 @brief application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData*)deviceToken
        application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError*)error
 @result 错误码
 */
- (int)application:(UIApplication*)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData*)deviceToken;
- (int)application:(UIApplication*)application didFailToRegisterForRemoteNotificationsWithError:(NSError*)error;

- (int)applicationWillResignActive:(UIApplication *)application;
- (int)applicationDidEnterBackground:(UIApplication *)application;
- (int)applicationWillEnterForeground:(UIApplication *)application;
- (int)applicationDidBecomeActive:(UIApplication *)application;
- (int)applicationWillTerminate:(UIApplication *)application;
- (NSUInteger)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window;

/**
 @brief application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray * restorableObjects))restorationHandler
 @result 处理app url跳转
 */
- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray *  restorableObjects))restorationHandler;

@end


