//
//  YYLXCommonMgr.h
//  YYLXTransferSDK
//
//  Created by xiaoLv on 2022/11/2.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
NS_ASSUME_NONNULL_BEGIN

typedef void(^GMSDKNormalBlock)(void);

typedef void(^GMSDKNormalParBlock)(NSString *str);

typedef void(^GMSDKNormalIndexBlock)(NSInteger index);

typedef void(^GMSDKNormalIdBlock)(id model);

typedef void(^GMSDKNormalArrayBlock)(NSArray *array);

typedef void(^GMSDKNormalIdAndIndexBlock)(id model,NSInteger index);

typedef void(^GMSDKNormalIsOpenBlock)(id model,BOOL isOpen);

typedef void(^GMSDKNormalTwoIdBlock)(id model,id model2);

@interface YYLXCommonMgr : NSObject

/**
 *  @brief 返回一个单例对象
 *
 *  @return YYLXCommonMgr对象
 */
+ (id _Nonnull)sharedInstance;
/**
 * 初始化sdk
 */
- (void)initChannelSdk;
/**
 *  登录
 */
- (void)doLogin;
/**
 *  上传角色信息
 */
- (void)doUpdatePlayerInfo:(id)playerInfo;
/**
 *  注销
 */
- (void)doLogout;
/**
 *  sdk支付
 */
- (void)doPay:(id)sdkPayInfo;
- (void)doApplePay:(id)sdkPayInfo;
// GMSDKFENFA
- (void)doShowGmMainView:(GMSDKNormalBlock)showBlock;
/**
 *  @brief 返回版本号
 *
 *  @return 版本号字符串
 */
- (NSString *)getSDKVersons;

/**
 *  溪谷sdk调用的方法
 */
- (int)application:(UIApplication *)application handleOpenURL:(NSURL *)url;
- (int)application:(UIApplication *)application openURL:(NSURL *)url options:(NSDictionary<NSString*, id> *)options;
- (int)application:(UIApplication *)application openURL:(NSURL *)url
 sourceApplication:(NSString *)sourceApplication
        annotation:(id)annotation;

/**  推送消息
 @brief application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData*)deviceToken
 application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError*)error
 @result 错误码
 */
- (int)application:(UIApplication*)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData*)deviceToken;
- (int)application:(UIApplication*)application didFailToRegisterForRemoteNotificationsWithError:(NSError*)error;

- (int)applicationWillResignActive:(UIApplication *)application;
- (int)applicationDidEnterBackground:(UIApplication *)application;
- (int)applicationWillEnterForeground:(UIApplication *)application;
- (int)applicationDidBecomeActive:(UIApplication *)application;
- (int)applicationWillTerminate:(UIApplication *)application;
- (NSUInteger)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window;

/**
 @brief application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray * restorableObjects))restorationHandler
 @result 处理app url跳转
 */
- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray *  restorableObjects))restorationHandler;

@end

NS_ASSUME_NONNULL_END
