//
//  ViewController.m
//  YZYZ13DemoApp
//
//  Created by xiaoLv on 2022/11/10.
//

#import "ViewController.h"

@interface ViewController ()

@property(nonatomic, strong) UIView          *bgView;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    self.bgView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height)];
    self.bgView.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.bgView];
    
    UIImageView *bgImgV = [[UIImageView alloc]initWithFrame:self.bgView.frame];
    bgImgV.image = [UIImage imageNamed:@"jiqimao"];
    [self.bgView addSubview:bgImgV];
    
    UIButton *loginBtn = [[UIButton alloc] initWithFrame:CGRectMake(130, 100, 60, 60)];
    [loginBtn setTitle:@"登录" forState:UIControlStateNormal];
    loginBtn.backgroundColor = [UIColor blackColor];
    [loginBtn addTarget:self action:@selector(loginBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:loginBtn];
    
    UIButton *uploadBtn = [[UIButton alloc] initWithFrame:CGRectMake(200, 100, 60, 60)];
    [uploadBtn setTitle:@"上传" forState:UIControlStateNormal];
    uploadBtn.backgroundColor = [UIColor blackColor];
    [uploadBtn addTarget:self action:@selector(uploadBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:uploadBtn];
    
    UIButton *payBtn = [[UIButton alloc] initWithFrame:CGRectMake(130, 170, 60, 60)];
    [payBtn setTitle:@"支付" forState:UIControlStateNormal];
    payBtn.backgroundColor = [UIColor blackColor];
    [payBtn addTarget:self action:@selector(payBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:payBtn];
    
    
//    UIButton *logoutBtn = [[UIButton alloc] initWithFrame:CGRectMake(200, 170, 60, 60)];
//    [logoutBtn setTitle:@"退出" forState:UIControlStateNormal];
//    logoutBtn.backgroundColor = [UIColor blackColor];
//    [logoutBtn addTarget:self action:@selector(logoutBtnAction:) forControlEvents:UIControlEventTouchUpInside];
//    [self.bgView addSubview:logoutBtn];
    
    /* -----------   SDK代理，用于接收回调  ----------- */
    [YYLXMchInterfaceManager shareInstance].delegate = self;
}

#pragma mark - SDK接入方法

-(void)loginMethod{
    /* -----------   SDK登录  ----------- */
    [[YYLXMchInterfaceManager shareInstance] doLogin];
}


-(void)uploadPlayerMethod{
    /* -----------   SDK上传角色信息，创建角色后即可上传，（已存在角色的用户，在登录时上传）  ----------- */
    YYLXMchPlayerInfo *playerInfo = [[YYLXMchPlayerInfo alloc] init];
    /*参数注释，请进入YYLXMchPlayerInfo.h查看参数说明*/
    // -------------- 此处为测试角色信息，需替换成游戏内真实数据 ！！！！！！
    playerInfo.gameService = @"ios101区";
    playerInfo.gameServiceId = @"101";
    playerInfo.playerName = @"宇宙";
    playerInfo.playerLevel = @"101";
    playerInfo.playerNameID = @"10101";
    playerInfo.player_reserve = @"yushe";
    // --------------需将所有数据按字符串格式赋值
    
    [[YYLXMchInterfaceManager shareInstance] doUpdatePlayerInfo:playerInfo];
}

-(void)payMethod{
    /* -----------   SDK提交订单信息  ----------- */
    YYLXMchPayInfo *orderInfo = [[YYLXMchPayInfo alloc]init];
    /*参数注释，请进入YYLXMchPayInfo.h查看参数说明*/
    // -------------- 此处为测试支付信息，需替换成游戏内真实数据 ！！！！！！
    orderInfo.productId = @"com.yzyz.productId";
    orderInfo.goodsPrice = @"600";              // 商品价格(价格为 分),600即6元
    orderInfo.goodsName = @"元宝6个";
    orderInfo.goodsDesc = @"6个元宝";
    orderInfo.orderID = [NSString stringWithFormat:@"1011%.f",(double)time(NULL)*1000];//订单字段
    orderInfo.extendInfo = @""; // 此字段会透传到游戏服务器,没有可不传
    
    orderInfo.gameVersion = @"1.0";
    orderInfo.goods_reserve = @"";  // 订-单预留参数(有多余值可传，没有则不传)
    // --------------需将所有数据按字符串格式赋值
    
    [[YYLXMchInterfaceManager shareInstance] doPay:orderInfo];
}

-(void)logoutMethod{
    /* -----------   SDK登出  ----------- */
    [[YYLXMchInterfaceManager shareInstance] doLogout];
}


#pragma mark - SDK回调方法
/* -----------   SDK登录成功回调  ----------- */
-(void)mchLoginSuccessWithResultData:(NSDictionary *)loginDataDic{
    NSLog(@"----YZYZ登录成功---->%@----",loginDataDic);
    /*  获取 token user_id ， 做登录校验。
     loginDataDic返回值：
    {
        "channel_data" = "<null>";
        token = eaypJS1dc62LVoyIXC26l6kUIkjVoI0cNzTaIxMywiaXAiOiI1OS42MC41NS42OCIsIm9wZW5fdXNlcl9pZCI6OCwiZmZfcGxhdGZvcm0iOjcsImhvc3QiOiJseC5mdWh1YTk1LmNvbSIsInRpbWUiOjE2Njg0OTM1MjZ9;
        "user_birthday" = "<null>";
        "user_certification" = "<null>";
        "user_id" = "sue_45213";
    }
    */
    
    /* -----------   SDK登录校验成功后，存在角色信息， 即可上传角色  ----------- */
    [self uploadPlayerMethod];
}

/* -----------   SDK登录失败回调  ----------- */
-(void)mchLoginFail{
    NSLog(@"----YZYZ登录失败----");
}

/* -----------   SDK初始化回调  ----------- */
-(void)mchInitResult:(BOOL)success{
    if(success){
        NSLog(@"----YZYZ初始化成功----");
    }else{
        NSLog(@"----YZYZ初始化失败----");
    }
}

/* -----------   SDK登出回调  ----------- */
-(void)mchDidLogout:(BOOL)success{
    if(success){
        NSLog(@"----YZYZ退出成功----");
        //若游戏还没有退出，需要先退出游戏，再调佣doLogin方法 ！！！！
        
        /* -----------   SDK登出成功后，调用登录接口，确保可以重新登录账号  ----------- */
        [[YYLXMchInterfaceManager shareInstance] doLogin];
    }else{
        NSLog(@"----YZYZ退出失败----");
    }
}

/* -----------   SDK创建订单回调  ----------- */
- (void)mchCreateOrderResult:(BOOL)success{
    if(success){
        NSLog(@"----YZYZ创建订单成功----");
    }else{
        NSLog(@"----YZYZ创建订单失败----");
    }
}

/* -----------   SDK支付回调  ----------- */
- (void)mchPayResult:(BOOL)success{
    if(success){
        NSLog(@"----YZYZ支付成功----");
    }else{
        NSLog(@"----YZYZ支付失败----");
    }
}

/* -----------   SDK角色上传回调  ----------- */
- (void)mchUploadplayerInfo:(BOOL)success{
    if(success){
        NSLog(@"----YZYZ角色上传成功----");
    }else{
        NSLog(@"----YZYZ角色上传失败----");
    }
}



#pragma mark -按钮事件

- (void)loginBtnAction:(id)sender {
    [self loginMethod];
}

-(void)uploadBtnAction:(id)sender {
    [self uploadPlayerMethod];
}

- (void)payBtnAction:(id)sender {
    [self payMethod];
}

- (void)logoutBtnAction:(id)sender {
    [self logoutMethod];
}


@end
