//
//  AppDelegate.m
//  YZYZ13DemoApp
//
//  Created by xiaoLv on 2022/11/10.
//

#import "AppDelegate.h"
#import <YYLXMchInterface/YYLXMchInterface.h>
#import "ViewController.h"

@interface AppDelegate ()

@end

@implementation AppDelegate

@synthesize window = _window;

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.currentWindow = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    
    [self.currentWindow makeKeyAndVisible];
    ViewController *rootController = [[ViewController alloc] init];
    UINavigationController *navCtrler = [[UINavigationController alloc] initWithRootViewController:rootController];
    self.currentWindow.rootViewController = navCtrler;
    
    /* -----------   SDK 初始化  ----------- */
    [[YYLXMchInterfaceManager shareInstance] doInit:rootController application:[UIApplication sharedApplication] didFinishLaunchingWithOptions:nil];
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game
    [[YYLXMchInterfaceManager shareInstance] applicationWillResignActive:application];
}


- (void)applicationDidEnterBackground:(UIApplication *)application{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    [[YYLXMchInterfaceManager shareInstance] applicationDidEnterBackground:application];
}


- (void)applicationWillEnterForeground:(UIApplication *)application{
    // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
    [[YYLXMchInterfaceManager shareInstance] applicationWillEnterForeground:application];
}


- (void)applicationDidBecomeActive:(UIApplication *)application{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    [[YYLXMchInterfaceManager shareInstance] applicationDidBecomeActive:application];
}


- (void)applicationWillTerminate:(UIApplication *)application{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    [[YYLXMchInterfaceManager shareInstance] applicationWillTerminate:application];
}

/**
 *  / Will be deprecated at some point, please replace with application:openURL:sourceApplication:annotation:
 *
 *  @param application application description
 *  @param url         url description
 *
 *  @return YES/NO
 */
- (BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url{
    [[YYLXMchInterfaceManager shareInstance] application:application handleOpenURL:url];
    return YES;
}

- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation{
    [[YYLXMchInterfaceManager shareInstance] application:application openURL:url sourceApplication:sourceApplication annotation:annotation];
    return YES;
}

#if __IPHONE_OS_VERSION_MAX_ALLOWED >= __IPHONE_9_0
- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url options:(NSDictionary<NSString *,id> *)options{
    [[YYLXMchInterfaceManager shareInstance] application:application openURL:url options:options];
    return YES;
}
#endif

- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken
{
    [[YYLXMchInterfaceManager shareInstance] application:application didRegisterForRemoteNotificationsWithDeviceToken:deviceToken];
}

- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError *)error
{
    [[YYLXMchInterfaceManager shareInstance] application:application didFailToRegisterForRemoteNotificationsWithError:error];
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window
{
    return [[YYLXMchInterfaceManager shareInstance] application:application supportedInterfaceOrientationsForWindow:window];
}

- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray * restorableObjects))restorationHandler{
    [[YYLXMchInterfaceManager shareInstance] application:application continueUserActivity:userActivity restorationHandler:restorationHandler];
    return YES;
}



@end
