//
//  BRSDKApi.h
//
//  Created by cy on 2019/11/3.
//  Copyright © 2019年 cy. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "BRSDKRoleInfo.h"
#import "BRSDKOrderInfo.h"

NS_ASSUME_NONNULL_BEGIN

extern NSString* kBRSDKInitNotification;   ///初始化回调通知
extern NSString* kBRSDKLoginNotification;  ///登录回调通知
extern NSString* kBRSDKLogoutNotification; ///注销回调通知
extern NSString* kBRSDKTradeNotification;  ///支付回调通知
extern NSString* kBRSDKSendRoleNotification;    ///上传角色回调通知
@interface BRSDKApi : NSObject

/**
 * 单例
 */
+ (BRSDKApi *)sharedInstance;


/**
 * 初始化泊然sdk
 *
 * @param appId      唯一标示符
 * @param appKey    唯一标示符
 */
- (void)initSDKWithAppId:(NSString *)appId appKey:(NSString *)appKey;


/**
 * 登录
 */
- (void)login;


/**
 * 支付
 *
 * @param orderInfo 订单信息
 */
- (void)trade:(BRSDKOrderInfo*)orderInfo;
           

/**
 * 角色上报
 */
- (void)sendGameRoleInfo:(BRSDKRoleInfo*)roleInfo;


/**
 * 注销登录
 */
- (void)logout;

/**
 切换账号
 */
- (void)switchAccount;
/**
 * 是否登录
 */
- (BOOL)isLogined;


/**
 * 显示悬浮窗界面
 */
- (void)showFloatView;


/**
 * 隐藏悬浮窗界面
 */
- (void)hideFloatView;


/**
 * 获取SDK版本信息
 */
- (NSString*)getSdkVersion;


/**
 * 获取channelCode
 */
- (NSString*)getChannelCode;


/**
 * 获取sdkPlatform
 */
- (NSString*)getSdkPlatform;


#pragma mark - 周期函数

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions;

- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url options:(NSDictionary<NSString*, id> *)options;

- (void)applicationWillResignActive:(UIApplication *)application;

- (void)applicationDidEnterBackground:(UIApplication *)application;

- (void)applicationWillEnterForeground:(UIApplication *)application;

- (void)applicationDidBecomeActive:(UIApplication *)application;

- (void)applicationWillTerminate:(UIApplication *)application;

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window;

@end

NS_ASSUME_NONNULL_END
