//
//  ViewController.m
//
//  Created by cy on 2019/6/27.
//  Copyright © 2019年 cy. All rights reserved.
//

#import "ViewController.h"
#import <BRSDK/BRSDKApi.h>

@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];

    self.view.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"demo_game_bg.jpg"]];

    //初始化回调通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(brsdk_initNotice:) name:kBRSDKInitNotification object:nil];
    
    //登录回调通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(brsdk_loginNotice:) name:kBRSDKLoginNotification object:nil];
    
    //支付回调通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(brsdk_tradeNotice:) name:kBRSDKTradeNotification object:nil];
    
    //注销回调通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(brsdk_loginOutNotice:) name:kBRSDKLogoutNotification object:nil];
    
    //上传角色回调通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(brsdk_sendRoleNotice:) name:kBRSDKSendRoleNotification object:nil];

    
    //初始化
    NSString* appId     = @"911a963faa5ba871c17cf52faf2cab2c";
    NSString* appKey    = @"90c1e49291adfb234412422ec1afa0ce";
    [[BRSDKApi sharedInstance] initSDKWithAppId:appId appKey:appKey];
}

//登录
- (IBAction)addLoginBtn:(UIButton *)sender
{
    [[BRSDKApi sharedInstance] login];
}

//注销登录
- (IBAction)logoutBtn:(UIButton *)sender
{
    [[BRSDKApi sharedInstance] logout];
}

//支付
- (IBAction)payBtn:(UIButton *)sender
{
    BRSDKOrderInfo* orderInfo = [[BRSDKOrderInfo alloc] init];
    orderInfo.productId = @"100001111";
    orderInfo.productName = @"980元宝";
    orderInfo.productDesc = @"980元宝";
    orderInfo.productPrice = @"1"; //单位分
    orderInfo.roleId = @"1002";
    orderInfo.roleName = @"屋檐";
    orderInfo.serverId = @"2";
    orderInfo.serverName = @"测试demo服务器";
    orderInfo.extInfo = @"125475574557";
    [[BRSDKApi sharedInstance] trade:orderInfo];
}

//上报角色信息
- (IBAction)sendRoleBtn:(UIButton *)sender
{
    BRSDKRoleInfo* roleInfo = [[BRSDKRoleInfo alloc] init];
    roleInfo.uploadType = BRSDKUploadRoleInfoTypeEnterGame;
    roleInfo.serverId = @"2";
    roleInfo.serverName = @"测试demo服务器";
    roleInfo.roleId = @"1002";
    roleInfo.roleName = @"屋檐";
    roleInfo.roleLevel = @"12";
    roleInfo.partyName = @"无帮派";
    roleInfo.balance = 20.0;
    roleInfo.fightingCapacity = @"10";
    roleInfo.reincarnation = @"0";
    roleInfo.roleVip = @"0";
    [[BRSDKApi sharedInstance] sendGameRoleInfo:roleInfo];
}

#pragma mark - 回调

-(void)brsdk_initNotice:(NSNotification *)notification
{
    NSDictionary *userInfo = notification.userInfo;
    NSString *code = [userInfo objectForKey:@"code"];
    NSLog(@"ViewController SDK 初始化回调----info=%@", userInfo);
    
    /**
     code返回:
     1  初始化成功
     0  初始化失败
     **/
    if (code && [code isEqualToString:@"1"]) {
        [[BRSDKApi sharedInstance] login];
    } else {
        NSLog(@"ViewController SDK 初始化失败");
    }
}

- (void)brsdk_loginNotice:(NSNotification *)notification
{
    /**
     code返回
     1  登录成功          token值不为空
     0  登录失败          token值为空
     **/
    NSDictionary *userInfo = notification.userInfo;
    NSString *code      = [userInfo objectForKey:@"code"];
    NSString *token     = [userInfo objectForKey:@"token"];
    NSString *userId    = [userInfo objectForKey:@"userId"];
    NSLog(@"ViewController SDK 登录回调-----token=%@  userId=%@  code = %@", token, userId, code);
    
    if (code && [code isEqualToString:@"1"]) {
        //上报角色
        [self sendRoleBtn:nil];
    } else {
        NSLog(@"ViewController SDK 登录失败");
    }
}


-(void)brsdk_loginOutNotice:(NSNotification *)notification
{
    NSDictionary *Info = notification.userInfo;
    NSString *code = [Info objectForKey:@"code"];
    NSLog(@"ViewController SDK 注销成功 , info = %@",Info);
    /**
     code返回
     1  退出登录
     0  切换账号
     **/
//    [[BRSDKApi sharedInstance] login];
}

-(void)brsdk_sendRoleNotice:(NSNotification *)notification{
    NSDictionary *Info = notification.userInfo;
    NSString *code = [Info objectForKey:@"code"];
    NSLog(@"ViewController SDK 上传角色接受到回调 , info = %@",Info);
    /**
     code返回
     1  上传角色成功
     0  上传角色失败
     2 网络错误

     **/
}

-(void)brsdk_tradeNotice:(NSNotification *)notification
{
    NSDictionary *payInfo = notification.userInfo;
    NSString *code = [payInfo objectForKey:@"code"];
    NSLog(@"ViewController SDK 支付回调----payInfo=%@", payInfo);
    
    /**
     code返回
     1  支付成功
     0  支付失败
     2  支付取消
     **/
    if (code && [code isEqualToString:@"1"]) {
        NSLog(@"ViewController SDK 支付成功");
    } else if (code && [code isEqualToString:@"2"]) {
        NSLog(@"ViewController SDK 支付取消");
    } else {
        NSLog(@"ViewController SDK 支付失败");
    }
}

@end
