package com.brsdk.android.demo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Toast;

import com.brsdk.android.bean.BRSdkUser;
import com.brsdk.android.core.BRSdkApi;
import com.brsdk.android.bean.BRSdkPay;
import com.brsdk.android.bean.BRSdkRole;
import com.brsdk.android.bean.BRSdkState;
import com.brsdk.android.event.BREventListener;
import com.brsdk.android.event.BROAIDListener;
import com.brsdk.android.utils.BRLogger;

import java.lang.reflect.Field;

public class MainActivity extends Activity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        sdkFunctionSample();

        onConfigBrsdk();

        onInitView();

        onInitialize();
    }

    private void sdkFunctionSample() {
        BRSdkApi.getInstance().getOAID(new BROAIDListener() {
            @Override
            public void onFinished(String data) {
                Log.e(getClass().getName(), "OAID: " +data);
            }
        });
    }

    private void onInitView() {
        for (View view : new View[]{
                // SDK功能
                findViewById(R.id.brsdkInit),
                findViewById(R.id.brsdkLogin),
                findViewById(R.id.brsdkPay1),
                findViewById(R.id.brsdkPay_1),
                findViewById(R.id.brsdkLogout),
                findViewById(R.id.brsdkExit),
                findViewById(R.id.brsdkJump),
                // 角色操作
                findViewById(R.id.roleUnknown),
                findViewById(R.id.roleCreate),
                findViewById(R.id.roleLogin),
                findViewById(R.id.roleUpload),
                findViewById(R.id.roleParty),
                findViewById(R.id.roleOther),
                findViewById(R.id.roleLogout),
        }) {
            view.setOnClickListener(this);
        }
    }

    // 角色数据说明
    private static BRSdkRole fakeRole(BRSdkRole.Event event) {
        return new BRSdkRole()
                .setRoleId("1001") // 角色ID
                .setRoleName("角色名") // 角色名
                .setRoleLevel("10") // 角色等级
                .setServerId("101") // 服务器ID
                .setServerName("服务器名") // 服务器名
                .setBalance("1000") // 角色账户余额
                .setCreateTime(System.currentTimeMillis() /1000 +"") // 角色创建时间(秒)
                .setPartyId("11") // 帮派/工会ID
                .setPartyName("帮派/工会名") // 帮派/工会
                .setVipLevel("5") // 角色VIP等级
                .setRolePower("1000000") // 战斗力
                .setRoleEvent(event) // 角色事件
                .setReincarnation("1") // 转生等级
                .setProfession("法师") // 角色职业
                .setGender(BRSdkRole.Gender.male); // 角色性别
    }

    // 支付数据说明
    private BRSdkPay fakePay(int money) {
        return new BRSdkPay()
                // 支付数据
                .setExtInfo("透传参数") // 透传参数
                .setProductId("1") // 商品ID
                .setProductName("商品名") // 商品名
                .setProductDesc("商品描述") // 商品描述
                .setProductCount("1") // 商品数量
                .setProductPrice(String.valueOf(money)) // 商品总金额(分)
                .setCurrencyName("金币") // 货币名称
                .setExchangeRate("10") // 充值转换(1元=N元宝/金币等)
                // 角色信息
                .setRoleId("1001") // 角色ID
                .setRoleName("角色名") // 角色名
                .setServerId("101") // 服务器ID
                .setServerName("服务器名"); // 服务器名
    }



    // ============================== 以下为对接内容 ==============================

    private void onConfigBrsdk() {
        // TODO SDK所有事件回调
        BRSdkApi.getInstance().setEventListener(new BREventListener(){

            @Override
            public void onProtocolEnd(BRSdkState state) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "同意协议", Toast.LENGTH_SHORT).show();
                    BRSdkApi.getInstance().onInit();
                } else {
                    Toast.makeText(MainActivity.this, "拒绝协议", Toast.LENGTH_SHORT).show();
                }
            }

            @Override // 初始化结束
            public void onInitFinished(BRSdkState state) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "初始化成功", Toast.LENGTH_SHORT).show();
                    // TODO 必须在初始化成功之后调用登录
                    BRSdkApi.getInstance().onLogin();
                } else {
                    Toast.makeText(MainActivity.this, "初始化失败", Toast.LENGTH_SHORT).show();
                }
            }

            @Override // 登录结束
            public void onLoginFinished(BRSdkState state, BRSdkUser user) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "登录成功", Toast.LENGTH_SHORT).show();
                    // TODO 必须在登录成功之后调用角色上传
                    upRole(BRSdkRole.Event.create);
                } else {
                    Toast.makeText(MainActivity.this, "登录失败", Toast.LENGTH_SHORT).show();
                }
            }

            @Override // 支付结束
            public void onPayFinished(BRSdkState state, BRSdkPay pay) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "支付成功", Toast.LENGTH_SHORT).show();
                } else if (state.getCode() == BRSdkState.Code.cancel) {
                    Toast.makeText(MainActivity.this, "支付取消", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "支付失败", Toast.LENGTH_SHORT).show();
                }
            }

            @Override // 上传角色结束
            public void onUpRoleFinished(BRSdkState state, BRSdkRole role) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "上传成功", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "上传失败", Toast.LENGTH_SHORT).show();
                }
            }

            @Override // 注销登录结束
            public void onLogoutFinished(BRSdkState state) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "注销成功", Toast.LENGTH_SHORT).show();
                    // TODO 这里需要退出到游戏入口；再拉起SDK登录
                    BRSdkApi.getInstance().onLogin();
                } else {
                    Toast.makeText(MainActivity.this, "注销失败", Toast.LENGTH_SHORT).show();
                }
            }

            @Override // 退出应用结束
            public void onExitFinished(BRSdkState state) {
                if (state.getCode() == BRSdkState.Code.success) {
                    Toast.makeText(MainActivity.this, "退出成功", Toast.LENGTH_SHORT).show();
                    // TODO 游戏可以在这里做相关数据保存，SDK稍后会进行退出操作
                } else if (state.getCode() == BRSdkState.Code.cancel) {
                    Toast.makeText(MainActivity.this, "退出取消", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "退出失败", Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    protected void onInitialize() {
        // TODO 如果游戏本身【没有隐私政策】则显示SDK的相关协议弹窗

        // TODO 用户点击不同意后SDK内部会自动退出当前游戏
        // TODO 用户同意协议后需要立即调用初始化
        BRSdkApi.getInstance().showProtocol();



        // TODO 如果游戏本身【有隐私政策】则显示SDK的相关协议弹窗

        // TODO 初始化：需要配置assets/brsdk_config.json：AppId、AppKey
//        BRSdkApi.getInstance().onInit();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.brsdkInit) {
            onInitialize();

        } else if (view.getId() == R.id.brsdkLogin) {
            // TODO 账号登录；必须在初始化成功之后
            BRSdkApi.getInstance().onLogin();

        } else if (view.getId() == R.id.brsdkPay1) {
            // TODO 支付充值(1元)
            BRSdkApi.getInstance().onPay(fakePay(100));

        } else if (view.getId() == R.id.brsdkPay_1) {
            // TODO 支付充值(0.1元)
            BRSdkApi.getInstance().onPay(fakePay(10));

        } else if (view.getId() == R.id.brsdkLogout) {
            // TODO 账号注销
            BRSdkApi.getInstance().onLogout();

        } else if (view.getId() == R.id.brsdkExit) {
            // TODO 游戏退出
            BRSdkApi.getInstance().onExit();

        } else if (view.getId() == R.id.brsdkJump) {
            // SDK测试，忽略
            startActivity(new Intent(this, OtherActivity.class));
        }

        if (view.getId() == R.id.roleUnknown) {
            // TODO 未知事件
            upRole(BRSdkRole.Event.unknown);

        } else if (view.getId() == R.id.roleCreate) {
            // TODO 创建角色
            upRole(BRSdkRole.Event.create);

        } else if (view.getId() == R.id.roleLogin) {
            // TODO 角色在线
            upRole(BRSdkRole.Event.online);

        } else if (view.getId() == R.id.roleUpload) {
            // TODO 角色升级
            upRole(BRSdkRole.Event.levelUp);

        } else if (view.getId() == R.id.roleParty) {
            // TODO 加入帮派工会
            upRole(BRSdkRole.Event.toParty);

        } else if (view.getId() == R.id.roleOther) {
            // TODO 角色更新
            upRole(BRSdkRole.Event.other);

        } else if (view.getId() == R.id.roleLogout) {
            // TODO 角色离线
            upRole(BRSdkRole.Event.offline);

        }
    }

    private void upRole(BRSdkRole.Event event) {
        // TODO 角色上报根据不同的角色事件上传角色信息；必须在登录成功之后
        BRSdkApi.getInstance().onUpRole(fakeRole(event));
        Toast.makeText(this, "正在上传角色", Toast.LENGTH_SHORT).show();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        // TODO 生命周期：结果回调
        BRSdkApi.getInstance().onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        // TODO 生命周期：权限回调
        BRSdkApi.getInstance().onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onBackPressed() {
        // TODO 游戏退出
        BRSdkApi.getInstance().onExit();
    }
}
