/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ia extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "hora normal de Moscova",
               "",
               "hora estive de Moscova",
               "",
               "hora de Moscova",
               "",
            };
        final String[] Magadan = new String[] {
               "hora normal de Magadan",
               "",
               "hora estive de Magadan",
               "",
               "hora de Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "hora normal de Europa central",
               "",
               "hora estive de Europa central",
               "",
               "hora de Europa central",
               "",
            };
        final String[] Sakhalin = new String[] {
               "hora normal de Sachalin",
               "",
               "hora estive de Sachalin",
               "",
               "hora de Sachalin",
               "",
            };
        final String[] America_Eastern = new String[] {
               "hora normal del est",
               "",
               "hora estive del est",
               "",
               "hora del est",
               "",
            };
        final String[] Yakutsk = new String[] {
               "hora normal de Yakutsk",
               "",
               "hora estive de Yakutsk",
               "",
               "hora de Yakutsk",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "hora normal de Europa oriental",
               "",
               "hora estive de Europa oriental",
               "",
               "hora de Europa oriental",
               "",
            };
        final String[] Newfoundland = new String[] {
               "hora normal de Terranova",
               "",
               "hora estive de Terranova",
               "",
               "hora de Terranova",
               "",
            };
        final String[] Atlantic = new String[] {
               "hora normal atlantic",
               "",
               "hora estive atlantic",
               "",
               "hora atlantic",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "hora normal de Saint-Pierre e Miquelon",
               "",
               "hora estive de Saint-Pierre e Miquelon",
               "",
               "hora de Saint-Pierre e Miquelon",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "hora normal de Ekaterinburg",
               "",
               "hora estive de Ekaterinburg",
               "",
               "hora de Ekaterinburg",
               "",
            };
        final String[] Omsk = new String[] {
               "hora normal de Omsk",
               "",
               "hora estive de Omsk",
               "",
               "hora de Omsk",
               "",
            };
        final String[] America_Central = new String[] {
               "hora normal central",
               "",
               "hora estive central",
               "",
               "hora central",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "hora normal de Novosibirsk",
               "",
               "hora estive de Novosibirsk",
               "",
               "hora de Novosibirsk",
               "",
            };
        final String[] Azores = new String[] {
               "hora normal del Azores",
               "",
               "hora estive del Azores",
               "",
               "hora del Azores",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "hora normal de Krasnoyarsk",
               "",
               "hora estive de Krasnoyarsk",
               "",
               "hora de Krasnoyarsk",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora normal de Hawaii-Aleutianas",
               "",
               "hora estive de Hawaii-Aleutianas",
               "",
               "hora de Hawaii-Aleutianas",
               "",
            };
        final String[] America_Pacific = new String[] {
               "hora normal pacific",
               "",
               "hora estive pacific",
               "",
               "hora pacific",
               "",
            };
        final String[] Europe_Western = new String[] {
               "hora normal de Europa occidental",
               "",
               "hora estive de Europa occidental",
               "",
               "hora de Europa occidental",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "hora normal del Pacifico mexican",
               "",
               "hora estive del Pacifico mexican",
               "",
               "hora del Pacifico mexican",
               "",
            };
        final String[] Cuba = new String[] {
               "hora normal de Cuba",
               "",
               "hora estive de Cuba",
               "",
               "hora de Cuba",
               "",
            };
        final String[] GMT = new String[] {
               "hora medie de Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "hora normal de Volgograd",
               "",
               "hora estive de Volgograd",
               "",
               "hora de Volgograd",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "hora normal del nordwest de Mexico",
               "",
               "hora estive del nordwest de Mexico",
               "",
               "hora del nordwest de Mexico",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "hora normal de Groenlandia occidental",
               "",
               "hora estive de Groenlandia occidental",
               "",
               "hora de Groenlandia occidental",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "hora normal de Groenlandia oriental",
               "",
               "hora estive de Groenlandia oriental",
               "",
               "hora de Groenlandia oriental",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hora normal del montanias",
               "",
               "hora estive del montanias",
               "",
               "hora del montanias",
               "",
            };
        final String[] Alaska = new String[] {
               "hora normal de Alaska",
               "",
               "hora estive de Alaska",
               "",
               "hora de Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "hora normal de Vladivostok",
               "",
               "hora estive de Vladivostok",
               "",
               "hora de Vladivostok",
               "",
            };
        final String[] Irkutsk = new String[] {
               "hora normal de Irkutsk",
               "",
               "hora estive de Irkutsk",
               "",
               "hora de Irkutsk",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bucharest", Europe_Eastern },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "America/Marigot", Atlantic },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "America/El_Salvador", America_Central },
            { "Africa/Cairo", Europe_Eastern },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "America/Guatemala", America_Central },
            { "Europe/London",
                new String[] {
                    "hora medie de Greenwich",
                    "",
                    "Hora estive britannic",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Nord" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Warsaw", Europe_Central },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "America/Grand_Turk", America_Eastern },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Europe/Isle_of_Man", GMT },
            { "Asia/Novosibirsk", Novosibirsk },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Europe/London", "London" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Atlantic/Canary", "Canarias" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "Africa/Freetown", GMT },
            { "timezone.excity.America/Nome", "Nome" },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "Europe/Skopje", Europe_Central },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/St_Lucia", "Sancte Lucia" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Europe/Rome", Europe_Central },
            { "America/Regina", America_Central },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "Asia/Omsk", Omsk },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "Europe/Vaduz", Europe_Central },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Nord" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/St_Vincent", "Sancte Vincente" },
            { "America/Rainy_River", America_Central },
            { "timezone.excity.America/Panama", "Panama" },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del Nord" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Athenas" },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Zurich" },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhagen" },
            { "timezone.excity.America/New_York", "Nove York" },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Citate incognite" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "SystemV/MST7", America_Mountain },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "timezone.excity.America/St_Kitts", "Sancte Christophoro" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "America/Boise", America_Mountain },
            { "EST5EDT", America_Eastern },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburg" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "Europe/Dublin",
                new String[] {
                    "hora medie de Greenwich",
                    "",
                    "Hora estive irlandese",
                    "",
                    "",
                    "",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "America/Jamaica", America_Eastern },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.America/Denver", "Denver" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Aruba", Atlantic },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.America/Mexico_City", "Citate de Mexico" },
            { "timezone.excity.Europe/Isle_of_Man", "Insula de Man" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "timezone.excity.Europe/Lisbon", "Lisbona" },
            { "Asia/Damascus", Europe_Eastern },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Atlantic/Reykjavik", GMT },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "America/Matamoros", America_Central },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "America/Blanc-Sablon", Atlantic },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "America/Resolute", America_Central },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moscova" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "Europe/Minsk", Moscow },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "hora medie de Greenwich",
                    "",
                    "Hora estive britannic",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Johns", "Sancte Johannes de Terranova" },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "timezone.excity.America/St_Barthelemy", "Sancte Bartholomeo" },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "timezone.excity.America/St_Thomas", "Sancte Thomas" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vienna" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Caiman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Atlantic/Faeroe", "Feroe" },
            { "Africa/Timbuktu", GMT },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.Atlantic/Azores", "Azores" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Irkutsk", Irkutsk },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Universal Tempore Coordinate",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
        };
        return data;
    }
}
