/*
 * Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */


package org.graalvm.compiler.core.test;

import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.junit.Test;

public class SwitchCanonicalizerTest extends GraalCompilerTest {

    public int divByPowerOf2(int n) {
        switch (n / 8) {
            case Integer.MAX_VALUE / 8 + 1:
                return hashCode();
            default:
                return 1;
        }
    }

    @Test
    public void testDivByPowerOf2() {
        shouldFoldSwitch("divByPowerOf2");
    }

    public int divByNonPowerOf2(int n) {
        switch (n / 7) {
            case Integer.MAX_VALUE / 7 + 1:
                return hashCode();
            default:
                return 1;
        }
    }

    @Test
    public void testDivByNonPowerOf2() {
        shouldFoldSwitch("divByNonPowerOf2");
    }

    public int remByPowerOf2(int n) {
        switch (n % 8) {
            case 9:
                return hashCode();
            default:
                return 1;
        }
    }

    @Test
    public void testRemByPowerOf2() {
        shouldFoldSwitch("remByPowerOf2");
    }

    public int remByPowerOf2PositiveX(int n) {
        int n0 = n > 0 ? 8 : 9;
        switch (n0 % 8) {
            case 9:
                return hashCode();
            default:
                return 1;
        }
    }

    @Test
    public void testRemByPowerOf2PositiveX() {
        shouldFoldSwitch("remByPowerOf2PositiveX");
    }

    public int remByPowerOf2NegativeX(int n) {
        int n0 = n > 0 ? -8 : -9;
        switch (n0 % 8) {
            case 9:
                return hashCode();
            default:
                return 1;
        }
    }

    @Test
    public void testRemByPowerOf2NegativeX() {
        shouldFoldSwitch("remByPowerOf2NegativeX");
    }

    public int remByNonPowerOf2(int n) {
        switch (n % 7) {
            case 9:
                return hashCode();
            default:
                return 1;
        }
    }

    @Test
    public void testRemByNonPowerOf2() {
        shouldFoldSwitch("remByNonPowerOf2");
    }

    private void shouldFoldSwitch(String methodName) {
        StructuredGraph graph = parseForCompile(getResolvedJavaMethod(methodName));
        createCanonicalizerPhase().apply(graph, getDefaultHighTierContext());
        assertTrue(graph.getNodes().filter(IntegerSwitchNode.class).isEmpty());
    }

}
