/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.tools.doclint;

import java.util.HashMap;

/**
 * Table of entities defined in HTML 5.2.
 *
 * <p> Derived from the
 * <a href="https://www.w3.org/TR/html52/syntax.html#named-character-references">Named character references</a>
 * section of the HTML 5.2 specification.
 *
 * <p><b>This is NOT part of any supported API.
 * If you write code that depends on this, you do so at your own
 * risk.  This code and its internal interfaces are subject to change
 * or deletion without notice.</b></p>
 */
public class Entity {

    private static final HashMap<String,String> html5Entities = new HashMap<>();

    static {
        html5Entities.put("Aacute", "\u00C1");
        html5Entities.put("aacute", "\u00E1");
        html5Entities.put("Abreve", "\u0102");
        html5Entities.put("abreve", "\u0103");
        html5Entities.put("ac", "\u223E");
        html5Entities.put("acd", "\u223F");
        html5Entities.put("acE", "\u223E\u0333");
        html5Entities.put("Acirc", "\u00C2");
        html5Entities.put("acirc", "\u00E2");
        html5Entities.put("acute", "\u00B4");
        html5Entities.put("Acy", "\u0410");
        html5Entities.put("acy", "\u0430");
        html5Entities.put("AElig", "\u00C6");
        html5Entities.put("aelig", "\u00E6");
        html5Entities.put("af", "\u2061");
        html5Entities.put("Afr", "\uD835\uDD04");
        html5Entities.put("afr", "\uD835\uDD1E");
        html5Entities.put("Agrave", "\u00C0");
        html5Entities.put("agrave", "\u00E0");
        html5Entities.put("alefsym", "\u2135");
        html5Entities.put("aleph", "\u2135");
        html5Entities.put("Alpha", "\u0391");
        html5Entities.put("alpha", "\u03B1");
        html5Entities.put("Amacr", "\u0100");
        html5Entities.put("amacr", "\u0101");
        html5Entities.put("amalg", "\u2A3F");
        html5Entities.put("amp", "\u0026");
        html5Entities.put("AMP", "\u0026");
        html5Entities.put("andand", "\u2A55");
        html5Entities.put("And", "\u2A53");
        html5Entities.put("and", "\u2227");
        html5Entities.put("andd", "\u2A5C");
        html5Entities.put("andslope", "\u2A58");
        html5Entities.put("andv", "\u2A5A");
        html5Entities.put("ang", "\u2220");
        html5Entities.put("ange", "\u29A4");
        html5Entities.put("angle", "\u2220");
        html5Entities.put("angmsdaa", "\u29A8");
        html5Entities.put("angmsdab", "\u29A9");
        html5Entities.put("angmsdac", "\u29AA");
        html5Entities.put("angmsdad", "\u29AB");
        html5Entities.put("angmsdae", "\u29AC");
        html5Entities.put("angmsdaf", "\u29AD");
        html5Entities.put("angmsdag", "\u29AE");
        html5Entities.put("angmsdah", "\u29AF");
        html5Entities.put("angmsd", "\u2221");
        html5Entities.put("angrt", "\u221F");
        html5Entities.put("angrtvb", "\u22BE");
        html5Entities.put("angrtvbd", "\u299D");
        html5Entities.put("angsph", "\u2222");
        html5Entities.put("angst", "\u00C5");
        html5Entities.put("angzarr", "\u237C");
        html5Entities.put("Aogon", "\u0104");
        html5Entities.put("aogon", "\u0105");
        html5Entities.put("Aopf", "\uD835\uDD38");
        html5Entities.put("aopf", "\uD835\uDD52");
        html5Entities.put("apacir", "\u2A6F");
        html5Entities.put("ap", "\u2248");
        html5Entities.put("apE", "\u2A70");
        html5Entities.put("ape", "\u224A");
        html5Entities.put("apid", "\u224B");
        html5Entities.put("apos", "\u0027");
        html5Entities.put("ApplyFunction", "\u2061");
        html5Entities.put("approx", "\u2248");
        html5Entities.put("approxeq", "\u224A");
        html5Entities.put("Aring", "\u00C5");
        html5Entities.put("aring", "\u00E5");
        html5Entities.put("Ascr", "\uD835\uDC9C");
        html5Entities.put("ascr", "\uD835\uDCB6");
        html5Entities.put("Assign", "\u2254");
        html5Entities.put("ast", "\u002A");
        html5Entities.put("asymp", "\u2248");
        html5Entities.put("asympeq", "\u224D");
        html5Entities.put("Atilde", "\u00C3");
        html5Entities.put("atilde", "\u00E3");
        html5Entities.put("Auml", "\u00C4");
        html5Entities.put("auml", "\u00E4");
        html5Entities.put("awconint", "\u2233");
        html5Entities.put("awint", "\u2A11");
        html5Entities.put("backcong", "\u224C");
        html5Entities.put("backepsilon", "\u03F6");
        html5Entities.put("backprime", "\u2035");
        html5Entities.put("backsim", "\u223D");
        html5Entities.put("backsimeq", "\u22CD");
        html5Entities.put("Backslash", "\u2216");
        html5Entities.put("Barv", "\u2AE7");
        html5Entities.put("barvee", "\u22BD");
        html5Entities.put("barwed", "\u2305");
        html5Entities.put("Barwed", "\u2306");
        html5Entities.put("barwedge", "\u2305");
        html5Entities.put("bbrk", "\u23B5");
        html5Entities.put("bbrktbrk", "\u23B6");
        html5Entities.put("bcong", "\u224C");
        html5Entities.put("Bcy", "\u0411");
        html5Entities.put("bcy", "\u0431");
        html5Entities.put("bdquo", "\u201E");
        html5Entities.put("becaus", "\u2235");
        html5Entities.put("because", "\u2235");
        html5Entities.put("Because", "\u2235");
        html5Entities.put("bemptyv", "\u29B0");
        html5Entities.put("bepsi", "\u03F6");
        html5Entities.put("bernou", "\u212C");
        html5Entities.put("Bernoullis", "\u212C");
        html5Entities.put("Beta", "\u0392");
        html5Entities.put("beta", "\u03B2");
        html5Entities.put("beth", "\u2136");
        html5Entities.put("between", "\u226C");
        html5Entities.put("Bfr", "\uD835\uDD05");
        html5Entities.put("bfr", "\uD835\uDD1F");
        html5Entities.put("bigcap", "\u22C2");
        html5Entities.put("bigcirc", "\u25EF");
        html5Entities.put("bigcup", "\u22C3");
        html5Entities.put("bigodot", "\u2A00");
        html5Entities.put("bigoplus", "\u2A01");
        html5Entities.put("bigotimes", "\u2A02");
        html5Entities.put("bigsqcup", "\u2A06");
        html5Entities.put("bigstar", "\u2605");
        html5Entities.put("bigtriangledown", "\u25BD");
        html5Entities.put("bigtriangleup", "\u25B3");
        html5Entities.put("biguplus", "\u2A04");
        html5Entities.put("bigvee", "\u22C1");
        html5Entities.put("bigwedge", "\u22C0");
        html5Entities.put("bkarow", "\u290D");
        html5Entities.put("blacklozenge", "\u29EB");
        html5Entities.put("blacksquare", "\u25AA");
        html5Entities.put("blacktriangle", "\u25B4");
        html5Entities.put("blacktriangledown", "\u25BE");
        html5Entities.put("blacktriangleleft", "\u25C2");
        html5Entities.put("blacktriangleright", "\u25B8");
        html5Entities.put("blank", "\u2423");
        html5Entities.put("blk12", "\u2592");
        html5Entities.put("blk14", "\u2591");
        html5Entities.put("blk34", "\u2593");
        html5Entities.put("block", "\u2588");
        html5Entities.put("bne", "\u003D\u20E5");
        html5Entities.put("bnequiv", "\u2261\u20E5");
        html5Entities.put("bNot", "\u2AED");
        html5Entities.put("bnot", "\u2310");
        html5Entities.put("Bopf", "\uD835\uDD39");
        html5Entities.put("bopf", "\uD835\uDD53");
        html5Entities.put("bot", "\u22A5");
        html5Entities.put("bottom", "\u22A5");
        html5Entities.put("bowtie", "\u22C8");
        html5Entities.put("boxbox", "\u29C9");
        html5Entities.put("boxdl", "\u2510");
        html5Entities.put("boxdL", "\u2555");
        html5Entities.put("boxDl", "\u2556");
        html5Entities.put("boxDL", "\u2557");
        html5Entities.put("boxdr", "\u250C");
        html5Entities.put("boxdR", "\u2552");
        html5Entities.put("boxDr", "\u2553");
        html5Entities.put("boxDR", "\u2554");
        html5Entities.put("boxh", "\u2500");
        html5Entities.put("boxH", "\u2550");
        html5Entities.put("boxhd", "\u252C");
        html5Entities.put("boxHd", "\u2564");
        html5Entities.put("boxhD", "\u2565");
        html5Entities.put("boxHD", "\u2566");
        html5Entities.put("boxhu", "\u2534");
        html5Entities.put("boxHu", "\u2567");
        html5Entities.put("boxhU", "\u2568");
        html5Entities.put("boxHU", "\u2569");
        html5Entities.put("boxminus", "\u229F");
        html5Entities.put("boxplus", "\u229E");
        html5Entities.put("boxtimes", "\u22A0");
        html5Entities.put("boxul", "\u2518");
        html5Entities.put("boxuL", "\u255B");
        html5Entities.put("boxUl", "\u255C");
        html5Entities.put("boxUL", "\u255D");
        html5Entities.put("boxur", "\u2514");
        html5Entities.put("boxuR", "\u2558");
        html5Entities.put("boxUr", "\u2559");
        html5Entities.put("boxUR", "\u255A");
        html5Entities.put("boxv", "\u2502");
        html5Entities.put("boxV", "\u2551");
        html5Entities.put("boxvh", "\u253C");
        html5Entities.put("boxvH", "\u256A");
        html5Entities.put("boxVh", "\u256B");
        html5Entities.put("boxVH", "\u256C");
        html5Entities.put("boxvl", "\u2524");
        html5Entities.put("boxvL", "\u2561");
        html5Entities.put("boxVl", "\u2562");
        html5Entities.put("boxVL", "\u2563");
        html5Entities.put("boxvr", "\u251C");
        html5Entities.put("boxvR", "\u255E");
        html5Entities.put("boxVr", "\u255F");
        html5Entities.put("boxVR", "\u2560");
        html5Entities.put("bprime", "\u2035");
        html5Entities.put("breve", "\u02D8");
        html5Entities.put("Breve", "\u02D8");
        html5Entities.put("brvbar", "\u00A6");
        html5Entities.put("bscr", "\uD835\uDCB7");
        html5Entities.put("Bscr", "\u212C");
        html5Entities.put("bsemi", "\u204F");
        html5Entities.put("bsim", "\u223D");
        html5Entities.put("bsime", "\u22CD");
        html5Entities.put("bsolb", "\u29C5");
        html5Entities.put("bsol", "\\");
        html5Entities.put("bsolhsub", "\u27C8");
        html5Entities.put("bull", "\u2022");
        html5Entities.put("bullet", "\u2022");
        html5Entities.put("bump", "\u224E");
        html5Entities.put("bumpE", "\u2AAE");
        html5Entities.put("bumpe", "\u224F");
        html5Entities.put("Bumpeq", "\u224E");
        html5Entities.put("bumpeq", "\u224F");
        html5Entities.put("Cacute", "\u0106");
        html5Entities.put("cacute", "\u0107");
        html5Entities.put("capand", "\u2A44");
        html5Entities.put("capbrcup", "\u2A49");
        html5Entities.put("capcap", "\u2A4B");
        html5Entities.put("cap", "\u2229");
        html5Entities.put("Cap", "\u22D2");
        html5Entities.put("capcup", "\u2A47");
        html5Entities.put("capdot", "\u2A40");
        html5Entities.put("CapitalDifferentialD", "\u2145");
        html5Entities.put("caps", "\u2229\uFE00");
        html5Entities.put("caret", "\u2041");
        html5Entities.put("caron", "\u02C7");
        html5Entities.put("Cayleys", "\u212D");
        html5Entities.put("ccaps", "\u2A4D");
        html5Entities.put("Ccaron", "\u010C");
        html5Entities.put("ccaron", "\u010D");
        html5Entities.put("Ccedil", "\u00C7");
        html5Entities.put("ccedil", "\u00E7");
        html5Entities.put("Ccirc", "\u0108");
        html5Entities.put("ccirc", "\u0109");
        html5Entities.put("Cconint", "\u2230");
        html5Entities.put("ccups", "\u2A4C");
        html5Entities.put("ccupssm", "\u2A50");
        html5Entities.put("Cdot", "\u010A");
        html5Entities.put("cdot", "\u010B");
        html5Entities.put("cedil", "\u00B8");
        html5Entities.put("Cedilla", "\u00B8");
        html5Entities.put("cemptyv", "\u29B2");
        html5Entities.put("cent", "\u00A2");
        html5Entities.put("centerdot", "\u00B7");
        html5Entities.put("CenterDot", "\u00B7");
        html5Entities.put("cfr", "\uD835\uDD20");
        html5Entities.put("Cfr", "\u212D");
        html5Entities.put("CHcy", "\u0427");
        html5Entities.put("chcy", "\u0447");
        html5Entities.put("check", "\u2713");
        html5Entities.put("checkmark", "\u2713");
        html5Entities.put("Chi", "\u03A7");
        html5Entities.put("chi", "\u03C7");
        html5Entities.put("circ", "\u02C6");
        html5Entities.put("circeq", "\u2257");
        html5Entities.put("circlearrowleft", "\u21BA");
        html5Entities.put("circlearrowright", "\u21BB");
        html5Entities.put("circledast", "\u229B");
        html5Entities.put("circledcirc", "\u229A");
        html5Entities.put("circleddash", "\u229D");
        html5Entities.put("CircleDot", "\u2299");
        html5Entities.put("circledR", "\u00AE");
        html5Entities.put("circledS", "\u24C8");
        html5Entities.put("CircleMinus", "\u2296");
        html5Entities.put("CirclePlus", "\u2295");
        html5Entities.put("CircleTimes", "\u2297");
        html5Entities.put("cir", "\u25CB");
        html5Entities.put("cirE", "\u29C3");
        html5Entities.put("cire", "\u2257");
        html5Entities.put("cirfnint", "\u2A10");
        html5Entities.put("cirmid", "\u2AEF");
        html5Entities.put("cirscir", "\u29C2");
        html5Entities.put("ClockwiseContourIntegral", "\u2232");
        html5Entities.put("CloseCurlyDoubleQuote", "\u201D");
        html5Entities.put("CloseCurlyQuote", "\u2019");
        html5Entities.put("clubs", "\u2663");
        html5Entities.put("clubsuit", "\u2663");
        html5Entities.put("colon", "\u003A");
        html5Entities.put("Colon", "\u2237");
        html5Entities.put("Colone", "\u2A74");
        html5Entities.put("colone", "\u2254");
        html5Entities.put("coloneq", "\u2254");
        html5Entities.put("comma", "\u002C");
        html5Entities.put("commat", "\u0040");
        html5Entities.put("comp", "\u2201");
        html5Entities.put("compfn", "\u2218");
        html5Entities.put("complement", "\u2201");
        html5Entities.put("complexes", "\u2102");
        html5Entities.put("cong", "\u2245");
        html5Entities.put("congdot", "\u2A6D");
        html5Entities.put("Congruent", "\u2261");
        html5Entities.put("conint", "\u222E");
        html5Entities.put("Conint", "\u222F");
        html5Entities.put("ContourIntegral", "\u222E");
        html5Entities.put("copf", "\uD835\uDD54");
        html5Entities.put("Copf", "\u2102");
        html5Entities.put("coprod", "\u2210");
        html5Entities.put("Coproduct", "\u2210");
        html5Entities.put("copy", "\u00A9");
        html5Entities.put("COPY", "\u00A9");
        html5Entities.put("copysr", "\u2117");
        html5Entities.put("CounterClockwiseContourIntegral", "\u2233");
        html5Entities.put("crarr", "\u21B5");
        html5Entities.put("cross", "\u2717");
        html5Entities.put("Cross", "\u2A2F");
        html5Entities.put("Cscr", "\uD835\uDC9E");
        html5Entities.put("cscr", "\uD835\uDCB8");
        html5Entities.put("csub", "\u2ACF");
        html5Entities.put("csube", "\u2AD1");
        html5Entities.put("csup", "\u2AD0");
        html5Entities.put("csupe", "\u2AD2");
        html5Entities.put("ctdot", "\u22EF");
        html5Entities.put("cudarrl", "\u2938");
        html5Entities.put("cudarrr", "\u2935");
        html5Entities.put("cuepr", "\u22DE");
        html5Entities.put("cuesc", "\u22DF");
        html5Entities.put("cularr", "\u21B6");
        html5Entities.put("cularrp", "\u293D");
        html5Entities.put("cupbrcap", "\u2A48");
        html5Entities.put("cupcap", "\u2A46");
        html5Entities.put("CupCap", "\u224D");
        html5Entities.put("cup", "\u222A");
        html5Entities.put("Cup", "\u22D3");
        html5Entities.put("cupcup", "\u2A4A");
        html5Entities.put("cupdot", "\u228D");
        html5Entities.put("cupor", "\u2A45");
        html5Entities.put("cups", "\u222A\uFE00");
        html5Entities.put("curarr", "\u21B7");
        html5Entities.put("curarrm", "\u293C");
        html5Entities.put("curlyeqprec", "\u22DE");
        html5Entities.put("curlyeqsucc", "\u22DF");
        html5Entities.put("curlyvee", "\u22CE");
        html5Entities.put("curlywedge", "\u22CF");
        html5Entities.put("curren", "\u00A4");
        html5Entities.put("curvearrowleft", "\u21B6");
        html5Entities.put("curvearrowright", "\u21B7");
        html5Entities.put("cuvee", "\u22CE");
        html5Entities.put("cuwed", "\u22CF");
        html5Entities.put("cwconint", "\u2232");
        html5Entities.put("cwint", "\u2231");
        html5Entities.put("cylcty", "\u232D");
        html5Entities.put("dagger", "\u2020");
        html5Entities.put("Dagger", "\u2021");
        html5Entities.put("daleth", "\u2138");
        html5Entities.put("darr", "\u2193");
        html5Entities.put("Darr", "\u21A1");
        html5Entities.put("dArr", "\u21D3");
        html5Entities.put("dash", "\u2010");
        html5Entities.put("Dashv", "\u2AE4");
        html5Entities.put("dashv", "\u22A3");
        html5Entities.put("dbkarow", "\u290F");
        html5Entities.put("dblac", "\u02DD");
        html5Entities.put("Dcaron", "\u010E");
        html5Entities.put("dcaron", "\u010F");
        html5Entities.put("Dcy", "\u0414");
        html5Entities.put("dcy", "\u0434");
        html5Entities.put("ddagger", "\u2021");
        html5Entities.put("ddarr", "\u21CA");
        html5Entities.put("DD", "\u2145");
        html5Entities.put("dd", "\u2146");
        html5Entities.put("DDotrahd", "\u2911");
        html5Entities.put("ddotseq", "\u2A77");
        html5Entities.put("deg", "\u00B0");
        html5Entities.put("Del", "\u2207");
        html5Entities.put("Delta", "\u0394");
        html5Entities.put("delta", "\u03B4");
        html5Entities.put("demptyv", "\u29B1");
        html5Entities.put("dfisht", "\u297F");
        html5Entities.put("Dfr", "\uD835\uDD07");
        html5Entities.put("dfr", "\uD835\uDD21");
        html5Entities.put("dHar", "\u2965");
        html5Entities.put("dharl", "\u21C3");
        html5Entities.put("dharr", "\u21C2");
        html5Entities.put("DiacriticalAcute", "\u00B4");
        html5Entities.put("DiacriticalDot", "\u02D9");
        html5Entities.put("DiacriticalDoubleAcute", "\u02DD");
        html5Entities.put("DiacriticalGrave", "\u0060");
        html5Entities.put("DiacriticalTilde", "\u02DC");
        html5Entities.put("diam", "\u22C4");
        html5Entities.put("diamond", "\u22C4");
        html5Entities.put("Diamond", "\u22C4");
        html5Entities.put("diamondsuit", "\u2666");
        html5Entities.put("diams", "\u2666");
        html5Entities.put("die", "\u00A8");
        html5Entities.put("DifferentialD", "\u2146");
        html5Entities.put("digamma", "\u03DD");
        html5Entities.put("disin", "\u22F2");
        html5Entities.put("div", "\u00F7");
        html5Entities.put("divide", "\u00F7");
        html5Entities.put("divideontimes", "\u22C7");
        html5Entities.put("divonx", "\u22C7");
        html5Entities.put("DJcy", "\u0402");
        html5Entities.put("djcy", "\u0452");
        html5Entities.put("dlcorn", "\u231E");
        html5Entities.put("dlcrop", "\u230D");
        html5Entities.put("dollar", "\u0024");
        html5Entities.put("Dopf", "\uD835\uDD3B");
        html5Entities.put("dopf", "\uD835\uDD55");
        html5Entities.put("Dot", "\u00A8");
        html5Entities.put("dot", "\u02D9");
        html5Entities.put("DotDot", "\u20DC");
        html5Entities.put("doteq", "\u2250");
        html5Entities.put("doteqdot", "\u2251");
        html5Entities.put("DotEqual", "\u2250");
        html5Entities.put("dotminus", "\u2238");
        html5Entities.put("dotplus", "\u2214");
        html5Entities.put("dotsquare", "\u22A1");
        html5Entities.put("doublebarwedge", "\u2306");
        html5Entities.put("DoubleContourIntegral", "\u222F");
        html5Entities.put("DoubleDot", "\u00A8");
        html5Entities.put("DoubleDownArrow", "\u21D3");
        html5Entities.put("DoubleLeftArrow", "\u21D0");
        html5Entities.put("DoubleLeftRightArrow", "\u21D4");
        html5Entities.put("DoubleLeftTee", "\u2AE4");
        html5Entities.put("DoubleLongLeftArrow", "\u27F8");
        html5Entities.put("DoubleLongLeftRightArrow", "\u27FA");
        html5Entities.put("DoubleLongRightArrow", "\u27F9");
        html5Entities.put("DoubleRightArrow", "\u21D2");
        html5Entities.put("DoubleRightTee", "\u22A8");
        html5Entities.put("DoubleUpArrow", "\u21D1");
        html5Entities.put("DoubleUpDownArrow", "\u21D5");
        html5Entities.put("DoubleVerticalBar", "\u2225");
        html5Entities.put("DownArrowBar", "\u2913");
        html5Entities.put("downarrow", "\u2193");
        html5Entities.put("DownArrow", "\u2193");
        html5Entities.put("Downarrow", "\u21D3");
        html5Entities.put("DownArrowUpArrow", "\u21F5");
        html5Entities.put("DownBreve", "\u0311");
        html5Entities.put("downdownarrows", "\u21CA");
        html5Entities.put("downharpoonleft", "\u21C3");
        html5Entities.put("downharpoonright", "\u21C2");
        html5Entities.put("DownLeftRightVector", "\u2950");
        html5Entities.put("DownLeftTeeVector", "\u295E");
        html5Entities.put("DownLeftVectorBar", "\u2956");
        html5Entities.put("DownLeftVector", "\u21BD");
        html5Entities.put("DownRightTeeVector", "\u295F");
        html5Entities.put("DownRightVectorBar", "\u2957");
        html5Entities.put("DownRightVector", "\u21C1");
        html5Entities.put("DownTeeArrow", "\u21A7");
        html5Entities.put("DownTee", "\u22A4");
        html5Entities.put("drbkarow", "\u2910");
        html5Entities.put("drcorn", "\u231F");
        html5Entities.put("drcrop", "\u230C");
        html5Entities.put("Dscr", "\uD835\uDC9F");
        html5Entities.put("dscr", "\uD835\uDCB9");
        html5Entities.put("DScy", "\u0405");
        html5Entities.put("dscy", "\u0455");
        html5Entities.put("dsol", "\u29F6");
        html5Entities.put("Dstrok", "\u0110");
        html5Entities.put("dstrok", "\u0111");
        html5Entities.put("dtdot", "\u22F1");
        html5Entities.put("dtri", "\u25BF");
        html5Entities.put("dtrif", "\u25BE");
        html5Entities.put("duarr", "\u21F5");
        html5Entities.put("duhar", "\u296F");
        html5Entities.put("dwangle", "\u29A6");
        html5Entities.put("DZcy", "\u040F");
        html5Entities.put("dzcy", "\u045F");
        html5Entities.put("dzigrarr", "\u27FF");
        html5Entities.put("Eacute", "\u00C9");
        html5Entities.put("eacute", "\u00E9");
        html5Entities.put("easter", "\u2A6E");
        html5Entities.put("Ecaron", "\u011A");
        html5Entities.put("ecaron", "\u011B");
        html5Entities.put("Ecirc", "\u00CA");
        html5Entities.put("ecirc", "\u00EA");
        html5Entities.put("ecir", "\u2256");
        html5Entities.put("ecolon", "\u2255");
        html5Entities.put("Ecy", "\u042D");
        html5Entities.put("ecy", "\u044D");
        html5Entities.put("eDDot", "\u2A77");
        html5Entities.put("Edot", "\u0116");
        html5Entities.put("edot", "\u0117");
        html5Entities.put("eDot", "\u2251");
        html5Entities.put("ee", "\u2147");
        html5Entities.put("efDot", "\u2252");
        html5Entities.put("Efr", "\uD835\uDD08");
        html5Entities.put("efr", "\uD835\uDD22");
        html5Entities.put("eg", "\u2A9A");
        html5Entities.put("Egrave", "\u00C8");
        html5Entities.put("egrave", "\u00E8");
        html5Entities.put("egs", "\u2A96");
        html5Entities.put("egsdot", "\u2A98");
        html5Entities.put("el", "\u2A99");
        html5Entities.put("Element", "\u2208");
        html5Entities.put("elinters", "\u23E7");
        html5Entities.put("ell", "\u2113");
        html5Entities.put("els", "\u2A95");
        html5Entities.put("elsdot", "\u2A97");
        html5Entities.put("Emacr", "\u0112");
        html5Entities.put("emacr", "\u0113");
        html5Entities.put("empty", "\u2205");
        html5Entities.put("emptyset", "\u2205");
        html5Entities.put("EmptySmallSquare", "\u25FB");
        html5Entities.put("emptyv", "\u2205");
        html5Entities.put("EmptyVerySmallSquare", "\u25AB");
        html5Entities.put("emsp13", "\u2004");
        html5Entities.put("emsp14", "\u2005");
        html5Entities.put("emsp", "\u2003");
        html5Entities.put("ENG", "\u014A");
        html5Entities.put("eng", "\u014B");
        html5Entities.put("ensp", "\u2002");
        html5Entities.put("Eogon", "\u0118");
        html5Entities.put("eogon", "\u0119");
        html5Entities.put("Eopf", "\uD835\uDD3C");
        html5Entities.put("eopf", "\uD835\uDD56");
        html5Entities.put("epar", "\u22D5");
        html5Entities.put("eparsl", "\u29E3");
        html5Entities.put("eplus", "\u2A71");
        html5Entities.put("epsi", "\u03B5");
        html5Entities.put("Epsilon", "\u0395");
        html5Entities.put("epsilon", "\u03B5");
        html5Entities.put("epsiv", "\u03F5");
        html5Entities.put("eqcirc", "\u2256");
        html5Entities.put("eqcolon", "\u2255");
        html5Entities.put("eqsim", "\u2242");
        html5Entities.put("eqslantgtr", "\u2A96");
        html5Entities.put("eqslantless", "\u2A95");
        html5Entities.put("Equal", "\u2A75");
        html5Entities.put("equals", "\u003D");
        html5Entities.put("EqualTilde", "\u2242");
        html5Entities.put("equest", "\u225F");
        html5Entities.put("Equilibrium", "\u21CC");
        html5Entities.put("equiv", "\u2261");
        html5Entities.put("equivDD", "\u2A78");
        html5Entities.put("eqvparsl", "\u29E5");
        html5Entities.put("erarr", "\u2971");
        html5Entities.put("erDot", "\u2253");
        html5Entities.put("escr", "\u212F");
        html5Entities.put("Escr", "\u2130");
        html5Entities.put("esdot", "\u2250");
        html5Entities.put("Esim", "\u2A73");
        html5Entities.put("esim", "\u2242");
        html5Entities.put("Eta", "\u0397");
        html5Entities.put("eta", "\u03B7");
        html5Entities.put("ETH", "\u00D0");
        html5Entities.put("eth", "\u00F0");
        html5Entities.put("Euml", "\u00CB");
        html5Entities.put("euml", "\u00EB");
        html5Entities.put("euro", "\u20AC");
        html5Entities.put("excl", "\u0021");
        html5Entities.put("exist", "\u2203");
        html5Entities.put("Exists", "\u2203");
        html5Entities.put("expectation", "\u2130");
        html5Entities.put("exponentiale", "\u2147");
        html5Entities.put("ExponentialE", "\u2147");
        html5Entities.put("fallingdotseq", "\u2252");
        html5Entities.put("Fcy", "\u0424");
        html5Entities.put("fcy", "\u0444");
        html5Entities.put("female", "\u2640");
        html5Entities.put("ffilig", "\uFB03");
        html5Entities.put("fflig", "\uFB00");
        html5Entities.put("ffllig", "\uFB04");
        html5Entities.put("Ffr", "\uD835\uDD09");
        html5Entities.put("ffr", "\uD835\uDD23");
        html5Entities.put("filig", "\uFB01");
        html5Entities.put("FilledSmallSquare", "\u25FC");
        html5Entities.put("FilledVerySmallSquare", "\u25AA");
        html5Entities.put("fjlig", "\u0066\u006A");
        html5Entities.put("flat", "\u266D");
        html5Entities.put("fllig", "\uFB02");
        html5Entities.put("fltns", "\u25B1");
        html5Entities.put("fnof", "\u0192");
        html5Entities.put("Fopf", "\uD835\uDD3D");
        html5Entities.put("fopf", "\uD835\uDD57");
        html5Entities.put("forall", "\u2200");
        html5Entities.put("ForAll", "\u2200");
        html5Entities.put("fork", "\u22D4");
        html5Entities.put("forkv", "\u2AD9");
        html5Entities.put("Fouriertrf", "\u2131");
        html5Entities.put("fpartint", "\u2A0D");
        html5Entities.put("frac12", "\u00BD");
        html5Entities.put("frac13", "\u2153");
        html5Entities.put("frac14", "\u00BC");
        html5Entities.put("frac15", "\u2155");
        html5Entities.put("frac16", "\u2159");
        html5Entities.put("frac18", "\u215B");
        html5Entities.put("frac23", "\u2154");
        html5Entities.put("frac25", "\u2156");
        html5Entities.put("frac34", "\u00BE");
        html5Entities.put("frac35", "\u2157");
        html5Entities.put("frac38", "\u215C");
        html5Entities.put("frac45", "\u2158");
        html5Entities.put("frac56", "\u215A");
        html5Entities.put("frac58", "\u215D");
        html5Entities.put("frac78", "\u215E");
        html5Entities.put("frasl", "\u2044");
        html5Entities.put("frown", "\u2322");
        html5Entities.put("fscr", "\uD835\uDCBB");
        html5Entities.put("Fscr", "\u2131");
        html5Entities.put("gacute", "\u01F5");
        html5Entities.put("Gamma", "\u0393");
        html5Entities.put("gamma", "\u03B3");
        html5Entities.put("Gammad", "\u03DC");
        html5Entities.put("gammad", "\u03DD");
        html5Entities.put("gap", "\u2A86");
        html5Entities.put("Gbreve", "\u011E");
        html5Entities.put("gbreve", "\u011F");
        html5Entities.put("Gcedil", "\u0122");
        html5Entities.put("Gcirc", "\u011C");
        html5Entities.put("gcirc", "\u011D");
        html5Entities.put("Gcy", "\u0413");
        html5Entities.put("gcy", "\u0433");
        html5Entities.put("Gdot", "\u0120");
        html5Entities.put("gdot", "\u0121");
        html5Entities.put("ge", "\u2265");
        html5Entities.put("gE", "\u2267");
        html5Entities.put("gEl", "\u2A8C");
        html5Entities.put("gel", "\u22DB");
        html5Entities.put("geq", "\u2265");
        html5Entities.put("geqq", "\u2267");
        html5Entities.put("geqslant", "\u2A7E");
        html5Entities.put("gescc", "\u2AA9");
        html5Entities.put("ges", "\u2A7E");
        html5Entities.put("gesdot", "\u2A80");
        html5Entities.put("gesdoto", "\u2A82");
        html5Entities.put("gesdotol", "\u2A84");
        html5Entities.put("gesl", "\u22DB\uFE00");
        html5Entities.put("gesles", "\u2A94");
        html5Entities.put("Gfr", "\uD835\uDD0A");
        html5Entities.put("gfr", "\uD835\uDD24");
        html5Entities.put("gg", "\u226B");
        html5Entities.put("Gg", "\u22D9");
        html5Entities.put("ggg", "\u22D9");
        html5Entities.put("gimel", "\u2137");
        html5Entities.put("GJcy", "\u0403");
        html5Entities.put("gjcy", "\u0453");
        html5Entities.put("gla", "\u2AA5");
        html5Entities.put("gl", "\u2277");
        html5Entities.put("glE", "\u2A92");
        html5Entities.put("glj", "\u2AA4");
        html5Entities.put("gnap", "\u2A8A");
        html5Entities.put("gnapprox", "\u2A8A");
        html5Entities.put("gne", "\u2A88");
        html5Entities.put("gnE", "\u2269");
        html5Entities.put("gneq", "\u2A88");
        html5Entities.put("gneqq", "\u2269");
        html5Entities.put("gnsim", "\u22E7");
        html5Entities.put("Gopf", "\uD835\uDD3E");
        html5Entities.put("gopf", "\uD835\uDD58");
        html5Entities.put("grave", "\u0060");
        html5Entities.put("GreaterEqual", "\u2265");
        html5Entities.put("GreaterEqualLess", "\u22DB");
        html5Entities.put("GreaterFullEqual", "\u2267");
        html5Entities.put("GreaterGreater", "\u2AA2");
        html5Entities.put("GreaterLess", "\u2277");
        html5Entities.put("GreaterSlantEqual", "\u2A7E");
        html5Entities.put("GreaterTilde", "\u2273");
        html5Entities.put("Gscr", "\uD835\uDCA2");
        html5Entities.put("gscr", "\u210A");
        html5Entities.put("gsim", "\u2273");
        html5Entities.put("gsime", "\u2A8E");
        html5Entities.put("gsiml", "\u2A90");
        html5Entities.put("gtcc", "\u2AA7");
        html5Entities.put("gtcir", "\u2A7A");
        html5Entities.put("gt", "\u003E");
        html5Entities.put("GT", "\u003E");
        html5Entities.put("Gt", "\u226B");
        html5Entities.put("gtdot", "\u22D7");
        html5Entities.put("gtlPar", "\u2995");
        html5Entities.put("gtquest", "\u2A7C");
        html5Entities.put("gtrapprox", "\u2A86");
        html5Entities.put("gtrarr", "\u2978");
        html5Entities.put("gtrdot", "\u22D7");
        html5Entities.put("gtreqless", "\u22DB");
        html5Entities.put("gtreqqless", "\u2A8C");
        html5Entities.put("gtrless", "\u2277");
        html5Entities.put("gtrsim", "\u2273");
        html5Entities.put("gvertneqq", "\u2269\uFE00");
        html5Entities.put("gvnE", "\u2269\uFE00");
        html5Entities.put("Hacek", "\u02C7");
        html5Entities.put("hairsp", "\u200A");
        html5Entities.put("half", "\u00BD");
        html5Entities.put("hamilt", "\u210B");
        html5Entities.put("HARDcy", "\u042A");
        html5Entities.put("hardcy", "\u044A");
        html5Entities.put("harrcir", "\u2948");
        html5Entities.put("harr", "\u2194");
        html5Entities.put("hArr", "\u21D4");
        html5Entities.put("harrw", "\u21AD");
        html5Entities.put("Hat", "\u005E");
        html5Entities.put("hbar", "\u210F");
        html5Entities.put("Hcirc", "\u0124");
        html5Entities.put("hcirc", "\u0125");
        html5Entities.put("hearts", "\u2665");
        html5Entities.put("heartsuit", "\u2665");
        html5Entities.put("hellip", "\u2026");
        html5Entities.put("hercon", "\u22B9");
        html5Entities.put("hfr", "\uD835\uDD25");
        html5Entities.put("Hfr", "\u210C");
        html5Entities.put("HilbertSpace", "\u210B");
        html5Entities.put("hksearow", "\u2925");
        html5Entities.put("hkswarow", "\u2926");
        html5Entities.put("hoarr", "\u21FF");
        html5Entities.put("homtht", "\u223B");
        html5Entities.put("hookleftarrow", "\u21A9");
        html5Entities.put("hookrightarrow", "\u21AA");
        html5Entities.put("hopf", "\uD835\uDD59");
        html5Entities.put("Hopf", "\u210D");
        html5Entities.put("horbar", "\u2015");
        html5Entities.put("HorizontalLine", "\u2500");
        html5Entities.put("hscr", "\uD835\uDCBD");
        html5Entities.put("Hscr", "\u210B");
        html5Entities.put("hslash", "\u210F");
        html5Entities.put("Hstrok", "\u0126");
        html5Entities.put("hstrok", "\u0127");
        html5Entities.put("HumpDownHump", "\u224E");
        html5Entities.put("HumpEqual", "\u224F");
        html5Entities.put("hybull", "\u2043");
        html5Entities.put("hyphen", "\u2010");
        html5Entities.put("Iacute", "\u00CD");
        html5Entities.put("iacute", "\u00ED");
        html5Entities.put("ic", "\u2063");
        html5Entities.put("Icirc", "\u00CE");
        html5Entities.put("icirc", "\u00EE");
        html5Entities.put("Icy", "\u0418");
        html5Entities.put("icy", "\u0438");
        html5Entities.put("Idot", "\u0130");
        html5Entities.put("IEcy", "\u0415");
        html5Entities.put("iecy", "\u0435");
        html5Entities.put("iexcl", "\u00A1");
        html5Entities.put("iff", "\u21D4");
        html5Entities.put("ifr", "\uD835\uDD26");
        html5Entities.put("Ifr", "\u2111");
        html5Entities.put("Igrave", "\u00CC");
        html5Entities.put("igrave", "\u00EC");
        html5Entities.put("ii", "\u2148");
        html5Entities.put("iiiint", "\u2A0C");
        html5Entities.put("iiint", "\u222D");
        html5Entities.put("iinfin", "\u29DC");
        html5Entities.put("iiota", "\u2129");
        html5Entities.put("IJlig", "\u0132");
        html5Entities.put("ijlig", "\u0133");
        html5Entities.put("Imacr", "\u012A");
        html5Entities.put("imacr", "\u012B");
        html5Entities.put("image", "\u2111");
        html5Entities.put("ImaginaryI", "\u2148");
        html5Entities.put("imagline", "\u2110");
        html5Entities.put("imagpart", "\u2111");
        html5Entities.put("imath", "\u0131");
        html5Entities.put("Im", "\u2111");
        html5Entities.put("imof", "\u22B7");
        html5Entities.put("imped", "\u01B5");
        html5Entities.put("Implies", "\u21D2");
        html5Entities.put("incare", "\u2105");
        html5Entities.put("in", "\u2208");
        html5Entities.put("infin", "\u221E");
        html5Entities.put("infintie", "\u29DD");
        html5Entities.put("inodot", "\u0131");
        html5Entities.put("intcal", "\u22BA");
        html5Entities.put("int", "\u222B");
        html5Entities.put("Int", "\u222C");
        html5Entities.put("integers", "\u2124");
        html5Entities.put("Integral", "\u222B");
        html5Entities.put("intercal", "\u22BA");
        html5Entities.put("Intersection", "\u22C2");
        html5Entities.put("intlarhk", "\u2A17");
        html5Entities.put("intprod", "\u2A3C");
        html5Entities.put("InvisibleComma", "\u2063");
        html5Entities.put("InvisibleTimes", "\u2062");
        html5Entities.put("IOcy", "\u0401");
        html5Entities.put("iocy", "\u0451");
        html5Entities.put("Iogon", "\u012E");
        html5Entities.put("iogon", "\u012F");
        html5Entities.put("Iopf", "\uD835\uDD40");
        html5Entities.put("iopf", "\uD835\uDD5A");
        html5Entities.put("Iota", "\u0399");
        html5Entities.put("iota", "\u03B9");
        html5Entities.put("iprod", "\u2A3C");
        html5Entities.put("iquest", "\u00BF");
        html5Entities.put("iscr", "\uD835\uDCBE");
        html5Entities.put("Iscr", "\u2110");
        html5Entities.put("isin", "\u2208");
        html5Entities.put("isindot", "\u22F5");
        html5Entities.put("isinE", "\u22F9");
        html5Entities.put("isins", "\u22F4");
        html5Entities.put("isinsv", "\u22F3");
        html5Entities.put("isinv", "\u2208");
        html5Entities.put("it", "\u2062");
        html5Entities.put("Itilde", "\u0128");
        html5Entities.put("itilde", "\u0129");
        html5Entities.put("Iukcy", "\u0406");
        html5Entities.put("iukcy", "\u0456");
        html5Entities.put("Iuml", "\u00CF");
        html5Entities.put("iuml", "\u00EF");
        html5Entities.put("Jcirc", "\u0134");
        html5Entities.put("jcirc", "\u0135");
        html5Entities.put("Jcy", "\u0419");
        html5Entities.put("jcy", "\u0439");
        html5Entities.put("Jfr", "\uD835\uDD0D");
        html5Entities.put("jfr", "\uD835\uDD27");
        html5Entities.put("jmath", "\u0237");
        html5Entities.put("Jopf", "\uD835\uDD41");
        html5Entities.put("jopf", "\uD835\uDD5B");
        html5Entities.put("Jscr", "\uD835\uDCA5");
        html5Entities.put("jscr", "\uD835\uDCBF");
        html5Entities.put("Jsercy", "\u0408");
        html5Entities.put("jsercy", "\u0458");
        html5Entities.put("Jukcy", "\u0404");
        html5Entities.put("jukcy", "\u0454");
        html5Entities.put("Kappa", "\u039A");
        html5Entities.put("kappa", "\u03BA");
        html5Entities.put("kappav", "\u03F0");
        html5Entities.put("Kcedil", "\u0136");
        html5Entities.put("kcedil", "\u0137");
        html5Entities.put("Kcy", "\u041A");
        html5Entities.put("kcy", "\u043A");
        html5Entities.put("Kfr", "\uD835\uDD0E");
        html5Entities.put("kfr", "\uD835\uDD28");
        html5Entities.put("kgreen", "\u0138");
        html5Entities.put("KHcy", "\u0425");
        html5Entities.put("khcy", "\u0445");
        html5Entities.put("KJcy", "\u040C");
        html5Entities.put("kjcy", "\u045C");
        html5Entities.put("Kopf", "\uD835\uDD42");
        html5Entities.put("kopf", "\uD835\uDD5C");
        html5Entities.put("Kscr", "\uD835\uDCA6");
        html5Entities.put("kscr", "\uD835\uDCC0");
        html5Entities.put("lAarr", "\u21DA");
        html5Entities.put("Lacute", "\u0139");
        html5Entities.put("lacute", "\u013A");
        html5Entities.put("laemptyv", "\u29B4");
        html5Entities.put("lagran", "\u2112");
        html5Entities.put("Lambda", "\u039B");
        html5Entities.put("lambda", "\u03BB");
        html5Entities.put("lang", "\u27E8");
        html5Entities.put("Lang", "\u27EA");
        html5Entities.put("langd", "\u2991");
        html5Entities.put("langle", "\u27E8");
        html5Entities.put("lap", "\u2A85");
        html5Entities.put("Laplacetrf", "\u2112");
        html5Entities.put("laquo", "\u00AB");
        html5Entities.put("larrb", "\u21E4");
        html5Entities.put("larrbfs", "\u291F");
        html5Entities.put("larr", "\u2190");
        html5Entities.put("Larr", "\u219E");
        html5Entities.put("lArr", "\u21D0");
        html5Entities.put("larrfs", "\u291D");
        html5Entities.put("larrhk", "\u21A9");
        html5Entities.put("larrlp", "\u21AB");
        html5Entities.put("larrpl", "\u2939");
        html5Entities.put("larrsim", "\u2973");
        html5Entities.put("larrtl", "\u21A2");
        html5Entities.put("latail", "\u2919");
        html5Entities.put("lAtail", "\u291B");
        html5Entities.put("lat", "\u2AAB");
        html5Entities.put("late", "\u2AAD");
        html5Entities.put("lates", "\u2AAD\uFE00");
        html5Entities.put("lbarr", "\u290C");
        html5Entities.put("lBarr", "\u290E");
        html5Entities.put("lbbrk", "\u2772");
        html5Entities.put("lbrace", "\u007B");
        html5Entities.put("lbrack", "\u005B");
        html5Entities.put("lbrke", "\u298B");
        html5Entities.put("lbrksld", "\u298F");
        html5Entities.put("lbrkslu", "\u298D");
        html5Entities.put("Lcaron", "\u013D");
        html5Entities.put("lcaron", "\u013E");
        html5Entities.put("Lcedil", "\u013B");
        html5Entities.put("lcedil", "\u013C");
        html5Entities.put("lceil", "\u2308");
        html5Entities.put("lcub", "\u007B");
        html5Entities.put("Lcy", "\u041B");
        html5Entities.put("lcy", "\u043B");
        html5Entities.put("ldca", "\u2936");
        html5Entities.put("ldquo", "\u201C");
        html5Entities.put("ldquor", "\u201E");
        html5Entities.put("ldrdhar", "\u2967");
        html5Entities.put("ldrushar", "\u294B");
        html5Entities.put("ldsh", "\u21B2");
        html5Entities.put("le", "\u2264");
        html5Entities.put("lE", "\u2266");
        html5Entities.put("LeftAngleBracket", "\u27E8");
        html5Entities.put("LeftArrowBar", "\u21E4");
        html5Entities.put("leftarrow", "\u2190");
        html5Entities.put("LeftArrow", "\u2190");
        html5Entities.put("Leftarrow", "\u21D0");
        html5Entities.put("LeftArrowRightArrow", "\u21C6");
        html5Entities.put("leftarrowtail", "\u21A2");
        html5Entities.put("LeftCeiling", "\u2308");
        html5Entities.put("LeftDoubleBracket", "\u27E6");
        html5Entities.put("LeftDownTeeVector", "\u2961");
        html5Entities.put("LeftDownVectorBar", "\u2959");
        html5Entities.put("LeftDownVector", "\u21C3");
        html5Entities.put("LeftFloor", "\u230A");
        html5Entities.put("leftharpoondown", "\u21BD");
        html5Entities.put("leftharpoonup", "\u21BC");
        html5Entities.put("leftleftarrows", "\u21C7");
        html5Entities.put("leftrightarrow", "\u2194");
        html5Entities.put("LeftRightArrow", "\u2194");
        html5Entities.put("Leftrightarrow", "\u21D4");
        html5Entities.put("leftrightarrows", "\u21C6");
        html5Entities.put("leftrightharpoons", "\u21CB");
        html5Entities.put("leftrightsquigarrow", "\u21AD");
        html5Entities.put("LeftRightVector", "\u294E");
        html5Entities.put("LeftTeeArrow", "\u21A4");
        html5Entities.put("LeftTee", "\u22A3");
        html5Entities.put("LeftTeeVector", "\u295A");
        html5Entities.put("leftthreetimes", "\u22CB");
        html5Entities.put("LeftTriangleBar", "\u29CF");
        html5Entities.put("LeftTriangle", "\u22B2");
        html5Entities.put("LeftTriangleEqual", "\u22B4");
        html5Entities.put("LeftUpDownVector", "\u2951");
        html5Entities.put("LeftUpTeeVector", "\u2960");
        html5Entities.put("LeftUpVectorBar", "\u2958");
        html5Entities.put("LeftUpVector", "\u21BF");
        html5Entities.put("LeftVectorBar", "\u2952");
        html5Entities.put("LeftVector", "\u21BC");
        html5Entities.put("lEg", "\u2A8B");
        html5Entities.put("leg", "\u22DA");
        html5Entities.put("leq", "\u2264");
        html5Entities.put("leqq", "\u2266");
        html5Entities.put("leqslant", "\u2A7D");
        html5Entities.put("lescc", "\u2AA8");
        html5Entities.put("les", "\u2A7D");
        html5Entities.put("lesdot", "\u2A7F");
        html5Entities.put("lesdoto", "\u2A81");
        html5Entities.put("lesdotor", "\u2A83");
        html5Entities.put("lesg", "\u22DA\uFE00");
        html5Entities.put("lesges", "\u2A93");
        html5Entities.put("lessapprox", "\u2A85");
        html5Entities.put("lessdot", "\u22D6");
        html5Entities.put("lesseqgtr", "\u22DA");
        html5Entities.put("lesseqqgtr", "\u2A8B");
        html5Entities.put("LessEqualGreater", "\u22DA");
        html5Entities.put("LessFullEqual", "\u2266");
        html5Entities.put("LessGreater", "\u2276");
        html5Entities.put("lessgtr", "\u2276");
        html5Entities.put("LessLess", "\u2AA1");
        html5Entities.put("lesssim", "\u2272");
        html5Entities.put("LessSlantEqual", "\u2A7D");
        html5Entities.put("LessTilde", "\u2272");
        html5Entities.put("lfisht", "\u297C");
        html5Entities.put("lfloor", "\u230A");
        html5Entities.put("Lfr", "\uD835\uDD0F");
        html5Entities.put("lfr", "\uD835\uDD29");
        html5Entities.put("lg", "\u2276");
        html5Entities.put("lgE", "\u2A91");
        html5Entities.put("lHar", "\u2962");
        html5Entities.put("lhard", "\u21BD");
        html5Entities.put("lharu", "\u21BC");
        html5Entities.put("lharul", "\u296A");
        html5Entities.put("lhblk", "\u2584");
        html5Entities.put("LJcy", "\u0409");
        html5Entities.put("ljcy", "\u0459");
        html5Entities.put("llarr", "\u21C7");
        html5Entities.put("ll", "\u226A");
        html5Entities.put("Ll", "\u22D8");
        html5Entities.put("llcorner", "\u231E");
        html5Entities.put("Lleftarrow", "\u21DA");
        html5Entities.put("llhard", "\u296B");
        html5Entities.put("lltri", "\u25FA");
        html5Entities.put("Lmidot", "\u013F");
        html5Entities.put("lmidot", "\u0140");
        html5Entities.put("lmoustache", "\u23B0");
        html5Entities.put("lmoust", "\u23B0");
        html5Entities.put("lnap", "\u2A89");
        html5Entities.put("lnapprox", "\u2A89");
        html5Entities.put("lne", "\u2A87");
        html5Entities.put("lnE", "\u2268");
        html5Entities.put("lneq", "\u2A87");
        html5Entities.put("lneqq", "\u2268");
        html5Entities.put("lnsim", "\u22E6");
        html5Entities.put("loang", "\u27EC");
        html5Entities.put("loarr", "\u21FD");
        html5Entities.put("lobrk", "\u27E6");
        html5Entities.put("longleftarrow", "\u27F5");
        html5Entities.put("LongLeftArrow", "\u27F5");
        html5Entities.put("Longleftarrow", "\u27F8");
        html5Entities.put("longleftrightarrow", "\u27F7");
        html5Entities.put("LongLeftRightArrow", "\u27F7");
        html5Entities.put("Longleftrightarrow", "\u27FA");
        html5Entities.put("longmapsto", "\u27FC");
        html5Entities.put("longrightarrow", "\u27F6");
        html5Entities.put("LongRightArrow", "\u27F6");
        html5Entities.put("Longrightarrow", "\u27F9");
        html5Entities.put("looparrowleft", "\u21AB");
        html5Entities.put("looparrowright", "\u21AC");
        html5Entities.put("lopar", "\u2985");
        html5Entities.put("Lopf", "\uD835\uDD43");
        html5Entities.put("lopf", "\uD835\uDD5D");
        html5Entities.put("loplus", "\u2A2D");
        html5Entities.put("lotimes", "\u2A34");
        html5Entities.put("lowast", "\u2217");
        html5Entities.put("lowbar", "\u005F");
        html5Entities.put("LowerLeftArrow", "\u2199");
        html5Entities.put("LowerRightArrow", "\u2198");
        html5Entities.put("loz", "\u25CA");
        html5Entities.put("lozenge", "\u25CA");
        html5Entities.put("lozf", "\u29EB");
        html5Entities.put("lpar", "\u0028");
        html5Entities.put("lparlt", "\u2993");
        html5Entities.put("lrarr", "\u21C6");
        html5Entities.put("lrcorner", "\u231F");
        html5Entities.put("lrhar", "\u21CB");
        html5Entities.put("lrhard", "\u296D");
        html5Entities.put("lrm", "\u200E");
        html5Entities.put("lrtri", "\u22BF");
        html5Entities.put("lsaquo", "\u2039");
        html5Entities.put("lscr", "\uD835\uDCC1");
        html5Entities.put("Lscr", "\u2112");
        html5Entities.put("lsh", "\u21B0");
        html5Entities.put("Lsh", "\u21B0");
        html5Entities.put("lsim", "\u2272");
        html5Entities.put("lsime", "\u2A8D");
        html5Entities.put("lsimg", "\u2A8F");
        html5Entities.put("lsqb", "\u005B");
        html5Entities.put("lsquo", "\u2018");
        html5Entities.put("lsquor", "\u201A");
        html5Entities.put("Lstrok", "\u0141");
        html5Entities.put("lstrok", "\u0142");
        html5Entities.put("ltcc", "\u2AA6");
        html5Entities.put("ltcir", "\u2A79");
        html5Entities.put("lt", "\u003C");
        html5Entities.put("LT", "\u003C");
        html5Entities.put("Lt", "\u226A");
        html5Entities.put("ltdot", "\u22D6");
        html5Entities.put("lthree", "\u22CB");
        html5Entities.put("ltimes", "\u22C9");
        html5Entities.put("ltlarr", "\u2976");
        html5Entities.put("ltquest", "\u2A7B");
        html5Entities.put("ltri", "\u25C3");
        html5Entities.put("ltrie", "\u22B4");
        html5Entities.put("ltrif", "\u25C2");
        html5Entities.put("ltrPar", "\u2996");
        html5Entities.put("lurdshar", "\u294A");
        html5Entities.put("luruhar", "\u2966");
        html5Entities.put("lvertneqq", "\u2268\uFE00");
        html5Entities.put("lvnE", "\u2268\uFE00");
        html5Entities.put("macr", "\u00AF");
        html5Entities.put("male", "\u2642");
        html5Entities.put("malt", "\u2720");
        html5Entities.put("maltese", "\u2720");
        html5Entities.put("Map", "\u2905");
        html5Entities.put("map", "\u21A6");
        html5Entities.put("mapsto", "\u21A6");
        html5Entities.put("mapstodown", "\u21A7");
        html5Entities.put("mapstoleft", "\u21A4");
        html5Entities.put("mapstoup", "\u21A5");
        html5Entities.put("marker", "\u25AE");
        html5Entities.put("mcomma", "\u2A29");
        html5Entities.put("Mcy", "\u041C");
        html5Entities.put("mcy", "\u043C");
        html5Entities.put("mdash", "\u2014");
        html5Entities.put("mDDot", "\u223A");
        html5Entities.put("measuredangle", "\u2221");
        html5Entities.put("MediumSpace", "\u205F");
        html5Entities.put("Mellintrf", "\u2133");
        html5Entities.put("Mfr", "\uD835\uDD10");
        html5Entities.put("mfr", "\uD835\uDD2A");
        html5Entities.put("mho", "\u2127");
        html5Entities.put("micro", "\u00B5");
        html5Entities.put("midast", "\u002A");
        html5Entities.put("midcir", "\u2AF0");
        html5Entities.put("mid", "\u2223");
        html5Entities.put("middot", "\u00B7");
        html5Entities.put("minusb", "\u229F");
        html5Entities.put("minus", "\u2212");
        html5Entities.put("minusd", "\u2238");
        html5Entities.put("minusdu", "\u2A2A");
        html5Entities.put("MinusPlus", "\u2213");
        html5Entities.put("mlcp", "\u2ADB");
        html5Entities.put("mldr", "\u2026");
        html5Entities.put("mnplus", "\u2213");
        html5Entities.put("models", "\u22A7");
        html5Entities.put("Mopf", "\uD835\uDD44");
        html5Entities.put("mopf", "\uD835\uDD5E");
        html5Entities.put("mp", "\u2213");
        html5Entities.put("mscr", "\uD835\uDCC2");
        html5Entities.put("Mscr", "\u2133");
        html5Entities.put("mstpos", "\u223E");
        html5Entities.put("Mu", "\u039C");
        html5Entities.put("mu", "\u03BC");
        html5Entities.put("multimap", "\u22B8");
        html5Entities.put("mumap", "\u22B8");
        html5Entities.put("nabla", "\u2207");
        html5Entities.put("Nacute", "\u0143");
        html5Entities.put("nacute", "\u0144");
        html5Entities.put("nang", "\u2220\u20D2");
        html5Entities.put("nap", "\u2249");
        html5Entities.put("napE", "\u2A70\u0338");
        html5Entities.put("napid", "\u224B\u0338");
        html5Entities.put("napos", "\u0149");
        html5Entities.put("napprox", "\u2249");
        html5Entities.put("natural", "\u266E");
        html5Entities.put("naturals", "\u2115");
        html5Entities.put("natur", "\u266E");
        html5Entities.put("nbsp", "\u00A0");
        html5Entities.put("nbump", "\u224E\u0338");
        html5Entities.put("nbumpe", "\u224F\u0338");
        html5Entities.put("ncap", "\u2A43");
        html5Entities.put("Ncaron", "\u0147");
        html5Entities.put("ncaron", "\u0148");
        html5Entities.put("Ncedil", "\u0145");
        html5Entities.put("ncedil", "\u0146");
        html5Entities.put("ncong", "\u2247");
        html5Entities.put("ncongdot", "\u2A6D\u0338");
        html5Entities.put("ncup", "\u2A42");
        html5Entities.put("Ncy", "\u041D");
        html5Entities.put("ncy", "\u043D");
        html5Entities.put("ndash", "\u2013");
        html5Entities.put("nearhk", "\u2924");
        html5Entities.put("nearr", "\u2197");
        html5Entities.put("neArr", "\u21D7");
        html5Entities.put("nearrow", "\u2197");
        html5Entities.put("ne", "\u2260");
        html5Entities.put("nedot", "\u2250\u0338");
        html5Entities.put("NegativeMediumSpace", "\u200B");
        html5Entities.put("NegativeThickSpace", "\u200B");
        html5Entities.put("NegativeThinSpace", "\u200B");
        html5Entities.put("NegativeVeryThinSpace", "\u200B");
        html5Entities.put("nequiv", "\u2262");
        html5Entities.put("nesear", "\u2928");
        html5Entities.put("nesim", "\u2242\u0338");
        html5Entities.put("NestedGreaterGreater", "\u226B");
        html5Entities.put("NestedLessLess", "\u226A");
        html5Entities.put("NewLine", "\n");
        html5Entities.put("nexist", "\u2204");
        html5Entities.put("nexists", "\u2204");
        html5Entities.put("Nfr", "\uD835\uDD11");
        html5Entities.put("nfr", "\uD835\uDD2B");
        html5Entities.put("ngE", "\u2267\u0338");
        html5Entities.put("nge", "\u2271");
        html5Entities.put("ngeq", "\u2271");
        html5Entities.put("ngeqq", "\u2267\u0338");
        html5Entities.put("ngeqslant", "\u2A7E\u0338");
        html5Entities.put("nges", "\u2A7E\u0338");
        html5Entities.put("nGg", "\u22D9\u0338");
        html5Entities.put("ngsim", "\u2275");
        html5Entities.put("nGt", "\u226B\u20D2");
        html5Entities.put("ngt", "\u226F");
        html5Entities.put("ngtr", "\u226F");
        html5Entities.put("nGtv", "\u226B\u0338");
        html5Entities.put("nharr", "\u21AE");
        html5Entities.put("nhArr", "\u21CE");
        html5Entities.put("nhpar", "\u2AF2");
        html5Entities.put("ni", "\u220B");
        html5Entities.put("nis", "\u22FC");
        html5Entities.put("nisd", "\u22FA");
        html5Entities.put("niv", "\u220B");
        html5Entities.put("NJcy", "\u040A");
        html5Entities.put("njcy", "\u045A");
        html5Entities.put("nlarr", "\u219A");
        html5Entities.put("nlArr", "\u21CD");
        html5Entities.put("nldr", "\u2025");
        html5Entities.put("nlE", "\u2266\u0338");
        html5Entities.put("nle", "\u2270");
        html5Entities.put("nleftarrow", "\u219A");
        html5Entities.put("nLeftarrow", "\u21CD");
        html5Entities.put("nleftrightarrow", "\u21AE");
        html5Entities.put("nLeftrightarrow", "\u21CE");
        html5Entities.put("nleq", "\u2270");
        html5Entities.put("nleqq", "\u2266\u0338");
        html5Entities.put("nleqslant", "\u2A7D\u0338");
        html5Entities.put("nles", "\u2A7D\u0338");
        html5Entities.put("nless", "\u226E");
        html5Entities.put("nLl", "\u22D8\u0338");
        html5Entities.put("nlsim", "\u2274");
        html5Entities.put("nLt", "\u226A\u20D2");
        html5Entities.put("nlt", "\u226E");
        html5Entities.put("nltri", "\u22EA");
        html5Entities.put("nltrie", "\u22EC");
        html5Entities.put("nLtv", "\u226A\u0338");
        html5Entities.put("nmid", "\u2224");
        html5Entities.put("NoBreak", "\u2060");
        html5Entities.put("NonBreakingSpace", "\u00A0");
        html5Entities.put("nopf", "\uD835\uDD5F");
        html5Entities.put("Nopf", "\u2115");
        html5Entities.put("Not", "\u2AEC");
        html5Entities.put("not", "\u00AC");
        html5Entities.put("NotCongruent", "\u2262");
        html5Entities.put("NotCupCap", "\u226D");
        html5Entities.put("NotDoubleVerticalBar", "\u2226");
        html5Entities.put("NotElement", "\u2209");
        html5Entities.put("NotEqual", "\u2260");
        html5Entities.put("NotEqualTilde", "\u2242\u0338");
        html5Entities.put("NotExists", "\u2204");
        html5Entities.put("NotGreater", "\u226F");
        html5Entities.put("NotGreaterEqual", "\u2271");
        html5Entities.put("NotGreaterFullEqual", "\u2267\u0338");
        html5Entities.put("NotGreaterGreater", "\u226B\u0338");
        html5Entities.put("NotGreaterLess", "\u2279");
        html5Entities.put("NotGreaterSlantEqual", "\u2A7E\u0338");
        html5Entities.put("NotGreaterTilde", "\u2275");
        html5Entities.put("NotHumpDownHump", "\u224E\u0338");
        html5Entities.put("NotHumpEqual", "\u224F\u0338");
        html5Entities.put("notin", "\u2209");
        html5Entities.put("notindot", "\u22F5\u0338");
        html5Entities.put("notinE", "\u22F9\u0338");
        html5Entities.put("notinva", "\u2209");
        html5Entities.put("notinvb", "\u22F7");
        html5Entities.put("notinvc", "\u22F6");
        html5Entities.put("NotLeftTriangleBar", "\u29CF\u0338");
        html5Entities.put("NotLeftTriangle", "\u22EA");
        html5Entities.put("NotLeftTriangleEqual", "\u22EC");
        html5Entities.put("NotLess", "\u226E");
        html5Entities.put("NotLessEqual", "\u2270");
        html5Entities.put("NotLessGreater", "\u2278");
        html5Entities.put("NotLessLess", "\u226A\u0338");
        html5Entities.put("NotLessSlantEqual", "\u2A7D\u0338");
        html5Entities.put("NotLessTilde", "\u2274");
        html5Entities.put("NotNestedGreaterGreater", "\u2AA2\u0338");
        html5Entities.put("NotNestedLessLess", "\u2AA1\u0338");
        html5Entities.put("notni", "\u220C");
        html5Entities.put("notniva", "\u220C");
        html5Entities.put("notnivb", "\u22FE");
        html5Entities.put("notnivc", "\u22FD");
        html5Entities.put("NotPrecedes", "\u2280");
        html5Entities.put("NotPrecedesEqual", "\u2AAF\u0338");
        html5Entities.put("NotPrecedesSlantEqual", "\u22E0");
        html5Entities.put("NotReverseElement", "\u220C");
        html5Entities.put("NotRightTriangleBar", "\u29D0\u0338");
        html5Entities.put("NotRightTriangle", "\u22EB");
        html5Entities.put("NotRightTriangleEqual", "\u22ED");
        html5Entities.put("NotSquareSubset", "\u228F\u0338");
        html5Entities.put("NotSquareSubsetEqual", "\u22E2");
        html5Entities.put("NotSquareSuperset", "\u2290\u0338");
        html5Entities.put("NotSquareSupersetEqual", "\u22E3");
        html5Entities.put("NotSubset", "\u2282\u20D2");
        html5Entities.put("NotSubsetEqual", "\u2288");
        html5Entities.put("NotSucceeds", "\u2281");
        html5Entities.put("NotSucceedsEqual", "\u2AB0\u0338");
        html5Entities.put("NotSucceedsSlantEqual", "\u22E1");
        html5Entities.put("NotSucceedsTilde", "\u227F\u0338");
        html5Entities.put("NotSuperset", "\u2283\u20D2");
        html5Entities.put("NotSupersetEqual", "\u2289");
        html5Entities.put("NotTilde", "\u2241");
        html5Entities.put("NotTildeEqual", "\u2244");
        html5Entities.put("NotTildeFullEqual", "\u2247");
        html5Entities.put("NotTildeTilde", "\u2249");
        html5Entities.put("NotVerticalBar", "\u2224");
        html5Entities.put("nparallel", "\u2226");
        html5Entities.put("npar", "\u2226");
        html5Entities.put("nparsl", "\u2AFD\u20E5");
        html5Entities.put("npart", "\u2202\u0338");
        html5Entities.put("npolint", "\u2A14");
        html5Entities.put("npr", "\u2280");
        html5Entities.put("nprcue", "\u22E0");
        html5Entities.put("nprec", "\u2280");
        html5Entities.put("npreceq", "\u2AAF\u0338");
        html5Entities.put("npre", "\u2AAF\u0338");
        html5Entities.put("nrarrc", "\u2933\u0338");
        html5Entities.put("nrarr", "\u219B");
        html5Entities.put("nrArr", "\u21CF");
        html5Entities.put("nrarrw", "\u219D\u0338");
        html5Entities.put("nrightarrow", "\u219B");
        html5Entities.put("nRightarrow", "\u21CF");
        html5Entities.put("nrtri", "\u22EB");
        html5Entities.put("nrtrie", "\u22ED");
        html5Entities.put("nsc", "\u2281");
        html5Entities.put("nsccue", "\u22E1");
        html5Entities.put("nsce", "\u2AB0\u0338");
        html5Entities.put("Nscr", "\uD835\uDCA9");
        html5Entities.put("nscr", "\uD835\uDCC3");
        html5Entities.put("nshortmid", "\u2224");
        html5Entities.put("nshortparallel", "\u2226");
        html5Entities.put("nsim", "\u2241");
        html5Entities.put("nsime", "\u2244");
        html5Entities.put("nsimeq", "\u2244");
        html5Entities.put("nsmid", "\u2224");
        html5Entities.put("nspar", "\u2226");
        html5Entities.put("nsqsube", "\u22E2");
        html5Entities.put("nsqsupe", "\u22E3");
        html5Entities.put("nsub", "\u2284");
        html5Entities.put("nsubE", "\u2AC5\u0338");
        html5Entities.put("nsube", "\u2288");
        html5Entities.put("nsubset", "\u2282\u20D2");
        html5Entities.put("nsubseteq", "\u2288");
        html5Entities.put("nsubseteqq", "\u2AC5\u0338");
        html5Entities.put("nsucc", "\u2281");
        html5Entities.put("nsucceq", "\u2AB0\u0338");
        html5Entities.put("nsup", "\u2285");
        html5Entities.put("nsupE", "\u2AC6\u0338");
        html5Entities.put("nsupe", "\u2289");
        html5Entities.put("nsupset", "\u2283\u20D2");
        html5Entities.put("nsupseteq", "\u2289");
        html5Entities.put("nsupseteqq", "\u2AC6\u0338");
        html5Entities.put("ntgl", "\u2279");
        html5Entities.put("Ntilde", "\u00D1");
        html5Entities.put("ntilde", "\u00F1");
        html5Entities.put("ntlg", "\u2278");
        html5Entities.put("ntriangleleft", "\u22EA");
        html5Entities.put("ntrianglelefteq", "\u22EC");
        html5Entities.put("ntriangleright", "\u22EB");
        html5Entities.put("ntrianglerighteq", "\u22ED");
        html5Entities.put("Nu", "\u039D");
        html5Entities.put("nu", "\u03BD");
        html5Entities.put("num", "\u0023");
        html5Entities.put("numero", "\u2116");
        html5Entities.put("numsp", "\u2007");
        html5Entities.put("nvap", "\u224D\u20D2");
        html5Entities.put("nvdash", "\u22AC");
        html5Entities.put("nvDash", "\u22AD");
        html5Entities.put("nVdash", "\u22AE");
        html5Entities.put("nVDash", "\u22AF");
        html5Entities.put("nvge", "\u2265\u20D2");
        html5Entities.put("nvgt", "\u003E\u20D2");
        html5Entities.put("nvHarr", "\u2904");
        html5Entities.put("nvinfin", "\u29DE");
        html5Entities.put("nvlArr", "\u2902");
        html5Entities.put("nvle", "\u2264\u20D2");
        html5Entities.put("nvlt", "\u003C\u20D2");
        html5Entities.put("nvltrie", "\u22B4\u20D2");
        html5Entities.put("nvrArr", "\u2903");
        html5Entities.put("nvrtrie", "\u22B5\u20D2");
        html5Entities.put("nvsim", "\u223C\u20D2");
        html5Entities.put("nwarhk", "\u2923");
        html5Entities.put("nwarr", "\u2196");
        html5Entities.put("nwArr", "\u21D6");
        html5Entities.put("nwarrow", "\u2196");
        html5Entities.put("nwnear", "\u2927");
        html5Entities.put("Oacute", "\u00D3");
        html5Entities.put("oacute", "\u00F3");
        html5Entities.put("oast", "\u229B");
        html5Entities.put("Ocirc", "\u00D4");
        html5Entities.put("ocirc", "\u00F4");
        html5Entities.put("ocir", "\u229A");
        html5Entities.put("Ocy", "\u041E");
        html5Entities.put("ocy", "\u043E");
        html5Entities.put("odash", "\u229D");
        html5Entities.put("Odblac", "\u0150");
        html5Entities.put("odblac", "\u0151");
        html5Entities.put("odiv", "\u2A38");
        html5Entities.put("odot", "\u2299");
        html5Entities.put("odsold", "\u29BC");
        html5Entities.put("OElig", "\u0152");
        html5Entities.put("oelig", "\u0153");
        html5Entities.put("ofcir", "\u29BF");
        html5Entities.put("Ofr", "\uD835\uDD12");
        html5Entities.put("ofr", "\uD835\uDD2C");
        html5Entities.put("ogon", "\u02DB");
        html5Entities.put("Ograve", "\u00D2");
        html5Entities.put("ograve", "\u00F2");
        html5Entities.put("ogt", "\u29C1");
        html5Entities.put("ohbar", "\u29B5");
        html5Entities.put("ohm", "\u03A9");
        html5Entities.put("oint", "\u222E");
        html5Entities.put("olarr", "\u21BA");
        html5Entities.put("olcir", "\u29BE");
        html5Entities.put("olcross", "\u29BB");
        html5Entities.put("oline", "\u203E");
        html5Entities.put("olt", "\u29C0");
        html5Entities.put("Omacr", "\u014C");
        html5Entities.put("omacr", "\u014D");
        html5Entities.put("Omega", "\u03A9");
        html5Entities.put("omega", "\u03C9");
        html5Entities.put("Omicron", "\u039F");
        html5Entities.put("omicron", "\u03BF");
        html5Entities.put("omid", "\u29B6");
        html5Entities.put("ominus", "\u2296");
        html5Entities.put("Oopf", "\uD835\uDD46");
        html5Entities.put("oopf", "\uD835\uDD60");
        html5Entities.put("opar", "\u29B7");
        html5Entities.put("OpenCurlyDoubleQuote", "\u201C");
        html5Entities.put("OpenCurlyQuote", "\u2018");
        html5Entities.put("operp", "\u29B9");
        html5Entities.put("oplus", "\u2295");
        html5Entities.put("orarr", "\u21BB");
        html5Entities.put("Or", "\u2A54");
        html5Entities.put("or", "\u2228");
        html5Entities.put("ord", "\u2A5D");
        html5Entities.put("order", "\u2134");
        html5Entities.put("orderof", "\u2134");
        html5Entities.put("ordf", "\u00AA");
        html5Entities.put("ordm", "\u00BA");
        html5Entities.put("origof", "\u22B6");
        html5Entities.put("oror", "\u2A56");
        html5Entities.put("orslope", "\u2A57");
        html5Entities.put("orv", "\u2A5B");
        html5Entities.put("oS", "\u24C8");
        html5Entities.put("Oscr", "\uD835\uDCAA");
        html5Entities.put("oscr", "\u2134");
        html5Entities.put("Oslash", "\u00D8");
        html5Entities.put("oslash", "\u00F8");
        html5Entities.put("osol", "\u2298");
        html5Entities.put("Otilde", "\u00D5");
        html5Entities.put("otilde", "\u00F5");
        html5Entities.put("otimesas", "\u2A36");
        html5Entities.put("Otimes", "\u2A37");
        html5Entities.put("otimes", "\u2297");
        html5Entities.put("Ouml", "\u00D6");
        html5Entities.put("ouml", "\u00F6");
        html5Entities.put("ovbar", "\u233D");
        html5Entities.put("OverBar", "\u203E");
        html5Entities.put("OverBrace", "\u23DE");
        html5Entities.put("OverBracket", "\u23B4");
        html5Entities.put("OverParenthesis", "\u23DC");
        html5Entities.put("para", "\u00B6");
        html5Entities.put("parallel", "\u2225");
        html5Entities.put("par", "\u2225");
        html5Entities.put("parsim", "\u2AF3");
        html5Entities.put("parsl", "\u2AFD");
        html5Entities.put("part", "\u2202");
        html5Entities.put("PartialD", "\u2202");
        html5Entities.put("Pcy", "\u041F");
        html5Entities.put("pcy", "\u043F");
        html5Entities.put("percnt", "\u0025");
        html5Entities.put("period", "\u002E");
        html5Entities.put("permil", "\u2030");
        html5Entities.put("perp", "\u22A5");
        html5Entities.put("pertenk", "\u2031");
        html5Entities.put("Pfr", "\uD835\uDD13");
        html5Entities.put("pfr", "\uD835\uDD2D");
        html5Entities.put("Phi", "\u03A6");
        html5Entities.put("phi", "\u03C6");
        html5Entities.put("phiv", "\u03D5");
        html5Entities.put("phmmat", "\u2133");
        html5Entities.put("phone", "\u260E");
        html5Entities.put("Pi", "\u03A0");
        html5Entities.put("pi", "\u03C0");
        html5Entities.put("pitchfork", "\u22D4");
        html5Entities.put("piv", "\u03D6");
        html5Entities.put("planck", "\u210F");
        html5Entities.put("planckh", "\u210E");
        html5Entities.put("plankv", "\u210F");
        html5Entities.put("plusacir", "\u2A23");
        html5Entities.put("plusb", "\u229E");
        html5Entities.put("pluscir", "\u2A22");
        html5Entities.put("plus", "\u002B");
        html5Entities.put("plusdo", "\u2214");
        html5Entities.put("plusdu", "\u2A25");
        html5Entities.put("pluse", "\u2A72");
        html5Entities.put("PlusMinus", "\u00B1");
        html5Entities.put("plusmn", "\u00B1");
        html5Entities.put("plussim", "\u2A26");
        html5Entities.put("plustwo", "\u2A27");
        html5Entities.put("pm", "\u00B1");
        html5Entities.put("Poincareplane", "\u210C");
        html5Entities.put("pointint", "\u2A15");
        html5Entities.put("popf", "\uD835\uDD61");
        html5Entities.put("Popf", "\u2119");
        html5Entities.put("pound", "\u00A3");
        html5Entities.put("prap", "\u2AB7");
        html5Entities.put("Pr", "\u2ABB");
        html5Entities.put("pr", "\u227A");
        html5Entities.put("prcue", "\u227C");
        html5Entities.put("precapprox", "\u2AB7");
        html5Entities.put("prec", "\u227A");
        html5Entities.put("preccurlyeq", "\u227C");
        html5Entities.put("Precedes", "\u227A");
        html5Entities.put("PrecedesEqual", "\u2AAF");
        html5Entities.put("PrecedesSlantEqual", "\u227C");
        html5Entities.put("PrecedesTilde", "\u227E");
        html5Entities.put("preceq", "\u2AAF");
        html5Entities.put("precnapprox", "\u2AB9");
        html5Entities.put("precneqq", "\u2AB5");
        html5Entities.put("precnsim", "\u22E8");
        html5Entities.put("pre", "\u2AAF");
        html5Entities.put("prE", "\u2AB3");
        html5Entities.put("precsim", "\u227E");
        html5Entities.put("prime", "\u2032");
        html5Entities.put("Prime", "\u2033");
        html5Entities.put("primes", "\u2119");
        html5Entities.put("prnap", "\u2AB9");
        html5Entities.put("prnE", "\u2AB5");
        html5Entities.put("prnsim", "\u22E8");
        html5Entities.put("prod", "\u220F");
        html5Entities.put("Product", "\u220F");
        html5Entities.put("profalar", "\u232E");
        html5Entities.put("profline", "\u2312");
        html5Entities.put("profsurf", "\u2313");
        html5Entities.put("prop", "\u221D");
        html5Entities.put("Proportional", "\u221D");
        html5Entities.put("Proportion", "\u2237");
        html5Entities.put("propto", "\u221D");
        html5Entities.put("prsim", "\u227E");
        html5Entities.put("prurel", "\u22B0");
        html5Entities.put("Pscr", "\uD835\uDCAB");
        html5Entities.put("pscr", "\uD835\uDCC5");
        html5Entities.put("Psi", "\u03A8");
        html5Entities.put("psi", "\u03C8");
        html5Entities.put("puncsp", "\u2008");
        html5Entities.put("Qfr", "\uD835\uDD14");
        html5Entities.put("qfr", "\uD835\uDD2E");
        html5Entities.put("qint", "\u2A0C");
        html5Entities.put("qopf", "\uD835\uDD62");
        html5Entities.put("Qopf", "\u211A");
        html5Entities.put("qprime", "\u2057");
        html5Entities.put("Qscr", "\uD835\uDCAC");
        html5Entities.put("qscr", "\uD835\uDCC6");
        html5Entities.put("quaternions", "\u210D");
        html5Entities.put("quatint", "\u2A16");
        html5Entities.put("quest", "\u003F");
        html5Entities.put("questeq", "\u225F");
        html5Entities.put("quot", "\"");
        html5Entities.put("QUOT", "\"");
        html5Entities.put("rAarr", "\u21DB");
        html5Entities.put("race", "\u223D\u0331");
        html5Entities.put("Racute", "\u0154");
        html5Entities.put("racute", "\u0155");
        html5Entities.put("radic", "\u221A");
        html5Entities.put("raemptyv", "\u29B3");
        html5Entities.put("rang", "\u27E9");
        html5Entities.put("Rang", "\u27EB");
        html5Entities.put("rangd", "\u2992");
        html5Entities.put("range", "\u29A5");
        html5Entities.put("rangle", "\u27E9");
        html5Entities.put("raquo", "\u00BB");
        html5Entities.put("rarrap", "\u2975");
        html5Entities.put("rarrb", "\u21E5");
        html5Entities.put("rarrbfs", "\u2920");
        html5Entities.put("rarrc", "\u2933");
        html5Entities.put("rarr", "\u2192");
        html5Entities.put("Rarr", "\u21A0");
        html5Entities.put("rArr", "\u21D2");
        html5Entities.put("rarrfs", "\u291E");
        html5Entities.put("rarrhk", "\u21AA");
        html5Entities.put("rarrlp", "\u21AC");
        html5Entities.put("rarrpl", "\u2945");
        html5Entities.put("rarrsim", "\u2974");
        html5Entities.put("Rarrtl", "\u2916");
        html5Entities.put("rarrtl", "\u21A3");
        html5Entities.put("rarrw", "\u219D");
        html5Entities.put("ratail", "\u291A");
        html5Entities.put("rAtail", "\u291C");
        html5Entities.put("ratio", "\u2236");
        html5Entities.put("rationals", "\u211A");
        html5Entities.put("rbarr", "\u290D");
        html5Entities.put("rBarr", "\u290F");
        html5Entities.put("RBarr", "\u2910");
        html5Entities.put("rbbrk", "\u2773");
        html5Entities.put("rbrace", "\u007D");
        html5Entities.put("rbrack", "\u005D");
        html5Entities.put("rbrke", "\u298C");
        html5Entities.put("rbrksld", "\u298E");
        html5Entities.put("rbrkslu", "\u2990");
        html5Entities.put("Rcaron", "\u0158");
        html5Entities.put("rcaron", "\u0159");
        html5Entities.put("Rcedil", "\u0156");
        html5Entities.put("rcedil", "\u0157");
        html5Entities.put("rceil", "\u2309");
        html5Entities.put("rcub", "\u007D");
        html5Entities.put("Rcy", "\u0420");
        html5Entities.put("rcy", "\u0440");
        html5Entities.put("rdca", "\u2937");
        html5Entities.put("rdldhar", "\u2969");
        html5Entities.put("rdquo", "\u201D");
        html5Entities.put("rdquor", "\u201D");
        html5Entities.put("rdsh", "\u21B3");
        html5Entities.put("real", "\u211C");
        html5Entities.put("realine", "\u211B");
        html5Entities.put("realpart", "\u211C");
        html5Entities.put("reals", "\u211D");
        html5Entities.put("Re", "\u211C");
        html5Entities.put("rect", "\u25AD");
        html5Entities.put("reg", "\u00AE");
        html5Entities.put("REG", "\u00AE");
        html5Entities.put("ReverseElement", "\u220B");
        html5Entities.put("ReverseEquilibrium", "\u21CB");
        html5Entities.put("ReverseUpEquilibrium", "\u296F");
        html5Entities.put("rfisht", "\u297D");
        html5Entities.put("rfloor", "\u230B");
        html5Entities.put("rfr", "\uD835\uDD2F");
        html5Entities.put("Rfr", "\u211C");
        html5Entities.put("rHar", "\u2964");
        html5Entities.put("rhard", "\u21C1");
        html5Entities.put("rharu", "\u21C0");
        html5Entities.put("rharul", "\u296C");
        html5Entities.put("Rho", "\u03A1");
        html5Entities.put("rho", "\u03C1");
        html5Entities.put("rhov", "\u03F1");
        html5Entities.put("RightAngleBracket", "\u27E9");
        html5Entities.put("RightArrowBar", "\u21E5");
        html5Entities.put("rightarrow", "\u2192");
        html5Entities.put("RightArrow", "\u2192");
        html5Entities.put("Rightarrow", "\u21D2");
        html5Entities.put("RightArrowLeftArrow", "\u21C4");
        html5Entities.put("rightarrowtail", "\u21A3");
        html5Entities.put("RightCeiling", "\u2309");
        html5Entities.put("RightDoubleBracket", "\u27E7");
        html5Entities.put("RightDownTeeVector", "\u295D");
        html5Entities.put("RightDownVectorBar", "\u2955");
        html5Entities.put("RightDownVector", "\u21C2");
        html5Entities.put("RightFloor", "\u230B");
        html5Entities.put("rightharpoondown", "\u21C1");
        html5Entities.put("rightharpoonup", "\u21C0");
        html5Entities.put("rightleftarrows", "\u21C4");
        html5Entities.put("rightleftharpoons", "\u21CC");
        html5Entities.put("rightrightarrows", "\u21C9");
        html5Entities.put("rightsquigarrow", "\u219D");
        html5Entities.put("RightTeeArrow", "\u21A6");
        html5Entities.put("RightTee", "\u22A2");
        html5Entities.put("RightTeeVector", "\u295B");
        html5Entities.put("rightthreetimes", "\u22CC");
        html5Entities.put("RightTriangleBar", "\u29D0");
        html5Entities.put("RightTriangle", "\u22B3");
        html5Entities.put("RightTriangleEqual", "\u22B5");
        html5Entities.put("RightUpDownVector", "\u294F");
        html5Entities.put("RightUpTeeVector", "\u295C");
        html5Entities.put("RightUpVectorBar", "\u2954");
        html5Entities.put("RightUpVector", "\u21BE");
        html5Entities.put("RightVectorBar", "\u2953");
        html5Entities.put("RightVector", "\u21C0");
        html5Entities.put("ring", "\u02DA");
        html5Entities.put("risingdotseq", "\u2253");
        html5Entities.put("rlarr", "\u21C4");
        html5Entities.put("rlhar", "\u21CC");
        html5Entities.put("rlm", "\u200F");
        html5Entities.put("rmoustache", "\u23B1");
        html5Entities.put("rmoust", "\u23B1");
        html5Entities.put("rnmid", "\u2AEE");
        html5Entities.put("roang", "\u27ED");
        html5Entities.put("roarr", "\u21FE");
        html5Entities.put("robrk", "\u27E7");
        html5Entities.put("ropar", "\u2986");
        html5Entities.put("ropf", "\uD835\uDD63");
        html5Entities.put("Ropf", "\u211D");
        html5Entities.put("roplus", "\u2A2E");
        html5Entities.put("rotimes", "\u2A35");
        html5Entities.put("RoundImplies", "\u2970");
        html5Entities.put("rpar", "\u0029");
        html5Entities.put("rpargt", "\u2994");
        html5Entities.put("rppolint", "\u2A12");
        html5Entities.put("rrarr", "\u21C9");
        html5Entities.put("Rrightarrow", "\u21DB");
        html5Entities.put("rsaquo", "\u203A");
        html5Entities.put("rscr", "\uD835\uDCC7");
        html5Entities.put("Rscr", "\u211B");
        html5Entities.put("rsh", "\u21B1");
        html5Entities.put("Rsh", "\u21B1");
        html5Entities.put("rsqb", "\u005D");
        html5Entities.put("rsquo", "\u2019");
        html5Entities.put("rsquor", "\u2019");
        html5Entities.put("rthree", "\u22CC");
        html5Entities.put("rtimes", "\u22CA");
        html5Entities.put("rtri", "\u25B9");
        html5Entities.put("rtrie", "\u22B5");
        html5Entities.put("rtrif", "\u25B8");
        html5Entities.put("rtriltri", "\u29CE");
        html5Entities.put("RuleDelayed", "\u29F4");
        html5Entities.put("ruluhar", "\u2968");
        html5Entities.put("rx", "\u211E");
        html5Entities.put("Sacute", "\u015A");
        html5Entities.put("sacute", "\u015B");
        html5Entities.put("sbquo", "\u201A");
        html5Entities.put("scap", "\u2AB8");
        html5Entities.put("Scaron", "\u0160");
        html5Entities.put("scaron", "\u0161");
        html5Entities.put("Sc", "\u2ABC");
        html5Entities.put("sc", "\u227B");
        html5Entities.put("sccue", "\u227D");
        html5Entities.put("sce", "\u2AB0");
        html5Entities.put("scE", "\u2AB4");
        html5Entities.put("Scedil", "\u015E");
        html5Entities.put("scedil", "\u015F");
        html5Entities.put("Scirc", "\u015C");
        html5Entities.put("scirc", "\u015D");
        html5Entities.put("scnap", "\u2ABA");
        html5Entities.put("scnE", "\u2AB6");
        html5Entities.put("scnsim", "\u22E9");
        html5Entities.put("scpolint", "\u2A13");
        html5Entities.put("scsim", "\u227F");
        html5Entities.put("Scy", "\u0421");
        html5Entities.put("scy", "\u0441");
        html5Entities.put("sdotb", "\u22A1");
        html5Entities.put("sdot", "\u22C5");
        html5Entities.put("sdote", "\u2A66");
        html5Entities.put("searhk", "\u2925");
        html5Entities.put("searr", "\u2198");
        html5Entities.put("seArr", "\u21D8");
        html5Entities.put("searrow", "\u2198");
        html5Entities.put("sect", "\u00A7");
        html5Entities.put("semi", "\u003B");
        html5Entities.put("seswar", "\u2929");
        html5Entities.put("setminus", "\u2216");
        html5Entities.put("setmn", "\u2216");
        html5Entities.put("sext", "\u2736");
        html5Entities.put("Sfr", "\uD835\uDD16");
        html5Entities.put("sfr", "\uD835\uDD30");
        html5Entities.put("sfrown", "\u2322");
        html5Entities.put("sharp", "\u266F");
        html5Entities.put("SHCHcy", "\u0429");
        html5Entities.put("shchcy", "\u0449");
        html5Entities.put("SHcy", "\u0428");
        html5Entities.put("shcy", "\u0448");
        html5Entities.put("ShortDownArrow", "\u2193");
        html5Entities.put("ShortLeftArrow", "\u2190");
        html5Entities.put("shortmid", "\u2223");
        html5Entities.put("shortparallel", "\u2225");
        html5Entities.put("ShortRightArrow", "\u2192");
        html5Entities.put("ShortUpArrow", "\u2191");
        html5Entities.put("shy", "\u00AD");
        html5Entities.put("Sigma", "\u03A3");
        html5Entities.put("sigma", "\u03C3");
        html5Entities.put("sigmaf", "\u03C2");
        html5Entities.put("sigmav", "\u03C2");
        html5Entities.put("sim", "\u223C");
        html5Entities.put("simdot", "\u2A6A");
        html5Entities.put("sime", "\u2243");
        html5Entities.put("simeq", "\u2243");
        html5Entities.put("simg", "\u2A9E");
        html5Entities.put("simgE", "\u2AA0");
        html5Entities.put("siml", "\u2A9D");
        html5Entities.put("simlE", "\u2A9F");
        html5Entities.put("simne", "\u2246");
        html5Entities.put("simplus", "\u2A24");
        html5Entities.put("simrarr", "\u2972");
        html5Entities.put("slarr", "\u2190");
        html5Entities.put("SmallCircle", "\u2218");
        html5Entities.put("smallsetminus", "\u2216");
        html5Entities.put("smashp", "\u2A33");
        html5Entities.put("smeparsl", "\u29E4");
        html5Entities.put("smid", "\u2223");
        html5Entities.put("smile", "\u2323");
        html5Entities.put("smt", "\u2AAA");
        html5Entities.put("smte", "\u2AAC");
        html5Entities.put("smtes", "\u2AAC\uFE00");
        html5Entities.put("SOFTcy", "\u042C");
        html5Entities.put("softcy", "\u044C");
        html5Entities.put("solbar", "\u233F");
        html5Entities.put("solb", "\u29C4");
        html5Entities.put("sol", "\u002F");
        html5Entities.put("Sopf", "\uD835\uDD4A");
        html5Entities.put("sopf", "\uD835\uDD64");
        html5Entities.put("spades", "\u2660");
        html5Entities.put("spadesuit", "\u2660");
        html5Entities.put("spar", "\u2225");
        html5Entities.put("sqcap", "\u2293");
        html5Entities.put("sqcaps", "\u2293\uFE00");
        html5Entities.put("sqcup", "\u2294");
        html5Entities.put("sqcups", "\u2294\uFE00");
        html5Entities.put("Sqrt", "\u221A");
        html5Entities.put("sqsub", "\u228F");
        html5Entities.put("sqsube", "\u2291");
        html5Entities.put("sqsubset", "\u228F");
        html5Entities.put("sqsubseteq", "\u2291");
        html5Entities.put("sqsup", "\u2290");
        html5Entities.put("sqsupe", "\u2292");
        html5Entities.put("sqsupset", "\u2290");
        html5Entities.put("sqsupseteq", "\u2292");
        html5Entities.put("square", "\u25A1");
        html5Entities.put("Square", "\u25A1");
        html5Entities.put("SquareIntersection", "\u2293");
        html5Entities.put("SquareSubset", "\u228F");
        html5Entities.put("SquareSubsetEqual", "\u2291");
        html5Entities.put("SquareSuperset", "\u2290");
        html5Entities.put("SquareSupersetEqual", "\u2292");
        html5Entities.put("SquareUnion", "\u2294");
        html5Entities.put("squarf", "\u25AA");
        html5Entities.put("squ", "\u25A1");
        html5Entities.put("squf", "\u25AA");
        html5Entities.put("srarr", "\u2192");
        html5Entities.put("Sscr", "\uD835\uDCAE");
        html5Entities.put("sscr", "\uD835\uDCC8");
        html5Entities.put("ssetmn", "\u2216");
        html5Entities.put("ssmile", "\u2323");
        html5Entities.put("sstarf", "\u22C6");
        html5Entities.put("Star", "\u22C6");
        html5Entities.put("star", "\u2606");
        html5Entities.put("starf", "\u2605");
        html5Entities.put("straightepsilon", "\u03F5");
        html5Entities.put("straightphi", "\u03D5");
        html5Entities.put("strns", "\u00AF");
        html5Entities.put("sub", "\u2282");
        html5Entities.put("Sub", "\u22D0");
        html5Entities.put("subdot", "\u2ABD");
        html5Entities.put("subE", "\u2AC5");
        html5Entities.put("sube", "\u2286");
        html5Entities.put("subedot", "\u2AC3");
        html5Entities.put("submult", "\u2AC1");
        html5Entities.put("subnE", "\u2ACB");
        html5Entities.put("subne", "\u228A");
        html5Entities.put("subplus", "\u2ABF");
        html5Entities.put("subrarr", "\u2979");
        html5Entities.put("subset", "\u2282");
        html5Entities.put("Subset", "\u22D0");
        html5Entities.put("subseteq", "\u2286");
        html5Entities.put("subseteqq", "\u2AC5");
        html5Entities.put("SubsetEqual", "\u2286");
        html5Entities.put("subsetneq", "\u228A");
        html5Entities.put("subsetneqq", "\u2ACB");
        html5Entities.put("subsim", "\u2AC7");
        html5Entities.put("subsub", "\u2AD5");
        html5Entities.put("subsup", "\u2AD3");
        html5Entities.put("succapprox", "\u2AB8");
        html5Entities.put("succ", "\u227B");
        html5Entities.put("succcurlyeq", "\u227D");
        html5Entities.put("Succeeds", "\u227B");
        html5Entities.put("SucceedsEqual", "\u2AB0");
        html5Entities.put("SucceedsSlantEqual", "\u227D");
        html5Entities.put("SucceedsTilde", "\u227F");
        html5Entities.put("succeq", "\u2AB0");
        html5Entities.put("succnapprox", "\u2ABA");
        html5Entities.put("succneqq", "\u2AB6");
        html5Entities.put("succnsim", "\u22E9");
        html5Entities.put("succsim", "\u227F");
        html5Entities.put("SuchThat", "\u220B");
        html5Entities.put("sum", "\u2211");
        html5Entities.put("Sum", "\u2211");
        html5Entities.put("sung", "\u266A");
        html5Entities.put("sup1", "\u00B9");
        html5Entities.put("sup2", "\u00B2");
        html5Entities.put("sup3", "\u00B3");
        html5Entities.put("sup", "\u2283");
        html5Entities.put("Sup", "\u22D1");
        html5Entities.put("supdot", "\u2ABE");
        html5Entities.put("supdsub", "\u2AD8");
        html5Entities.put("supE", "\u2AC6");
        html5Entities.put("supe", "\u2287");
        html5Entities.put("supedot", "\u2AC4");
        html5Entities.put("Superset", "\u2283");
        html5Entities.put("SupersetEqual", "\u2287");
        html5Entities.put("suphsol", "\u27C9");
        html5Entities.put("suphsub", "\u2AD7");
        html5Entities.put("suplarr", "\u297B");
        html5Entities.put("supmult", "\u2AC2");
        html5Entities.put("supnE", "\u2ACC");
        html5Entities.put("supne", "\u228B");
        html5Entities.put("supplus", "\u2AC0");
        html5Entities.put("supset", "\u2283");
        html5Entities.put("Supset", "\u22D1");
        html5Entities.put("supseteq", "\u2287");
        html5Entities.put("supseteqq", "\u2AC6");
        html5Entities.put("supsetneq", "\u228B");
        html5Entities.put("supsetneqq", "\u2ACC");
        html5Entities.put("supsim", "\u2AC8");
        html5Entities.put("supsub", "\u2AD4");
        html5Entities.put("supsup", "\u2AD6");
        html5Entities.put("swarhk", "\u2926");
        html5Entities.put("swarr", "\u2199");
        html5Entities.put("swArr", "\u21D9");
        html5Entities.put("swarrow", "\u2199");
        html5Entities.put("swnwar", "\u292A");
        html5Entities.put("szlig", "\u00DF");
        html5Entities.put("Tab", "\u0009");
        html5Entities.put("target", "\u2316");
        html5Entities.put("Tau", "\u03A4");
        html5Entities.put("tau", "\u03C4");
        html5Entities.put("tbrk", "\u23B4");
        html5Entities.put("Tcaron", "\u0164");
        html5Entities.put("tcaron", "\u0165");
        html5Entities.put("Tcedil", "\u0162");
        html5Entities.put("tcedil", "\u0163");
        html5Entities.put("Tcy", "\u0422");
        html5Entities.put("tcy", "\u0442");
        html5Entities.put("tdot", "\u20DB");
        html5Entities.put("telrec", "\u2315");
        html5Entities.put("Tfr", "\uD835\uDD17");
        html5Entities.put("tfr", "\uD835\uDD31");
        html5Entities.put("there4", "\u2234");
        html5Entities.put("therefore", "\u2234");
        html5Entities.put("Therefore", "\u2234");
        html5Entities.put("Theta", "\u0398");
        html5Entities.put("theta", "\u03B8");
        html5Entities.put("thetasym", "\u03D1");
        html5Entities.put("thetav", "\u03D1");
        html5Entities.put("thickapprox", "\u2248");
        html5Entities.put("thicksim", "\u223C");
        html5Entities.put("ThickSpace", "\u205F\u200A");
        html5Entities.put("ThinSpace", "\u2009");
        html5Entities.put("thinsp", "\u2009");
        html5Entities.put("thkap", "\u2248");
        html5Entities.put("thksim", "\u223C");
        html5Entities.put("THORN", "\u00DE");
        html5Entities.put("thorn", "\u00FE");
        html5Entities.put("tilde", "\u02DC");
        html5Entities.put("Tilde", "\u223C");
        html5Entities.put("TildeEqual", "\u2243");
        html5Entities.put("TildeFullEqual", "\u2245");
        html5Entities.put("TildeTilde", "\u2248");
        html5Entities.put("timesbar", "\u2A31");
        html5Entities.put("timesb", "\u22A0");
        html5Entities.put("times", "\u00D7");
        html5Entities.put("timesd", "\u2A30");
        html5Entities.put("tint", "\u222D");
        html5Entities.put("toea", "\u2928");
        html5Entities.put("topbot", "\u2336");
        html5Entities.put("topcir", "\u2AF1");
        html5Entities.put("top", "\u22A4");
        html5Entities.put("Topf", "\uD835\uDD4B");
        html5Entities.put("topf", "\uD835\uDD65");
        html5Entities.put("topfork", "\u2ADA");
        html5Entities.put("tosa", "\u2929");
        html5Entities.put("tprime", "\u2034");
        html5Entities.put("trade", "\u2122");
        html5Entities.put("TRADE", "\u2122");
        html5Entities.put("triangle", "\u25B5");
        html5Entities.put("triangledown", "\u25BF");
        html5Entities.put("triangleleft", "\u25C3");
        html5Entities.put("trianglelefteq", "\u22B4");
        html5Entities.put("triangleq", "\u225C");
        html5Entities.put("triangleright", "\u25B9");
        html5Entities.put("trianglerighteq", "\u22B5");
        html5Entities.put("tridot", "\u25EC");
        html5Entities.put("trie", "\u225C");
        html5Entities.put("triminus", "\u2A3A");
        html5Entities.put("TripleDot", "\u20DB");
        html5Entities.put("triplus", "\u2A39");
        html5Entities.put("trisb", "\u29CD");
        html5Entities.put("tritime", "\u2A3B");
        html5Entities.put("trpezium", "\u23E2");
        html5Entities.put("Tscr", "\uD835\uDCAF");
        html5Entities.put("tscr", "\uD835\uDCC9");
        html5Entities.put("TScy", "\u0426");
        html5Entities.put("tscy", "\u0446");
        html5Entities.put("TSHcy", "\u040B");
        html5Entities.put("tshcy", "\u045B");
        html5Entities.put("Tstrok", "\u0166");
        html5Entities.put("tstrok", "\u0167");
        html5Entities.put("twixt", "\u226C");
        html5Entities.put("twoheadleftarrow", "\u219E");
        html5Entities.put("twoheadrightarrow", "\u21A0");
        html5Entities.put("Uacute", "\u00DA");
        html5Entities.put("uacute", "\u00FA");
        html5Entities.put("uarr", "\u2191");
        html5Entities.put("Uarr", "\u219F");
        html5Entities.put("uArr", "\u21D1");
        html5Entities.put("Uarrocir", "\u2949");
        html5Entities.put("Ubrcy", "\u040E");
        html5Entities.put("ubrcy", "\u045E");
        html5Entities.put("Ubreve", "\u016C");
        html5Entities.put("ubreve", "\u016D");
        html5Entities.put("Ucirc", "\u00DB");
        html5Entities.put("ucirc", "\u00FB");
        html5Entities.put("Ucy", "\u0423");
        html5Entities.put("ucy", "\u0443");
        html5Entities.put("udarr", "\u21C5");
        html5Entities.put("Udblac", "\u0170");
        html5Entities.put("udblac", "\u0171");
        html5Entities.put("udhar", "\u296E");
        html5Entities.put("ufisht", "\u297E");
        html5Entities.put("Ufr", "\uD835\uDD18");
        html5Entities.put("ufr", "\uD835\uDD32");
        html5Entities.put("Ugrave", "\u00D9");
        html5Entities.put("ugrave", "\u00F9");
        html5Entities.put("uHar", "\u2963");
        html5Entities.put("uharl", "\u21BF");
        html5Entities.put("uharr", "\u21BE");
        html5Entities.put("uhblk", "\u2580");
        html5Entities.put("ulcorn", "\u231C");
        html5Entities.put("ulcorner", "\u231C");
        html5Entities.put("ulcrop", "\u230F");
        html5Entities.put("ultri", "\u25F8");
        html5Entities.put("Umacr", "\u016A");
        html5Entities.put("umacr", "\u016B");
        html5Entities.put("uml", "\u00A8");
        html5Entities.put("UnderBar", "\u005F");
        html5Entities.put("UnderBrace", "\u23DF");
        html5Entities.put("UnderBracket", "\u23B5");
        html5Entities.put("UnderParenthesis", "\u23DD");
        html5Entities.put("Union", "\u22C3");
        html5Entities.put("UnionPlus", "\u228E");
        html5Entities.put("Uogon", "\u0172");
        html5Entities.put("uogon", "\u0173");
        html5Entities.put("Uopf", "\uD835\uDD4C");
        html5Entities.put("uopf", "\uD835\uDD66");
        html5Entities.put("UpArrowBar", "\u2912");
        html5Entities.put("uparrow", "\u2191");
        html5Entities.put("UpArrow", "\u2191");
        html5Entities.put("Uparrow", "\u21D1");
        html5Entities.put("UpArrowDownArrow", "\u21C5");
        html5Entities.put("updownarrow", "\u2195");
        html5Entities.put("UpDownArrow", "\u2195");
        html5Entities.put("Updownarrow", "\u21D5");
        html5Entities.put("UpEquilibrium", "\u296E");
        html5Entities.put("upharpoonleft", "\u21BF");
        html5Entities.put("upharpoonright", "\u21BE");
        html5Entities.put("uplus", "\u228E");
        html5Entities.put("UpperLeftArrow", "\u2196");
        html5Entities.put("UpperRightArrow", "\u2197");
        html5Entities.put("upsi", "\u03C5");
        html5Entities.put("Upsi", "\u03D2");
        html5Entities.put("upsih", "\u03D2");
        html5Entities.put("Upsilon", "\u03A5");
        html5Entities.put("upsilon", "\u03C5");
        html5Entities.put("UpTeeArrow", "\u21A5");
        html5Entities.put("UpTee", "\u22A5");
        html5Entities.put("upuparrows", "\u21C8");
        html5Entities.put("urcorn", "\u231D");
        html5Entities.put("urcorner", "\u231D");
        html5Entities.put("urcrop", "\u230E");
        html5Entities.put("Uring", "\u016E");
        html5Entities.put("uring", "\u016F");
        html5Entities.put("urtri", "\u25F9");
        html5Entities.put("Uscr", "\uD835\uDCB0");
        html5Entities.put("uscr", "\uD835\uDCCA");
        html5Entities.put("utdot", "\u22F0");
        html5Entities.put("Utilde", "\u0168");
        html5Entities.put("utilde", "\u0169");
        html5Entities.put("utri", "\u25B5");
        html5Entities.put("utrif", "\u25B4");
        html5Entities.put("uuarr", "\u21C8");
        html5Entities.put("Uuml", "\u00DC");
        html5Entities.put("uuml", "\u00FC");
        html5Entities.put("uwangle", "\u29A7");
        html5Entities.put("vangrt", "\u299C");
        html5Entities.put("varepsilon", "\u03F5");
        html5Entities.put("varkappa", "\u03F0");
        html5Entities.put("varnothing", "\u2205");
        html5Entities.put("varphi", "\u03D5");
        html5Entities.put("varpi", "\u03D6");
        html5Entities.put("varpropto", "\u221D");
        html5Entities.put("varr", "\u2195");
        html5Entities.put("vArr", "\u21D5");
        html5Entities.put("varrho", "\u03F1");
        html5Entities.put("varsigma", "\u03C2");
        html5Entities.put("varsubsetneq", "\u228A\uFE00");
        html5Entities.put("varsubsetneqq", "\u2ACB\uFE00");
        html5Entities.put("varsupsetneq", "\u228B\uFE00");
        html5Entities.put("varsupsetneqq", "\u2ACC\uFE00");
        html5Entities.put("vartheta", "\u03D1");
        html5Entities.put("vartriangleleft", "\u22B2");
        html5Entities.put("vartriangleright", "\u22B3");
        html5Entities.put("vBar", "\u2AE8");
        html5Entities.put("Vbar", "\u2AEB");
        html5Entities.put("vBarv", "\u2AE9");
        html5Entities.put("Vcy", "\u0412");
        html5Entities.put("vcy", "\u0432");
        html5Entities.put("vdash", "\u22A2");
        html5Entities.put("vDash", "\u22A8");
        html5Entities.put("Vdash", "\u22A9");
        html5Entities.put("VDash", "\u22AB");
        html5Entities.put("Vdashl", "\u2AE6");
        html5Entities.put("veebar", "\u22BB");
        html5Entities.put("vee", "\u2228");
        html5Entities.put("Vee", "\u22C1");
        html5Entities.put("veeeq", "\u225A");
        html5Entities.put("vellip", "\u22EE");
        html5Entities.put("verbar", "\u007C");
        html5Entities.put("Verbar", "\u2016");
        html5Entities.put("vert", "\u007C");
        html5Entities.put("Vert", "\u2016");
        html5Entities.put("VerticalBar", "\u2223");
        html5Entities.put("VerticalLine", "\u007C");
        html5Entities.put("VerticalSeparator", "\u2758");
        html5Entities.put("VerticalTilde", "\u2240");
        html5Entities.put("VeryThinSpace", "\u200A");
        html5Entities.put("Vfr", "\uD835\uDD19");
        html5Entities.put("vfr", "\uD835\uDD33");
        html5Entities.put("vltri", "\u22B2");
        html5Entities.put("vnsub", "\u2282\u20D2");
        html5Entities.put("vnsup", "\u2283\u20D2");
        html5Entities.put("Vopf", "\uD835\uDD4D");
        html5Entities.put("vopf", "\uD835\uDD67");
        html5Entities.put("vprop", "\u221D");
        html5Entities.put("vrtri", "\u22B3");
        html5Entities.put("Vscr", "\uD835\uDCB1");
        html5Entities.put("vscr", "\uD835\uDCCB");
        html5Entities.put("vsubnE", "\u2ACB\uFE00");
        html5Entities.put("vsubne", "\u228A\uFE00");
        html5Entities.put("vsupnE", "\u2ACC\uFE00");
        html5Entities.put("vsupne", "\u228B\uFE00");
        html5Entities.put("Vvdash", "\u22AA");
        html5Entities.put("vzigzag", "\u299A");
        html5Entities.put("Wcirc", "\u0174");
        html5Entities.put("wcirc", "\u0175");
        html5Entities.put("wedbar", "\u2A5F");
        html5Entities.put("wedge", "\u2227");
        html5Entities.put("Wedge", "\u22C0");
        html5Entities.put("wedgeq", "\u2259");
        html5Entities.put("weierp", "\u2118");
        html5Entities.put("Wfr", "\uD835\uDD1A");
        html5Entities.put("wfr", "\uD835\uDD34");
        html5Entities.put("Wopf", "\uD835\uDD4E");
        html5Entities.put("wopf", "\uD835\uDD68");
        html5Entities.put("wp", "\u2118");
        html5Entities.put("wr", "\u2240");
        html5Entities.put("wreath", "\u2240");
        html5Entities.put("Wscr", "\uD835\uDCB2");
        html5Entities.put("wscr", "\uD835\uDCCC");
        html5Entities.put("xcap", "\u22C2");
        html5Entities.put("xcirc", "\u25EF");
        html5Entities.put("xcup", "\u22C3");
        html5Entities.put("xdtri", "\u25BD");
        html5Entities.put("Xfr", "\uD835\uDD1B");
        html5Entities.put("xfr", "\uD835\uDD35");
        html5Entities.put("xharr", "\u27F7");
        html5Entities.put("xhArr", "\u27FA");
        html5Entities.put("Xi", "\u039E");
        html5Entities.put("xi", "\u03BE");
        html5Entities.put("xlarr", "\u27F5");
        html5Entities.put("xlArr", "\u27F8");
        html5Entities.put("xmap", "\u27FC");
        html5Entities.put("xnis", "\u22FB");
        html5Entities.put("xodot", "\u2A00");
        html5Entities.put("Xopf", "\uD835\uDD4F");
        html5Entities.put("xopf", "\uD835\uDD69");
        html5Entities.put("xoplus", "\u2A01");
        html5Entities.put("xotime", "\u2A02");
        html5Entities.put("xrarr", "\u27F6");
        html5Entities.put("xrArr", "\u27F9");
        html5Entities.put("Xscr", "\uD835\uDCB3");
        html5Entities.put("xscr", "\uD835\uDCCD");
        html5Entities.put("xsqcup", "\u2A06");
        html5Entities.put("xuplus", "\u2A04");
        html5Entities.put("xutri", "\u25B3");
        html5Entities.put("xvee", "\u22C1");
        html5Entities.put("xwedge", "\u22C0");
        html5Entities.put("Yacute", "\u00DD");
        html5Entities.put("yacute", "\u00FD");
        html5Entities.put("YAcy", "\u042F");
        html5Entities.put("yacy", "\u044F");
        html5Entities.put("Ycirc", "\u0176");
        html5Entities.put("ycirc", "\u0177");
        html5Entities.put("Ycy", "\u042B");
        html5Entities.put("ycy", "\u044B");
        html5Entities.put("yen", "\u00A5");
        html5Entities.put("Yfr", "\uD835\uDD1C");
        html5Entities.put("yfr", "\uD835\uDD36");
        html5Entities.put("YIcy", "\u0407");
        html5Entities.put("yicy", "\u0457");
        html5Entities.put("Yopf", "\uD835\uDD50");
        html5Entities.put("yopf", "\uD835\uDD6A");
        html5Entities.put("Yscr", "\uD835\uDCB4");
        html5Entities.put("yscr", "\uD835\uDCCE");
        html5Entities.put("YUcy", "\u042E");
        html5Entities.put("yucy", "\u044E");
        html5Entities.put("yuml", "\u00FF");
        html5Entities.put("Yuml", "\u0178");
        html5Entities.put("Zacute", "\u0179");
        html5Entities.put("zacute", "\u017A");
        html5Entities.put("Zcaron", "\u017D");
        html5Entities.put("zcaron", "\u017E");
        html5Entities.put("Zcy", "\u0417");
        html5Entities.put("zcy", "\u0437");
        html5Entities.put("Zdot", "\u017B");
        html5Entities.put("zdot", "\u017C");
        html5Entities.put("zeetrf", "\u2128");
        html5Entities.put("ZeroWidthSpace", "\u200B");
        html5Entities.put("Zeta", "\u0396");
        html5Entities.put("zeta", "\u03B6");
        html5Entities.put("zfr", "\uD835\uDD37");
        html5Entities.put("Zfr", "\u2128");
        html5Entities.put("ZHcy", "\u0416");
        html5Entities.put("zhcy", "\u0436");
        html5Entities.put("zigrarr", "\u21DD");
        html5Entities.put("zopf", "\uD835\uDD6B");
        html5Entities.put("Zopf", "\u2124");
        html5Entities.put("Zscr", "\uD835\uDCB5");
        html5Entities.put("zscr", "\uD835\uDCCF");
        html5Entities.put("zwj", "\u200D");
        html5Entities.put("zwnj", "\u200C");
    }

    public static boolean isValid(String name) {
        return html5Entities.containsKey(name);
    }

    public static boolean isValid(int code) {
        // See https://www.w3.org/TR/html52/syntax.html#character-references
        return Character.isDefined(code)
                && (!Character.isISOControl(code) || Character.isSpaceChar(code))
                && (code < 0xd800 || code > 0xdfff);
    }

    public static String getValue(String name) {
        return html5Entities.get(name);
    }
}
