/*
 * Copyright (c) 2011, 2016, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package java.lang.invoke;

import jdk.internal.misc.Unsafe;
import sun.security.action.GetPropertyAction;

import java.util.Properties;

/**
 * This class consists exclusively of static names internal to the
 * method handle implementation.
 * Usage:  {@code import static java.lang.invoke.MethodHandleStatics.*}
 * @author John Rose, JSR 292 EG
 */
/*non-public*/
class MethodHandleStatics {

    private MethodHandleStatics() { }  // do not instantiate

    static final Unsafe UNSAFE = Unsafe.getUnsafe();

    static final boolean DEBUG_METHOD_HANDLE_NAMES;
    static final boolean DUMP_CLASS_FILES;
    static final boolean TRACE_INTERPRETER;
    static final boolean TRACE_METHOD_LINKAGE;
    static final boolean TRACE_RESOLVE;
    static final int COMPILE_THRESHOLD;
    static final boolean LOG_LF_COMPILATION_FAILURE;
    static final int DONT_INLINE_THRESHOLD;
    static final int PROFILE_LEVEL;
    static final boolean PROFILE_GWT;
    static final int CUSTOMIZE_THRESHOLD;
    static final boolean VAR_HANDLE_GUARDS;
    static final int MAX_ARITY;

    static {
        Properties props = GetPropertyAction.privilegedGetProperties();
        DEBUG_METHOD_HANDLE_NAMES = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.DEBUG_NAMES"));
        DUMP_CLASS_FILES = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.DUMP_CLASS_FILES"));
        TRACE_INTERPRETER = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.TRACE_INTERPRETER"));
        TRACE_METHOD_LINKAGE = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.TRACE_METHOD_LINKAGE"));
        TRACE_RESOLVE = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.TRACE_RESOLVE"));
        COMPILE_THRESHOLD = Integer.parseInt(
                props.getProperty("java.lang.invoke.MethodHandle.COMPILE_THRESHOLD", "0"));
        LOG_LF_COMPILATION_FAILURE = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.LOG_LF_COMPILATION_FAILURE", "false"));
        DONT_INLINE_THRESHOLD = Integer.parseInt(
                props.getProperty("java.lang.invoke.MethodHandle.DONT_INLINE_THRESHOLD", "30"));
        PROFILE_LEVEL = Integer.parseInt(
                props.getProperty("java.lang.invoke.MethodHandle.PROFILE_LEVEL", "0"));
        PROFILE_GWT = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.MethodHandle.PROFILE_GWT", "true"));
        CUSTOMIZE_THRESHOLD = Integer.parseInt(
                props.getProperty("java.lang.invoke.MethodHandle.CUSTOMIZE_THRESHOLD", "127"));
        VAR_HANDLE_GUARDS = Boolean.parseBoolean(
                props.getProperty("java.lang.invoke.VarHandle.VAR_HANDLE_GUARDS", "true"));

        // Do not adjust this except for special platforms:
        MAX_ARITY = Integer.parseInt(
                props.getProperty("java.lang.invoke.MethodHandleImpl.MAX_ARITY", "255"));

        if (CUSTOMIZE_THRESHOLD < -1 || CUSTOMIZE_THRESHOLD > 127) {
            throw newInternalError("CUSTOMIZE_THRESHOLD should be in [-1...127] range");
        }
    }

    /** Tell if any of the debugging switches are turned on.
     *  If this is the case, it is reasonable to perform extra checks or save extra information.
     */
    /*non-public*/
    static boolean debugEnabled() {
        return (DEBUG_METHOD_HANDLE_NAMES |
                DUMP_CLASS_FILES |
                TRACE_INTERPRETER |
                TRACE_METHOD_LINKAGE |
                LOG_LF_COMPILATION_FAILURE);
    }

    // handy shared exception makers (they simplify the common case code)
    /*non-public*/
    static InternalError newInternalError(String message) {
        return new InternalError(message);
    }
    /*non-public*/
    static InternalError newInternalError(String message, Exception cause) {
        return new InternalError(message, cause);
    }
    /*non-public*/
    static InternalError newInternalError(Exception cause) {
        return new InternalError(cause);
    }
    /*non-public*/
    static RuntimeException newIllegalStateException(String message) {
        return new IllegalStateException(message);
    }
    /*non-public*/
    static RuntimeException newIllegalStateException(String message, Object obj) {
        return new IllegalStateException(message(message, obj));
    }
    /*non-public*/
    static RuntimeException newIllegalArgumentException(String message) {
        return new IllegalArgumentException(message);
    }
    /*non-public*/
    static RuntimeException newIllegalArgumentException(String message, Object obj) {
        return new IllegalArgumentException(message(message, obj));
    }
    /*non-public*/
    static RuntimeException newIllegalArgumentException(String message, Object obj, Object obj2) {
        return new IllegalArgumentException(message(message, obj, obj2));
    }
    /** Propagate unchecked exceptions and errors, but wrap anything checked and throw that instead. */
    /*non-public*/
    static Error uncaughtException(Throwable ex) {
        if (ex instanceof Error)  throw (Error) ex;
        if (ex instanceof RuntimeException)  throw (RuntimeException) ex;
        throw new InternalError("uncaught exception", ex);
    }
    private static String message(String message, Object obj) {
        if (obj != null)  message = message + ": " + obj;
        return message;
    }
    private static String message(String message, Object obj, Object obj2) {
        if (obj != null || obj2 != null)  message = message + ": " + obj + ", " + obj2;
        return message;
    }
    /*non-public*/
    static void rangeCheck2(int start, int end, int size) {
        if (0 > start || start > end || end > size)
            throw new IndexOutOfBoundsException(start+".."+end);
    }
    /*non-public*/
    static int rangeCheck1(int index, int size) {
        if (0 > index || index >= size)
            throw new IndexOutOfBoundsException(index);
        return index;
    }
}
