/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter.qual;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum I18nConversionCategory {
    UNUSED(null, null),
    GENERAL(null, null),
    DATE(new Class[]{Date.class, Number.class}, new String[]{"date", "time"}),
    NUMBER(new Class[]{Number.class}, new String[]{"number", "choice"});

    public final Class<? extends Object>[] types;
    public final String[] strings;
    static I18nConversionCategory[] namedCategories;

    private I18nConversionCategory(Class<? extends Object>[] types, String[] strings) {
        this.types = types;
        this.strings = strings;
    }

    public static I18nConversionCategory stringToI18nConversionCategory(String string) {
        string = string.toLowerCase();
        for (I18nConversionCategory v4 : namedCategories) {
            for (String s4 : v4.strings) {
                if (!s4.equals(string)) continue;
                return v4;
            }
        }
        throw new IllegalArgumentException("Invalid format type " + string);
    }

    private static <E> Set<E> arrayToSet(E[] a5) {
        return new HashSet<E>(Arrays.asList(a5));
    }

    public static boolean isSubsetOf(I18nConversionCategory a5, I18nConversionCategory b4) {
        return I18nConversionCategory.intersect(a5, b4) == a5;
    }

    public static I18nConversionCategory intersect(I18nConversionCategory a5, I18nConversionCategory b4) {
        if (a5 == UNUSED) {
            return b4;
        }
        if (b4 == UNUSED) {
            return a5;
        }
        if (a5 == GENERAL) {
            return b4;
        }
        if (b4 == GENERAL) {
            return a5;
        }
        Set<Class<? extends Object>> as = I18nConversionCategory.arrayToSet(a5.types);
        Set<Class<? extends Object>> bs = I18nConversionCategory.arrayToSet(b4.types);
        as.retainAll(bs);
        for (I18nConversionCategory v4 : new I18nConversionCategory[]{DATE, NUMBER}) {
            Set<Class<? extends Object>> vs = I18nConversionCategory.arrayToSet(v4.types);
            if (!vs.equals(as)) continue;
            return v4;
        }
        throw new RuntimeException();
    }

    public static I18nConversionCategory union(I18nConversionCategory a5, I18nConversionCategory b4) {
        if (a5 == UNUSED || b4 == UNUSED) {
            return UNUSED;
        }
        if (a5 == GENERAL || b4 == GENERAL) {
            return GENERAL;
        }
        if (a5 == DATE || b4 == DATE) {
            return DATE;
        }
        return NUMBER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        if (this.types == null) {
            sb.append(" conversion category (all types)");
        } else {
            sb.append(" conversion category (one of: ");
            boolean first = true;
            for (Class<? extends Object> cls : this.types) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(cls.getCanonicalName());
                first = false;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    static {
        namedCategories = new I18nConversionCategory[]{DATE, NUMBER};
    }
}

