/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.io.StreamOverflowException;

public final class Streams {
    private static int BUFFER_SIZE = 4096;

    public static void drain(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[BUFFER_SIZE];
        while (inputStream.read(byArray, 0, byArray.length) >= 0) {
        }
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readAllLimited(InputStream inputStream, int n4) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAllLimited(inputStream, n4, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return Streams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        int n7;
        for (n6 = 0; n6 < n5 && (n7 = inputStream.read(byArray, n4 + n6, n5 - n6)) >= 0; n6 += n7) {
        }
        return n6;
    }

    public static void pipeAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n4;
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n4 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            outputStream.write(byArray, 0, n4);
        }
    }

    public static long pipeAllLimited(InputStream inputStream, long l4, OutputStream outputStream) throws IOException {
        int n4;
        long l5 = 0L;
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n4 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            if (l4 - l5 < (long)n4) {
                throw new StreamOverflowException("Data Overflow");
            }
            l5 += (long)n4;
            outputStream.write(byArray, 0, n4);
        }
        return l5;
    }

    public static void writeBufTo(ByteArrayOutputStream byteArrayOutputStream, OutputStream outputStream) throws IOException {
        byteArrayOutputStream.writeTo(outputStream);
    }
}

