/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Encoder;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n4;
        for (n4 = 0; n4 < this.decodingTable.length; ++n4) {
            this.decodingTable[n4] = -1;
        }
        for (n4 = 0; n4 < this.encodingTable.length; ++n4) {
            this.decodingTable[this.encodingTable[n4]] = (byte)n4;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] byArray, int n4, int n5, OutputStream outputStream) throws IOException {
        for (int i4 = n4; i4 < n4 + n5; ++i4) {
            int n6 = byArray[i4] & 0xFF;
            outputStream.write(this.encodingTable[n6 >>> 4]);
            outputStream.write(this.encodingTable[n6 & 0xF]);
        }
        return n5 * 2;
    }

    private static boolean ignore(char c4) {
        return c4 == '\n' || c4 == '\r' || c4 == '\t' || c4 == ' ';
    }

    public int decode(byte[] byArray, int n4, int n5, OutputStream outputStream) throws IOException {
        int n6;
        int n7 = 0;
        for (n6 = n4 + n5; n6 > n4 && HexEncoder.ignore((char)byArray[n6 - 1]); --n6) {
        }
        int n8 = n4;
        while (n8 < n6) {
            byte by;
            while (n8 < n6 && HexEncoder.ignore((char)byArray[n8])) {
                ++n8;
            }
            byte by2 = this.decodingTable[byArray[n8++]];
            while (n8 < n6 && HexEncoder.ignore((char)byArray[n8])) {
                ++n8;
            }
            if ((by2 | (by = this.decodingTable[byArray[n8++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            outputStream.write(by2 << 4 | by);
            ++n7;
        }
        return n7;
    }

    public int decode(String string, OutputStream outputStream) throws IOException {
        int n4;
        int n5 = 0;
        for (n4 = string.length(); n4 > 0 && HexEncoder.ignore(string.charAt(n4 - 1)); --n4) {
        }
        int n6 = 0;
        while (n6 < n4) {
            byte by;
            while (n6 < n4 && HexEncoder.ignore(string.charAt(n6))) {
                ++n6;
            }
            byte by2 = this.decodingTable[string.charAt(n6++)];
            while (n6 < n4 && HexEncoder.ignore(string.charAt(n6))) {
                ++n6;
            }
            if ((by2 | (by = this.decodingTable[string.charAt(n6++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            outputStream.write(by2 << 4 | by);
            ++n5;
        }
        return n5;
    }
}

