/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

public final class PolynomialRingGF2 {
    private PolynomialRingGF2() {
    }

    public static int add(int n4, int n5) {
        return n4 ^ n5;
    }

    public static long multiply(int n4, int n5) {
        long l4 = 0L;
        if (n5 != 0) {
            long l5 = (long)n5 & 0xFFFFFFFFL;
            while (n4 != 0) {
                byte by = (byte)(n4 & 1);
                if (by == 1) {
                    l4 ^= l5;
                }
                n4 >>>= 1;
                l5 <<= 1;
            }
        }
        return l4;
    }

    public static int modMultiply(int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = PolynomialRingGF2.remainder(n4, n6);
        int n9 = PolynomialRingGF2.remainder(n5, n6);
        if (n9 != 0) {
            int n10 = 1 << PolynomialRingGF2.degree(n6);
            while (n8 != 0) {
                byte by = (byte)(n8 & 1);
                if (by == 1) {
                    n7 ^= n9;
                }
                n8 >>>= 1;
                if ((n9 <<= 1) < n10) continue;
                n9 ^= n6;
            }
        }
        return n7;
    }

    public static int degree(int n4) {
        int n5 = -1;
        while (n4 != 0) {
            ++n5;
            n4 >>>= 1;
        }
        return n5;
    }

    public static int degree(long l4) {
        int n4 = 0;
        while (l4 != 0L) {
            ++n4;
            l4 >>>= 1;
        }
        return n4 - 1;
    }

    public static int remainder(int n4, int n5) {
        int n6 = n4;
        if (n5 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        while (PolynomialRingGF2.degree(n6) >= PolynomialRingGF2.degree(n5)) {
            n6 ^= n5 << PolynomialRingGF2.degree(n6) - PolynomialRingGF2.degree(n5);
        }
        return n6;
    }

    public static int rest(long l4, int n4) {
        long l5 = l4;
        if (n4 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        long l6 = (long)n4 & 0xFFFFFFFFL;
        while (l5 >>> 32 != 0L) {
            l5 ^= l6 << PolynomialRingGF2.degree(l5) - PolynomialRingGF2.degree(l6);
        }
        int n5 = (int)(l5 & 0xFFFFFFFFFFFFFFFFL);
        while (PolynomialRingGF2.degree(n5) >= PolynomialRingGF2.degree(n4)) {
            n5 ^= n4 << PolynomialRingGF2.degree(n5) - PolynomialRingGF2.degree(n4);
        }
        return n5;
    }

    public static int gcd(int n4, int n5) {
        int n6 = n4;
        int n7 = n5;
        while (n7 != 0) {
            int n8 = PolynomialRingGF2.remainder(n6, n7);
            n6 = n7;
            n7 = n8;
        }
        return n6;
    }

    public static boolean isIrreducible(int n4) {
        if (n4 == 0) {
            return false;
        }
        int n5 = PolynomialRingGF2.degree(n4) >>> 1;
        int n6 = 2;
        for (int i4 = 0; i4 < n5; ++i4) {
            if (PolynomialRingGF2.gcd((n6 = PolynomialRingGF2.modMultiply(n6, n6, n4)) ^ 2, n4) == 1) continue;
            return false;
        }
        return true;
    }

    public static int getIrreduciblePolynomial(int n4) {
        if (n4 < 0) {
            System.err.println("The Degree is negative");
            return 0;
        }
        if (n4 > 31) {
            System.err.println("The Degree is more then 31");
            return 0;
        }
        if (n4 == 0) {
            return 1;
        }
        int n5 = 1 << n4;
        int n6 = 1 << n4 + 1;
        for (int i4 = ++n5; i4 < n6; i4 += 2) {
            if (!PolynomialRingGF2.isIrreducible(i4)) continue;
            return i4;
        }
        return 0;
    }
}

