/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public final class GoppaCode {
    private GoppaCode() {
    }

    public static GF2Matrix createCanonicalCheckMatrix(GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int n4;
        int n5;
        int n6;
        int n7 = gF2mField.getDegree();
        int n8 = 1 << n7;
        int n9 = polynomialGF2mSmallM.getDegree();
        int[][] nArray = new int[n9][n8];
        int[][] nArray2 = new int[n9][n8];
        for (n6 = 0; n6 < n8; ++n6) {
            nArray2[0][n6] = gF2mField.inverse(polynomialGF2mSmallM.evaluateAt(n6));
        }
        for (n6 = 1; n6 < n9; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                nArray2[n6][n5] = gF2mField.mult(nArray2[n6 - 1][n5], n5);
            }
        }
        for (n6 = 0; n6 < n9; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                for (n4 = 0; n4 <= n6; ++n4) {
                    nArray[n6][n5] = gF2mField.add(nArray[n6][n5], gF2mField.mult(nArray2[n4][n5], polynomialGF2mSmallM.getCoefficient(n9 + n4 - n6)));
                }
            }
        }
        int[][] nArray3 = new int[n9 * n7][n8 + 31 >>> 5];
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = n5 >>> 5;
            int n10 = 1 << (n5 & 0x1F);
            for (int i4 = 0; i4 < n9; ++i4) {
                int n11 = nArray[i4][n5];
                for (int i5 = 0; i5 < n7; ++i5) {
                    int n12 = n11 >>> i5 & 1;
                    if (n12 == 0) continue;
                    int n13 = (i4 + 1) * n7 - i5 - 1;
                    int[] nArray4 = nArray3[n13];
                    int n14 = n4;
                    nArray4[n14] = nArray4[n14] ^ n10;
                }
            }
        }
        return new GF2Matrix(n8, nArray3);
    }

    public static MaMaPe computeSystematicForm(GF2Matrix gF2Matrix, SecureRandom secureRandom) {
        GF2Matrix gF2Matrix2;
        GF2Matrix gF2Matrix3;
        Permutation permutation;
        int n4 = gF2Matrix.getNumColumns();
        GF2Matrix gF2Matrix4 = null;
        boolean bl = false;
        do {
            permutation = new Permutation(n4, secureRandom);
            gF2Matrix3 = (GF2Matrix)gF2Matrix.rightMultiply(permutation);
            gF2Matrix2 = gF2Matrix3.getLeftSubMatrix();
            try {
                bl = true;
                gF2Matrix4 = (GF2Matrix)gF2Matrix2.computeInverse();
            }
            catch (ArithmeticException arithmeticException) {
                bl = false;
            }
        } while (!bl);
        GF2Matrix gF2Matrix5 = (GF2Matrix)gF2Matrix4.rightMultiply(gF2Matrix3);
        GF2Matrix gF2Matrix6 = gF2Matrix5.getRightSubMatrix();
        return new MaMaPe(gF2Matrix2, gF2Matrix6, permutation);
    }

    public static GF2Vector syndromeDecode(GF2Vector gF2Vector, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n4 = 1 << gF2mField.getDegree();
        GF2Vector gF2Vector2 = new GF2Vector(n4);
        if (!gF2Vector.isZero()) {
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(gF2Vector.toExtensionFieldVector(gF2mField));
            PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM2.modInverse(polynomialGF2mSmallM);
            PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM3.addMonomial(1);
            polynomialGF2mSmallM4 = polynomialGF2mSmallM4.modSquareRootMatrix(polynomialGF2mSmallMArray);
            PolynomialGF2mSmallM[] polynomialGF2mSmallMArray2 = polynomialGF2mSmallM4.modPolynomialToFracton(polynomialGF2mSmallM);
            PolynomialGF2mSmallM polynomialGF2mSmallM5 = polynomialGF2mSmallMArray2[0].multiply(polynomialGF2mSmallMArray2[0]);
            PolynomialGF2mSmallM polynomialGF2mSmallM6 = polynomialGF2mSmallMArray2[1].multiply(polynomialGF2mSmallMArray2[1]);
            PolynomialGF2mSmallM polynomialGF2mSmallM7 = polynomialGF2mSmallM6.multWithMonomial(1);
            PolynomialGF2mSmallM polynomialGF2mSmallM8 = polynomialGF2mSmallM5.add(polynomialGF2mSmallM7);
            int n5 = polynomialGF2mSmallM8.getHeadCoefficient();
            int n6 = gF2mField.inverse(n5);
            PolynomialGF2mSmallM polynomialGF2mSmallM9 = polynomialGF2mSmallM8.multWithElement(n6);
            for (int i4 = 0; i4 < n4; ++i4) {
                int n7 = polynomialGF2mSmallM9.evaluateAt(i4);
                if (n7 != 0) continue;
                gF2Vector2.setBit(i4);
            }
        }
        return gF2Vector2;
    }

    public static class MaMaPe {
        private GF2Matrix s;
        private GF2Matrix h;
        private Permutation p;

        public MaMaPe(GF2Matrix gF2Matrix, GF2Matrix gF2Matrix2, Permutation permutation) {
            this.s = gF2Matrix;
            this.h = gF2Matrix2;
            this.p = permutation;
        }

        public GF2Matrix getFirstMatrix() {
            return this.s;
        }

        public GF2Matrix getSecondMatrix() {
            return this.h;
        }

        public Permutation getPermutation() {
            return this.p;
        }
    }

    public static class MatrixSet {
        private GF2Matrix g;
        private int[] setJ;

        public MatrixSet(GF2Matrix gF2Matrix, int[] nArray) {
            this.g = gF2Matrix;
            this.setJ = nArray;
        }

        public GF2Matrix getG() {
            return this.g;
        }

        public int[] getSetJ() {
            return this.setJ;
        }
    }
}

