/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GFElement;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    public GF2nONBElement(GF2nONBField gF2nONBField, SecureRandom secureRandom) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            for (int i4 = 0; i4 < this.mLength - 1; ++i4) {
                this.mPol[i4] = secureRandom.nextLong();
            }
            long l4 = secureRandom.nextLong();
            this.mPol[this.mLength - 1] = l4 >>> 64 - this.mBit;
        } else {
            this.mPol[0] = secureRandom.nextLong();
            this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
        }
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, byte[] byArray) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(byArray);
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, BigInteger bigInteger) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(bigInteger);
    }

    private GF2nONBElement(GF2nONBField gF2nONBField, long[] lArray) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = lArray;
    }

    public GF2nONBElement(GF2nONBElement gF2nONBElement) {
        this.mField = gF2nONBElement.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gF2nONBElement.getElement());
    }

    public Object clone() {
        return new GF2nONBElement(this);
    }

    public static GF2nONBElement ZERO(GF2nONBField gF2nONBField) {
        long[] lArray = new long[gF2nONBField.getONBLength()];
        return new GF2nONBElement(gF2nONBField, lArray);
    }

    public static GF2nONBElement ONE(GF2nONBField gF2nONBField) {
        int n4 = gF2nONBField.getONBLength();
        long[] lArray = new long[n4];
        for (int i4 = 0; i4 < n4 - 1; ++i4) {
            lArray[i4] = -1L;
        }
        lArray[n4 - 1] = mMaxmask[gF2nONBField.getONBBit() - 1];
        return new GF2nONBElement(gF2nONBField, lArray);
    }

    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    void assignOne() {
        for (int i4 = 0; i4 < this.mLength - 1; ++i4) {
            this.mPol[i4] = -1L;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    private void assign(BigInteger bigInteger) {
        this.assign(bigInteger.toByteArray());
    }

    private void assign(long[] lArray) {
        System.arraycopy(lArray, 0, this.mPol, 0, this.mLength);
    }

    private void assign(byte[] byArray) {
        this.mPol = new long[this.mLength];
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            int n4 = i4 >>> 3;
            this.mPol[n4] = this.mPol[n4] | ((long)byArray[byArray.length - 1 - i4] & 0xFFL) << ((i4 & 7) << 3);
        }
    }

    public boolean isZero() {
        boolean bl = true;
        for (int i4 = 0; i4 < this.mLength && bl; ++i4) {
            bl = bl && (this.mPol[i4] & 0xFFFFFFFFFFFFFFFFL) == 0L;
        }
        return bl;
    }

    public boolean isOne() {
        boolean bl = true;
        for (int i4 = 0; i4 < this.mLength - 1 && bl; ++i4) {
            bl = bl && (this.mPol[i4] & 0xFFFFFFFFFFFFFFFFL) == -1L;
        }
        if (bl) {
            bl = bl && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement gF2nONBElement = (GF2nONBElement)object;
        for (int i4 = 0; i4 < this.mLength; ++i4) {
            if (this.mPol[i4] == gF2nONBElement.mPol[i4]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mPol.hashCode();
    }

    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    boolean testBit(int n4) {
        if (n4 < 0 || n4 > this.mDegree) {
            return false;
        }
        long l4 = this.mPol[n4 >>> 6] & mBitmask[n4 & 0x3F];
        return l4 != 0L;
    }

    private long[] getElement() {
        long[] lArray = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, lArray, 0, this.mPol.length);
        return lArray;
    }

    private long[] getElementReverseOrder() {
        long[] lArray = new long[this.mPol.length];
        for (int i4 = 0; i4 < this.mDegree; ++i4) {
            if (!this.testBit(this.mDegree - i4 - 1)) continue;
            int n4 = i4 >>> 6;
            lArray[n4] = lArray[n4] | mBitmask[i4 & 0x3F];
        }
        return lArray;
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    public GFElement add(GFElement gFElement) throws RuntimeException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.addToThis(gFElement);
        return gF2nONBElement;
    }

    public void addToThis(GFElement gFElement) throws RuntimeException {
        if (!(gFElement instanceof GF2nONBElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nONBElement)gFElement).mField)) {
            throw new RuntimeException();
        }
        for (int i4 = 0; i4 < this.mLength; ++i4) {
            int n4 = i4;
            this.mPol[n4] = this.mPol[n4] ^ ((GF2nONBElement)gFElement).mPol[i4];
        }
    }

    public GF2nElement increase() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.increaseThis();
        return gF2nONBElement;
    }

    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    public GFElement multiply(GFElement gFElement) throws RuntimeException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.multiplyThisBy(gFElement);
        return gF2nONBElement;
    }

    public void multiplyThisBy(GFElement gFElement) throws RuntimeException {
        if (!(gFElement instanceof GF2nONBElement)) {
            throw new RuntimeException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)gFElement).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(gFElement)) {
            this.squareThis();
        } else {
            long[] lArray = this.mPol;
            long[] lArray2 = ((GF2nONBElement)gFElement).mPol;
            long[] lArray3 = new long[this.mLength];
            int[][] nArray = ((GF2nONBField)this.mField).mMult;
            int n4 = this.mLength - 1;
            int n5 = this.mBit - 1;
            boolean bl = false;
            long l4 = mBitmask[63];
            long l5 = mBitmask[n5];
            for (int i4 = 0; i4 < this.mDegree; ++i4) {
                boolean bl2;
                int n6;
                int n7;
                int n8;
                bl = false;
                for (n8 = 0; n8 < this.mDegree; ++n8) {
                    n7 = mIBY64[n8];
                    n6 = n8 & 0x3F;
                    int n9 = mIBY64[nArray[n8][0]];
                    int n10 = nArray[n8][0] & 0x3F;
                    if ((lArray[n7] & mBitmask[n6]) == 0L) continue;
                    if ((lArray2[n9] & mBitmask[n10]) != 0L) {
                        bl ^= true;
                    }
                    if (nArray[n8][1] == -1 || (lArray2[n9 = mIBY64[nArray[n8][1]]] & mBitmask[n10 = nArray[n8][1] & 0x3F]) == 0L) continue;
                    bl ^= true;
                }
                n7 = mIBY64[i4];
                n6 = i4 & 0x3F;
                if (bl) {
                    int n11 = n7;
                    lArray3[n11] = lArray3[n11] ^ mBitmask[n6];
                }
                if (this.mLength > 1) {
                    boolean bl3;
                    bl2 = (lArray[n4] & 1L) == 1L;
                    for (n8 = n4 - 1; n8 >= 0; --n8) {
                        bl3 = (lArray[n8] & 1L) != 0L;
                        lArray[n8] = lArray[n8] >>> 1;
                        if (bl2) {
                            int n12 = n8;
                            lArray[n12] = lArray[n12] ^ l4;
                        }
                        bl2 = bl3;
                    }
                    lArray[n4] = lArray[n4] >>> 1;
                    if (bl2) {
                        int n13 = n4;
                        lArray[n13] = lArray[n13] ^ l5;
                    }
                    bl2 = (lArray2[n4] & 1L) == 1L;
                    for (n8 = n4 - 1; n8 >= 0; --n8) {
                        bl3 = (lArray2[n8] & 1L) != 0L;
                        lArray2[n8] = lArray2[n8] >>> 1;
                        if (bl2) {
                            int n14 = n8;
                            lArray2[n14] = lArray2[n14] ^ l4;
                        }
                        bl2 = bl3;
                    }
                    lArray2[n4] = lArray2[n4] >>> 1;
                    if (!bl2) continue;
                    int n15 = n4;
                    lArray2[n15] = lArray2[n15] ^ l5;
                    continue;
                }
                bl2 = (lArray[0] & 1L) == 1L;
                lArray[0] = lArray[0] >>> 1;
                if (bl2) {
                    lArray[0] = lArray[0] ^ l5;
                }
                bl2 = (lArray2[0] & 1L) == 1L;
                lArray2[0] = lArray2[0] >>> 1;
                if (!bl2) continue;
                lArray2[0] = lArray2[0] ^ l5;
            }
            this.assign(lArray3);
        }
    }

    public GF2nElement square() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.squareThis();
        return gF2nONBElement;
    }

    public void squareThis() {
        boolean bl;
        long[] lArray = this.getElement();
        int n4 = this.mLength - 1;
        int n5 = this.mBit - 1;
        long l4 = mBitmask[63];
        boolean bl2 = (lArray[n4] & mBitmask[n5]) != 0L;
        for (int i4 = 0; i4 < n4; ++i4) {
            bl = (lArray[i4] & l4) != 0L;
            lArray[i4] = lArray[i4] << 1;
            if (bl2) {
                int n6 = i4;
                lArray[n6] = lArray[n6] ^ 1L;
            }
            bl2 = bl;
        }
        bl = (lArray[n4] & mBitmask[n5]) != 0L;
        lArray[n4] = lArray[n4] << 1;
        if (bl2) {
            int n7 = n4;
            lArray[n7] = lArray[n7] ^ 1L;
        }
        if (bl) {
            int n8 = n4;
            lArray[n8] = lArray[n8] ^ mBitmask[n5 + 1];
        }
        this.assign(lArray);
    }

    public GFElement invert() throws ArithmeticException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.invertThis();
        return gF2nONBElement;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        boolean bl = false;
        for (int i4 = 31; !bl && i4 >= 0; --i4) {
            if (((long)(this.mDegree - 1) & mBitmask[i4]) == 0L) continue;
            bl = true;
        }
        GF2nElement gF2nElement = GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        int n4 = 1;
        for (int i5 = ++i4 - 1; i5 >= 0; --i5) {
            gF2nElement = (GF2nElement)((GF2nElement)gF2nONBElement).clone();
            for (int i6 = 1; i6 <= n4; ++i6) {
                gF2nElement.squareThis();
            }
            gF2nONBElement.multiplyThisBy(gF2nElement);
            n4 <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[i5]) == 0L) continue;
            ((GF2nElement)gF2nONBElement).squareThis();
            gF2nONBElement.multiplyThisBy(this);
            ++n4;
        }
        ((GF2nElement)gF2nONBElement).squareThis();
    }

    public GF2nElement squareRoot() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.squareRootThis();
        return gF2nONBElement;
    }

    public void squareRootThis() {
        long[] lArray = this.getElement();
        int n4 = this.mLength - 1;
        int n5 = this.mBit - 1;
        long l4 = mBitmask[63];
        boolean bl = (lArray[0] & 1L) != 0L;
        for (int i4 = n4; i4 >= 0; --i4) {
            boolean bl2 = (lArray[i4] & 1L) != 0L;
            lArray[i4] = lArray[i4] >>> 1;
            if (bl) {
                if (i4 == n4) {
                    int n6 = i4;
                    lArray[n6] = lArray[n6] ^ mBitmask[n5];
                } else {
                    int n7 = i4;
                    lArray[n7] = lArray[n7] ^ l4;
                }
            }
            bl = bl2;
        }
        this.assign(lArray);
    }

    public int trace() {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = this.mLength - 1;
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < 64; ++n4) {
                if ((this.mPol[n5] & mBitmask[n4]) == 0L) continue;
                n6 ^= 1;
            }
        }
        n5 = this.mBit;
        for (n4 = 0; n4 < n5; ++n4) {
            if ((this.mPol[n7] & mBitmask[n4]) == 0L) continue;
            n6 ^= 1;
        }
        return n6;
    }

    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        int n4;
        if (this.trace() == 1) {
            throw new RuntimeException();
        }
        long l4 = mBitmask[63];
        long l5 = 0L;
        long l6 = 1L;
        long[] lArray = new long[this.mLength];
        long l7 = 0L;
        int n5 = 1;
        for (n4 = 0; n4 < this.mLength - 1; ++n4) {
            for (n5 = 1; n5 < 64; ++n5) {
                if ((mBitmask[n5] & this.mPol[n4]) != l5 && (l7 & mBitmask[n5 - 1]) != l5 || (this.mPol[n4] & mBitmask[n5]) == l5 && (l7 & mBitmask[n5 - 1]) == l5) continue;
                l7 ^= mBitmask[n5];
            }
            lArray[n4] = l7;
            l7 = (l4 & l7) != l5 && (l6 & this.mPol[n4 + 1]) == l6 || (l4 & l7) == l5 && (l6 & this.mPol[n4 + 1]) == l5 ? l5 : l6;
        }
        n4 = this.mDegree & 0x3F;
        long l8 = this.mPol[this.mLength - 1];
        for (n5 = 1; n5 < n4; ++n5) {
            if ((mBitmask[n5] & l8) != l5 && (mBitmask[n5 - 1] & l7) != l5 || (mBitmask[n5] & l8) == l5 && (mBitmask[n5 - 1] & l7) == l5) continue;
            l7 ^= mBitmask[n5];
        }
        lArray[this.mLength - 1] = l7;
        return new GF2nONBElement((GF2nONBField)this.mField, lArray);
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int n4) {
        String string;
        block5: {
            long[] lArray;
            block4: {
                int n5;
                string = "";
                lArray = this.getElement();
                int n6 = this.mBit;
                if (n4 != 2) break block4;
                for (n5 = n6 - 1; n5 >= 0; --n5) {
                    string = (lArray[lArray.length - 1] & 1L << n5) == 0L ? string + "0" : string + "1";
                }
                for (n5 = lArray.length - 2; n5 >= 0; --n5) {
                    for (int i4 = 63; i4 >= 0; --i4) {
                        string = (lArray[n5] & mBitmask[i4]) == 0L ? string + "0" : string + "1";
                    }
                }
                break block5;
            }
            if (n4 != 16) break block5;
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            for (int i5 = lArray.length - 1; i5 >= 0; --i5) {
                string = string + cArray[(int)(lArray[i5] >>> 60) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 56) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 52) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 48) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 44) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 40) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 36) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 32) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 28) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 24) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 20) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 16) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 12) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 8) & 0xF];
                string = string + cArray[(int)(lArray[i5] >>> 4) & 0xF];
                string = string + cArray[(int)lArray[i5] & 0xF];
                string = string + " ";
            }
        }
        return string;
    }

    public BigInteger toFlexiBigInt() {
        return new BigInteger(1, this.toByteArray());
    }

    public byte[] toByteArray() {
        int n4 = (this.mDegree - 1 >> 3) + 1;
        byte[] byArray = new byte[n4];
        for (int i4 = 0; i4 < n4; ++i4) {
            byArray[n4 - i4 - 1] = (byte)((this.mPol[i4 >>> 3] & 255L << ((i4 & 7) << 3)) >>> ((i4 & 7) << 3));
        }
        return byArray;
    }
}

