/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincs;

import org.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import org.bouncycastle.pqc.crypto.sphincs.Seed;

class Wots {
    static final int WOTS_LOGW = 4;
    static final int WOTS_W = 16;
    static final int WOTS_L1 = 64;
    static final int WOTS_L = 67;
    static final int WOTS_LOG_L = 7;
    static final int WOTS_SIGBYTES = 2144;

    Wots() {
    }

    static void expand_seed(byte[] byArray, int n4, byte[] byArray2, int n5) {
        Wots.clear(byArray, n4, 2144);
        Seed.prg(byArray, n4, 2144L, byArray2, n5);
    }

    private static void clear(byte[] byArray, int n4, int n5) {
        for (int i4 = 0; i4 != n5; ++i4) {
            byArray[i4 + n4] = 0;
        }
    }

    static void gen_chain(HashFunctions hashFunctions, byte[] byArray, int n4, byte[] byArray2, int n5, byte[] byArray3, int n6, int n7) {
        for (int i4 = 0; i4 < 32; ++i4) {
            byArray[i4 + n4] = byArray2[i4 + n5];
        }
        for (int i5 = 0; i5 < n7 && i5 < 16; ++i5) {
            hashFunctions.hash_n_n_mask(byArray, n4, byArray, n4, byArray3, n6 + i5 * 32);
        }
    }

    void wots_pkgen(HashFunctions hashFunctions, byte[] byArray, int n4, byte[] byArray2, int n5, byte[] byArray3, int n6) {
        Wots.expand_seed(byArray, n4, byArray2, n5);
        for (int i4 = 0; i4 < 67; ++i4) {
            Wots.gen_chain(hashFunctions, byArray, n4 + i4 * 32, byArray, n4 + i4 * 32, byArray3, n6, 15);
        }
    }

    void wots_sign(HashFunctions hashFunctions, byte[] byArray, int n4, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n5;
        int[] nArray = new int[67];
        int n6 = 0;
        for (n5 = 0; n5 < 64; n5 += 2) {
            nArray[n5] = byArray2[n5 / 2] & 0xF;
            nArray[n5 + 1] = (byArray2[n5 / 2] & 0xFF) >>> 4;
            n6 += 15 - nArray[n5];
            n6 += 15 - nArray[n5 + 1];
        }
        while (n5 < 67) {
            nArray[n5] = n6 & 0xF;
            n6 >>>= 4;
            ++n5;
        }
        Wots.expand_seed(byArray, n4, byArray3, 0);
        for (n5 = 0; n5 < 67; ++n5) {
            Wots.gen_chain(hashFunctions, byArray, n4 + n5 * 32, byArray, n4 + n5 * 32, byArray4, 0, nArray[n5]);
        }
    }

    void wots_verify(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4) {
        int n5;
        int[] nArray = new int[67];
        int n6 = 0;
        for (n5 = 0; n5 < 64; n5 += 2) {
            nArray[n5] = byArray3[n5 / 2] & 0xF;
            nArray[n5 + 1] = (byArray3[n5 / 2] & 0xFF) >>> 4;
            n6 += 15 - nArray[n5];
            n6 += 15 - nArray[n5 + 1];
        }
        while (n5 < 67) {
            nArray[n5] = n6 & 0xF;
            n6 >>>= 4;
            ++n5;
        }
        for (n5 = 0; n5 < 67; ++n5) {
            Wots.gen_chain(hashFunctions, byArray, n5 * 32, byArray2, n4 + n5 * 32, byArray4, nArray[n5] * 32, 15 - nArray[n5]);
        }
    }
}

